/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.core;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import dev.latvian.mods.kubejs.bindings.DataComponentWrapper;
import dev.latvian.mods.kubejs.core.IngredientSupplierKJS;
import dev.latvian.mods.kubejs.core.MutableDataComponentHolderKJS;
import dev.latvian.mods.kubejs.core.RegistryObjectKJS;
import dev.latvian.mods.kubejs.item.ChancedItem;
import dev.latvian.mods.kubejs.item.ItemStackJS;
import dev.latvian.mods.kubejs.level.BlockContainerJS;
import dev.latvian.mods.kubejs.recipe.match.Replaceable;
import dev.latvian.mods.kubejs.registry.RegistryInfo;
import dev.latvian.mods.kubejs.script.KubeJSContext;
import dev.latvian.mods.kubejs.util.ID;
import dev.latvian.mods.kubejs.util.WithCodec;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.util.RemapPrefixForJS;
import dev.latvian.mods.rhino.util.ReturnsSelf;
import dev.latvian.mods.rhino.util.SpecialEquality;
import dev.latvian.mods.rhino.util.ToStringJS;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.Nullable;

@RemapPrefixForJS(value="kjs$")
public interface ItemStackKJS
extends SpecialEquality,
WithCodec,
IngredientSupplierKJS,
ToStringJS,
Replaceable,
MutableDataComponentHolderKJS,
RegistryObjectKJS<Item> {
    default public ItemStack kjs$self() {
        return (ItemStack)this;
    }

    default public boolean specialEquals(Context cx, Object o, boolean shallow) {
        if (o instanceof CharSequence) {
            return this.kjs$getId().equals(ID.string(o.toString()));
        }
        if (o instanceof ItemStack) {
            ItemStack s = (ItemStack)o;
            return this.kjs$equalsIgnoringCount(s);
        }
        return this.kjs$equalsIgnoringCount(ItemStackJS.wrap(((KubeJSContext)cx).getRegistries(), o));
    }

    default public boolean kjs$equalsIgnoringCount(ItemStack stack) {
        ItemStack self = this.kjs$self();
        if (self == stack) {
            return true;
        }
        if (self.isEmpty()) {
            return stack.isEmpty();
        }
        return ItemStack.isSameItemSameComponents((ItemStack)self, (ItemStack)stack);
    }

    @Override
    default public RegistryInfo<Item> kjs$getKubeRegistry() {
        return RegistryInfo.ITEM;
    }

    @Override
    default public ResourceLocation kjs$getIdLocation() {
        return this.kjs$self().getItem().kjs$getIdLocation();
    }

    @Override
    default public Holder<Item> kjs$asHolder() {
        return this.kjs$self().getItem().kjs$asHolder();
    }

    @Override
    default public ResourceKey<Item> kjs$getRegistryKey() {
        return this.kjs$self().getItem().kjs$getRegistryKey();
    }

    @Override
    default public String kjs$getId() {
        return this.kjs$self().getItem().kjs$getId();
    }

    @Nullable
    default public Block kjs$getBlock() {
        Block block;
        Item item = this.kjs$self().getItem();
        if (item instanceof BlockItem) {
            BlockItem bi = (BlockItem)item;
            block = bi.getBlock();
        } else {
            block = null;
        }
        return block;
    }

    @ReturnsSelf(copy=true)
    default public ItemStack kjs$withCount(int c) {
        if (c <= 0 || this.kjs$self().isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack is = this.kjs$self().copy();
        is.setCount(c);
        return is;
    }

    @ReturnsSelf
    default public ItemStack kjs$resetComponents() {
        ItemStack is = this.kjs$self();
        is.applyComponents(is.getPrototype());
        return is;
    }

    default public String kjs$getComponentString(KubeJSContext cx) {
        return DataComponentWrapper.patchToString(new StringBuilder(), cx.getRegistries().nbt(), this.kjs$self().getComponentsPatch()).toString();
    }

    @ReturnsSelf(copy=true)
    default public ItemStack kjs$withCustomName(@Nullable Component name) {
        return (ItemStack)this.kjs$self().copy().kjs$setCustomName(name);
    }

    @ReturnsSelf
    default public ItemStack kjs$setRepairCost(int repairCost) {
        ItemStack is = this.kjs$self();
        is.set(DataComponents.REPAIR_COST, (Object)repairCost);
        return is;
    }

    default public ItemEnchantments kjs$getEnchantments() {
        return EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)this.kjs$self());
    }

    default public boolean kjs$hasEnchantment(Holder<Enchantment> enchantment, int level) {
        ItemEnchantments e = this.kjs$getEnchantments();
        return e != null && e.getLevel(enchantment) >= level;
    }

    @ReturnsSelf
    default public ItemStack kjs$enchant(Holder<Enchantment> enchantment, int level) {
        ItemStack is = this.kjs$self();
        is.enchant(enchantment, level);
        return is;
    }

    @ReturnsSelf(copy=true)
    default public ItemStack kjs$enchant(ItemEnchantments enchantments) {
        ItemStack is = this.kjs$self().copy();
        EnchantmentHelper.updateEnchantments((ItemStack)is, mutable -> {
            for (Object2IntMap.Entry entry : enchantments.entrySet()) {
                mutable.upgrade((Holder)entry.getKey(), entry.getValue().intValue());
            }
        });
        return is;
    }

    @Override
    default public String kjs$getMod() {
        return this.kjs$self().getItem().kjs$getMod();
    }

    default public boolean kjs$areItemsEqual(ItemStack other) {
        return this.kjs$self().getItem() == other.getItem();
    }

    default public boolean kjs$areComponentsEqual(ItemStack other) {
        return ItemStack.isSameItemSameComponents((ItemStack)this.kjs$self(), (ItemStack)other);
    }

    default public float kjs$getHarvestSpeed(@Nullable BlockContainerJS block) {
        return this.kjs$self().getDestroySpeed(block == null ? Blocks.AIR.defaultBlockState() : block.getBlockState());
    }

    default public float kjs$getHarvestSpeed() {
        return this.kjs$getHarvestSpeed(null);
    }

    default public Map<String, Object> kjs$getTypeData() {
        return this.kjs$self().getItem().kjs$getTypeData();
    }

    default public String toStringJS(Context cx) {
        return this.kjs$toItemString0((DynamicOps<Tag>)((KubeJSContext)cx).getRegistries().nbt());
    }

    default public String kjs$toItemString(KubeJSContext cx) {
        return this.kjs$toItemString0((DynamicOps<Tag>)cx.getRegistries().nbt());
    }

    default public String kjs$toItemString0(DynamicOps<Tag> dynamicOps) {
        ItemStack is = this.kjs$self();
        int count = is.getCount();
        if (count <= 0) {
            return "minecraft:air";
        }
        StringBuilder builder = new StringBuilder();
        builder.append('\'');
        if (count > 1) {
            builder.append(count);
            builder.append("x ");
        }
        builder.append(this.kjs$getId());
        if (!is.isComponentsPatchEmpty()) {
            DataComponentWrapper.patchToString(builder, dynamicOps, is.getComponentsPatch());
        }
        builder.append('\'');
        return builder.toString();
    }

    @Override
    default public Ingredient kjs$asIngredient() {
        return this.kjs$self().getItem().kjs$asIngredient();
    }

    default public Codec<ItemStack> getCodec(Context cx) {
        return ItemStack.CODEC;
    }

    default public ChancedItem kjs$withChance(FloatProvider chance) {
        return new ChancedItem(this.kjs$self(), chance);
    }

    @ReturnsSelf(copy=true)
    default public ItemStack kjs$withLore(Component[] lines) {
        ItemStack is = this.kjs$self().copy();
        is.set(DataComponents.LORE, (Object)new ItemLore(List.of(lines)));
        return is;
    }

    @ReturnsSelf(copy=true)
    default public ItemStack kjs$withLore(Component[] lines, Component[] styledLines) {
        ItemStack is = this.kjs$self().copy();
        is.set(DataComponents.LORE, (Object)new ItemLore(List.of(lines), List.of(styledLines)));
        return is;
    }

    @Override
    default public Object replaceThisWith(Context cx, Object with) {
        ItemStack r;
        ItemStack t = this.kjs$self();
        if (!ItemStack.isSameItemSameComponents((ItemStack)t, (ItemStack)(r = ItemStackJS.wrap(((KubeJSContext)cx).getRegistries(), with)))) {
            r.setCount(t.getCount());
            return r;
        }
        return this;
    }
}

