/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.client;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.serialization.DynamicOps;
import dev.latvian.mods.kubejs.CommonProperties;
import dev.latvian.mods.kubejs.bindings.TextIcons;
import dev.latvian.mods.kubejs.bindings.event.ClientEvents;
import dev.latvian.mods.kubejs.bindings.event.ItemEvents;
import dev.latvian.mods.kubejs.client.ClientPlayerKubeEvent;
import dev.latvian.mods.kubejs.client.ClientProperties;
import dev.latvian.mods.kubejs.client.DebugInfoKubeEvent;
import dev.latvian.mods.kubejs.client.KubeJSClient;
import dev.latvian.mods.kubejs.client.KubeJSErrorScreen;
import dev.latvian.mods.kubejs.client.TagInstance;
import dev.latvian.mods.kubejs.item.ItemTooltipKubeEvent;
import dev.latvian.mods.kubejs.kubedex.KubedexHighlight;
import dev.latvian.mods.kubejs.script.ConsoleJS;
import dev.latvian.mods.kubejs.script.ScriptType;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.recipebook.RecipeUpdateListener;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.CustomizeGuiOverlayEvent;
import net.neoforged.neoforge.client.event.RenderGuiEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.event.TagsUpdatedEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber(modid="kubejs", value={Dist.CLIENT})
public class KubeJSClientEventHandler {
    public static Map<Item, List<ItemTooltipKubeEvent.StaticTooltipHandler>> staticItemTooltips = null;

    @SubscribeEvent
    public static void debugInfo(CustomizeGuiOverlayEvent.DebugText event) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player != null) {
            if (ClientEvents.DEBUG_LEFT.hasListeners()) {
                ClientEvents.DEBUG_LEFT.post(new DebugInfoKubeEvent(mc.player, event.getLeft()));
            }
            if (ClientEvents.DEBUG_RIGHT.hasListeners()) {
                ClientEvents.DEBUG_RIGHT.post(new DebugInfoKubeEvent(mc.player, event.getRight()));
            }
        }
    }

    private static <T> void appendComponentValue(DynamicOps<Tag> ops, MutableComponent line, DataComponentType<T> type, T value) {
        if (value == null) {
            line.append((Component)Component.literal((String)"null").kjs$red());
            return;
        }
        if (value instanceof Component) {
            Component c = (Component)value;
            line.append((Component)Component.empty().kjs$green().append(c));
        }
        try {
            Tag tag = (Tag)type.codecOrThrow().encodeStart(ops, value).getOrThrow();
            line.append(NbtUtils.toPrettyComponent((Tag)tag));
        }
        catch (Exception ex) {
            line.append((Component)Component.literal((String)String.valueOf(value)).kjs$green());
        }
    }

    @SubscribeEvent
    public static void onItemTooltip(ItemTooltipEvent event) {
        Minecraft mc = Minecraft.getInstance();
        ItemStack stack = event.getItemStack();
        List lines = event.getToolTip();
        TooltipFlag flag = event.getFlags();
        if (stack.isEmpty()) {
            return;
        }
        boolean advanced = flag.isAdvanced();
        if (mc.level != null && advanced && ClientProperties.get().showComponents && Screen.hasAltDown()) {
            MutableComponent line;
            ResourceLocation id;
            Registry components = BuiltInRegistries.DATA_COMPONENT_TYPE;
            RegistryOps ops = mc.level.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE);
            for (Map.Entry entry : stack.getComponentsPatch().entrySet()) {
                id = components.getKey((Object)((DataComponentType)entry.getKey()));
                if (id == null) continue;
                line = Component.empty();
                line.append((Component)TextIcons.icon(Component.literal((String)"Q.")));
                if (((Optional)entry.getValue()).isEmpty()) {
                    line.append((Component)Component.literal((String)"!"));
                }
                line.append((Component)Component.literal((String)(id.getNamespace().equals("minecraft") ? id.getPath() : id.toString())).kjs$yellow());
                if (((Optional)entry.getValue()).isPresent()) {
                    line.append((Component)Component.literal((String)"="));
                    KubeJSClientEventHandler.appendComponentValue((DynamicOps<Tag>)ops, line, (DataComponentType)entry.getKey(), ((Optional)entry.getValue()).get());
                }
                lines.add(line);
            }
            if (Screen.hasShiftDown()) {
                for (TypedDataComponent type : stack.getPrototype()) {
                    id = components.getKey((Object)type.type());
                    if (id == null || stack.getComponentsPatch().get(type.type()) != null) continue;
                    line = Component.empty();
                    line.append((Component)TextIcons.icon(Component.literal((String)"P.")));
                    line.append((Component)Component.literal((String)(id.getNamespace().equals("minecraft") ? id.getPath() : id.toString())).kjs$gray());
                    line.append((Component)Component.literal((String)"="));
                    KubeJSClientEventHandler.appendComponentValue((DynamicOps<Tag>)ops, line, type.type(), type.value());
                    lines.add(line);
                }
            }
        } else if (advanced && ClientProperties.get().showTagNames && Screen.hasShiftDown()) {
            EntityType entityType;
            Item fluid;
            Object item;
            LinkedHashMap tempTagNames = new LinkedHashMap();
            TagInstance.Type.ITEM.append(tempTagNames, stack.getItem().builtInRegistryHolder().tags());
            Object object = stack.getItem();
            if (object instanceof BlockItem) {
                item = (BlockItem)object;
                TagInstance.Type.BLOCK.append(tempTagNames, item.getBlock().builtInRegistryHolder().tags());
            }
            if ((object = stack.getItem()) instanceof BucketItem) {
                BucketItem bucket = (BucketItem)object;
                fluid = bucket.content;
                if (fluid != Fluids.EMPTY) {
                    TagInstance.Type.FLUID.append(tempTagNames, fluid.builtInRegistryHolder().tags());
                }
            }
            if ((fluid = stack.getItem()) instanceof SpawnEggItem && (entityType = (item = (SpawnEggItem)fluid).getType(stack)) != null) {
                TagInstance.Type.ENTITY.append(tempTagNames, entityType.builtInRegistryHolder().tags());
            }
            for (TagInstance instance : tempTagNames.values()) {
                lines.add(instance.toText());
            }
        }
        if (staticItemTooltips == null) {
            staticItemTooltips = new IdentityHashMap<Item, List<ItemTooltipKubeEvent.StaticTooltipHandler>>();
            ItemEvents.TOOLTIP.post(ScriptType.CLIENT, new ItemTooltipKubeEvent(staticItemTooltips));
        }
        try {
            for (ItemTooltipKubeEvent.StaticTooltipHandler handler : staticItemTooltips.getOrDefault(Items.AIR, List.of())) {
                handler.tooltip(stack, advanced, lines);
            }
        }
        catch (Exception ex) {
            ConsoleJS.CLIENT.error("Error while gathering tooltip for " + String.valueOf(stack), ex);
        }
        try {
            for (ItemTooltipKubeEvent.StaticTooltipHandler handler : staticItemTooltips.getOrDefault(stack.getItem(), List.of())) {
                handler.tooltip(stack, advanced, lines);
            }
        }
        catch (Exception ex) {
            ConsoleJS.CLIENT.error("Error while gathering tooltip for " + String.valueOf(stack), ex);
        }
    }

    @SubscribeEvent
    public static void loggingIn(ClientPlayerNetworkEvent.LoggingIn event) {
        ClientEvents.LOGGED_IN.post(ScriptType.CLIENT, new ClientPlayerKubeEvent(event.getPlayer()));
    }

    @SubscribeEvent
    public static void loggingOut(ClientPlayerNetworkEvent.LoggingOut event) {
        ClientEvents.LOGGED_OUT.post(ScriptType.CLIENT, new ClientPlayerKubeEvent(event.getPlayer()));
    }

    @SubscribeEvent
    public static void hudPostDraw(RenderGuiEvent.Post event) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.screen == null) {
            KubedexHighlight.INSTANCE.afterEverything(mc, event.getGuiGraphics(), event.getPartialTick().getGameTimeDeltaPartialTick(false));
        }
    }

    @SubscribeEvent
    public static void screenPostDraw(ScreenEvent.Render.Post event) {
        Minecraft mc = Minecraft.getInstance();
        Screen screen = event.getScreen();
        if (screen instanceof AbstractContainerScreen) {
            AbstractContainerScreen screen2 = (AbstractContainerScreen)screen;
            KubedexHighlight.INSTANCE.screen(mc, event.getGuiGraphics(), screen2, event.getMouseX(), event.getMouseY(), event.getPartialTick());
        }
        KubedexHighlight.INSTANCE.afterEverything(mc, event.getGuiGraphics(), event.getPartialTick());
    }

    @SubscribeEvent
    public static void clientTick(ClientTickEvent.Pre event) {
        Minecraft mc = Minecraft.getInstance();
        KubedexHighlight.INSTANCE.tickPre(mc);
    }

    @SubscribeEvent
    public static void worldRender(RenderLevelStageEvent event) {
        RenderTarget depth;
        Minecraft mc = Minecraft.getInstance();
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_SKY) {
            KubedexHighlight.INSTANCE.clearBuffers(mc);
        } else if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_ENTITIES) {
            KubedexHighlight.INSTANCE.renderAfterEntities(mc, event);
        } else if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_LEVEL && (depth = KubedexHighlight.INSTANCE.mcDepthInput) != null) {
            depth.bindWrite(false);
            depth.clear(Minecraft.ON_OSX);
            depth.copyDepthFrom(mc.getMainRenderTarget());
            mc.getMainRenderTarget().bindWrite(false);
        }
    }

    @Nullable
    public static Screen setScreen(Screen screen) {
        if (screen instanceof TitleScreen && !ConsoleJS.STARTUP.errors.isEmpty() && CommonProperties.get().startupErrorGUI) {
            return new KubeJSErrorScreen(screen, ConsoleJS.STARTUP, false);
        }
        if (screen instanceof TitleScreen && !ConsoleJS.CLIENT.errors.isEmpty() && CommonProperties.get().startupErrorGUI) {
            return new KubeJSErrorScreen(screen, ConsoleJS.CLIENT, false);
        }
        return screen;
    }

    @SubscribeEvent
    public static void guiPostInit(ScreenEvent.Init.Post event) {
        Screen screen = event.getScreen();
        if (ClientProperties.get().disableRecipeBook && screen instanceof RecipeUpdateListener) {
            Iterator iterator = screen.children().iterator();
            while (iterator.hasNext()) {
                GuiEventListener listener = (GuiEventListener)iterator.next();
                if (!(listener instanceof ImageButton)) continue;
                ImageButton button = (ImageButton)listener;
                if (!button.sprites.enabled().equals((Object)KubeJSClient.RECIPE_BUTTON_TEXTURE)) continue;
                screen.renderables.remove(listener);
                screen.narratables.remove(listener);
                iterator.remove();
                return;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void openScreenEvent(ScreenEvent.Opening event) {
        Screen s = KubeJSClientEventHandler.setScreen(event.getScreen());
        if (s != null && event.getScreen() != s) {
            event.setNewScreen(s);
        }
    }

    @SubscribeEvent
    public static void tagsUpdated(TagsUpdatedEvent event) {
        Screen screen;
        if (event.getUpdateCause() == TagsUpdatedEvent.UpdateCause.CLIENT_PACKET_RECEIVED && (screen = Minecraft.getInstance().screen) instanceof KubeJSErrorScreen) {
            KubeJSErrorScreen screen2 = (KubeJSErrorScreen)screen;
            if (screen2.scriptType == ScriptType.SERVER) {
                Minecraft.getInstance().kjs$runCommand("kubejs errors server");
            }
        }
    }
}

