/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.client;

import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.KubeJSCommon;
import dev.latvian.mods.kubejs.KubeJSPaths;
import dev.latvian.mods.kubejs.bindings.event.NetworkEvents;
import dev.latvian.mods.kubejs.client.ClientProperties;
import dev.latvian.mods.kubejs.client.KubeJSClientEventHandler;
import dev.latvian.mods.kubejs.client.KubeJSErrorScreen;
import dev.latvian.mods.kubejs.kubedex.KubedexHighlight;
import dev.latvian.mods.kubejs.net.NetworkKubeEvent;
import dev.latvian.mods.kubejs.script.ConsoleLine;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.script.data.ExportablePackResources;
import dev.latvian.mods.kubejs.script.data.GeneratedData;
import dev.latvian.mods.kubejs.script.data.GeneratedDataStage;
import dev.latvian.mods.kubejs.script.data.VirtualAssetPack;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.util.profiling.InactiveProfiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.CreativeModeTabs;
import org.jetbrains.annotations.Nullable;

public class KubeJSClient
extends KubeJSCommon {
    public static final ResourceLocation WHITE_TEXTURE = ResourceLocation.parse((String)"textures/misc/white.png");
    public static final ResourceLocation RECIPE_BUTTON_TEXTURE = ResourceLocation.parse((String)"textures/gui/recipe_button.png");
    public static final Map<GeneratedDataStage, VirtualAssetPack> CLIENT_PACKS = new EnumMap<GeneratedDataStage, VirtualAssetPack>(GeneratedDataStage.class);

    @Override
    public void reloadClientInternal() {
        KubeJSClient.reloadClientScripts();
    }

    public static void reloadClientScripts() {
        KubeJSClientEventHandler.staticItemTooltips = null;
        KubeJS.getClientScriptManager().reload();
    }

    public static void copyDefaultOptionsFile(File optionsFile) {
        Path defOptions;
        if (!optionsFile.exists() && Files.exists(defOptions = KubeJSPaths.CONFIG.resolve("defaultoptions.txt"), new LinkOption[0])) {
            try {
                KubeJS.LOGGER.info("Loaded default options from kubejs/config/defaultoptions.txt");
                Files.copy(defOptions, optionsFile.toPath(), new CopyOption[0]);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void handleDataFromServerPacket(String channel, @Nullable CompoundTag data) {
        if (NetworkEvents.DATA_RECEIVED.hasListeners(channel)) {
            NetworkEvents.DATA_RECEIVED.post(ScriptType.CLIENT, channel, new NetworkKubeEvent((Player)Minecraft.getInstance().player, channel, data));
        }
    }

    @Override
    @Nullable
    public Player getClientPlayer() {
        return Minecraft.getInstance().player;
    }

    private void reload(PreparableReloadListener listener) {
        long start = System.currentTimeMillis();
        Minecraft mc = Minecraft.getInstance();
        mc.getResourceManager().getResource(GeneratedData.INTERNAL_RELOAD.id());
        listener.reload(CompletableFuture::completedFuture, mc.getResourceManager(), (ProfilerFiller)InactiveProfiler.INSTANCE, (ProfilerFiller)InactiveProfiler.INSTANCE, (Executor)Util.backgroundExecutor(), (Executor)mc).thenAccept(unused -> mc.player.sendSystemMessage((Component)Component.literal((String)"Done! You still may have to reload all assets with F3 + T")));
    }

    @Override
    public void reloadTextures() {
        this.reload((PreparableReloadListener)Minecraft.getInstance().getTextureManager());
    }

    @Override
    public void reloadLang() {
        KubeJSClient.reloadClientScripts();
        this.reload((PreparableReloadListener)Minecraft.getInstance().getLanguageManager());
    }

    @Override
    public void generateTypings(CommandSourceStack source) {
        source.sendSuccess(() -> Component.literal((String)"WIP!"), false);
    }

    @Override
    public void reloadConfig() {
        super.reloadConfig();
        ClientProperties.reload();
    }

    @Override
    public void reloadStartupScripts(boolean dedicated) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player != null) {
            CreativeModeTabs.CACHED_PARAMETERS = null;
            CreativeModeTabs.tryRebuildTabContents((FeatureFlagSet)mc.player.connection.enabledFeatures(), (mc.player.canUseGameMasterBlocks() && (Boolean)mc.options.operatorItemsTab().get() != false ? 1 : 0) != 0, (HolderLookup.Provider)mc.level.registryAccess());
        }
    }

    @Override
    public void export(List<ExportablePackResources> packs) {
        for (PackResources pack : Minecraft.getInstance().getResourceManager().listPacks().toList()) {
            ExportablePackResources e;
            if (!(pack instanceof ExportablePackResources) || packs.contains(e = (ExportablePackResources)pack)) continue;
            packs.add(e);
        }
    }

    @Override
    public void openErrors(ScriptType type) {
        this.runInMainThread(() -> Minecraft.getInstance().setScreen((Screen)new KubeJSErrorScreen(null, type.console, true)));
    }

    @Override
    public void openErrors(ScriptType type, List<ConsoleLine> errors, List<ConsoleLine> warnings) {
        this.runInMainThread(() -> Minecraft.getInstance().setScreen((Screen)new KubeJSErrorScreen(null, type, null, errors, warnings, true)));
    }

    @Override
    public void runInMainThread(Runnable runnable) {
        Minecraft mc = Minecraft.getInstance();
        if (mc != null) {
            mc.execute(runnable);
        } else {
            runnable.run();
        }
    }

    public static void loadPostChains(Minecraft mc) {
        KubedexHighlight.INSTANCE.loadPostChains(mc);
    }

    public static void resizePostChains(int width, int height) {
        KubedexHighlight.INSTANCE.resizePostChains(width, height);
    }

    static {
        for (GeneratedDataStage stage : GeneratedDataStage.values()) {
            CLIENT_PACKS.put(stage, new VirtualAssetPack(stage));
        }
    }
}

