/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.block.entity;

import dev.latvian.mods.kubejs.block.entity.BlockEntityAttachment;
import dev.latvian.mods.kubejs.block.entity.BlockEntityAttachmentType;
import dev.latvian.mods.kubejs.block.entity.BlockEntityJS;
import dev.latvian.mods.kubejs.item.ItemPredicate;
import dev.latvian.mods.kubejs.item.ingredient.IngredientJS;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.ScriptRuntime;
import dev.latvian.mods.rhino.type.JSObjectTypeInfo;
import dev.latvian.mods.rhino.type.JSOptionalParam;
import dev.latvian.mods.rhino.type.TypeInfo;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class InventoryAttachment
extends SimpleContainer
implements BlockEntityAttachment {
    public static final BlockEntityAttachmentType TYPE = new BlockEntityAttachmentType("inventory", (TypeInfo)JSObjectTypeInfo.of((JSOptionalParam[])new JSOptionalParam[]{new JSOptionalParam("xsize", TypeInfo.INT), new JSOptionalParam("ysize", TypeInfo.INT), new JSOptionalParam("inputFilter", IngredientJS.TYPE_INFO)}), (cx, map) -> {
        int width = ScriptRuntime.toInt32((Context)cx, map.get("width"));
        int height = ScriptRuntime.toInt32((Context)cx, map.get("height"));
        ItemPredicate inputFilter = map.containsKey("inputFilter") ? ItemPredicate.wrap(cx, map.get("inputFilter")) : null;
        return new InventoryAttachmentFactory(width, height, inputFilter);
    });
    public final int width;
    public final int height;
    public final BlockEntityJS blockEntity;
    public final ItemPredicate inputFilter;

    public InventoryAttachment(BlockEntityJS blockEntity, int width, int height, @Nullable ItemPredicate inputFilter) {
        super(width * height);
        this.width = width;
        this.height = height;
        this.blockEntity = blockEntity;
        this.inputFilter = inputFilter;
    }

    public void setChanged() {
        super.setChanged();
        this.blockEntity.save();
    }

    @Override
    public CompoundTag writeAttachment(HolderLookup.Provider registries) {
        CompoundTag tag = new CompoundTag();
        ListTag list = new ListTag();
        for (int i = 0; i < this.getContainerSize(); ++i) {
            ItemStack stack = this.getItem(i);
            if (stack.isEmpty()) continue;
            CompoundTag itemTag = (CompoundTag)stack.save(registries, (Tag)new CompoundTag());
            itemTag.putByte("slot", (byte)i);
            list.add((Object)itemTag);
        }
        tag.put("items", (Tag)list);
        return tag;
    }

    @Override
    public void readAttachment(HolderLookup.Provider registries, CompoundTag tag) {
        for (int i = 0; i < this.getContainerSize(); ++i) {
            this.removeItemNoUpdate(i);
        }
        ListTag list = tag.getList("items", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag itemTag = list.getCompound(i);
            byte slot = itemTag.getByte("slot");
            if (slot < 0 || slot >= this.getContainerSize()) continue;
            this.setItem(slot, ItemStack.parse((HolderLookup.Provider)registries, (Tag)itemTag).orElse(ItemStack.EMPTY));
        }
    }

    @Override
    public void onRemove(BlockState newState) {
        Containers.dropContents((Level)this.blockEntity.getLevel(), (BlockPos)this.blockEntity.getBlockPos(), (Container)this);
    }

    public boolean canAddItem(ItemStack itemStack) {
        return (this.inputFilter == null || this.inputFilter.test(itemStack)) && super.canAddItem(itemStack);
    }

    public boolean canPlaceItem(int i, ItemStack itemStack) {
        return (this.inputFilter == null || this.inputFilter.test(itemStack)) && super.canPlaceItem(i, itemStack);
    }

    public boolean stillValid(Player player) {
        return !this.blockEntity.isRemoved();
    }

    public int kjs$getWidth() {
        return this.width;
    }

    public int kjs$getHeight() {
        return this.height;
    }

    private record InventoryAttachmentFactory(int width, int height, @Nullable ItemPredicate inputFilter) implements BlockEntityAttachment.Factory
    {
        @Override
        public BlockEntityAttachment create(BlockEntityJS entity) {
            return new InventoryAttachment(entity, this.width, this.height, this.inputFilter);
        }
    }
}

