/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.block.entity;

import dev.latvian.mods.kubejs.bindings.event.BlockEvents;
import dev.latvian.mods.kubejs.block.entity.BlockEntityAttachment;
import dev.latvian.mods.kubejs.block.entity.BlockEntityEventCallback;
import dev.latvian.mods.kubejs.block.entity.BlockEntityInfo;
import dev.latvian.mods.kubejs.block.entity.BlockEntityTickKubeEvent;
import dev.latvian.mods.kubejs.core.InventoryKJS;
import dev.latvian.mods.kubejs.level.BlockContainerJS;
import dev.latvian.mods.kubejs.script.ScriptType;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class BlockEntityJS
extends BlockEntity {
    public static final BlockEntityTicker<BlockEntityJS> TICKER = (level, pos, state, entity) -> entity.tick();
    public final BlockEntityInfo info;
    public final ResourceKey<Block> blockKey;
    protected BlockContainerJS block;
    public final int x;
    public final int y;
    public final int z;
    public int tick;
    public int cycle;
    public CompoundTag data;
    public final BlockEntityAttachment[] attachments;
    public InventoryKJS inventory;
    public UUID placerId;
    private BlockEntityTickKubeEvent tickEvent;

    public BlockEntityJS(BlockPos blockPos, BlockState blockState, BlockEntityInfo entityInfo) {
        super(entityInfo.entityType, blockPos, blockState);
        this.info = entityInfo;
        this.blockKey = blockState.kjs$getRegistryKey();
        this.x = blockPos.getX();
        this.y = blockPos.getY();
        this.z = blockPos.getZ();
        this.data = this.info.initialData.copy();
        if (entityInfo.attachments != null) {
            this.attachments = new BlockEntityAttachment[entityInfo.attachments.size()];
            for (int i = 0; i < this.attachments.length; ++i) {
                InventoryKJS inv;
                BlockEntityAttachment blockEntityAttachment;
                this.attachments[i] = entityInfo.attachments.get(i).factory().create(this);
                if (this.inventory != null || !((blockEntityAttachment = this.attachments[i]) instanceof InventoryKJS)) continue;
                this.inventory = inv = (InventoryKJS)((Object)blockEntityAttachment);
            }
        } else {
            this.attachments = BlockEntityAttachment.EMPTY_ARRAY;
        }
    }

    public void setLevel(Level level) {
        super.setLevel(level);
        this.block = null;
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.put("data", (Tag)this.data);
        if (this.tick > 0) {
            tag.putInt("tick", this.tick);
        }
        if (this.cycle > 0) {
            tag.putInt("cycle", this.cycle);
        }
        if (this.placerId != null) {
            tag.putUUID("placer", this.placerId);
        }
        if (this.attachments.length > 0) {
            ListTag list = new ListTag();
            for (BlockEntityAttachment att : this.attachments) {
                list.add((Object)att.writeAttachment(registries));
            }
            tag.put("attachments", (Tag)list);
        }
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        block4: {
            super.loadAdditional(tag, registries);
            this.data = tag.getCompound("data");
            this.tick = tag.getInt("tick");
            this.cycle = tag.getInt("cycle");
            UUID uUID = this.placerId = tag.contains("placer") ? tag.getUUID("placer") : null;
            if (this.attachments.length <= 0) break block4;
            ListTag list = tag.getList("attachments", 10);
            if (this.attachments.length == list.size()) {
                for (int i = 0; i < this.attachments.length; ++i) {
                    this.attachments[i].readAttachment(registries, list.getCompound(i));
                }
            } else {
                for (BlockEntityAttachment att : this.attachments) {
                    att.readAttachment(registries, new CompoundTag());
                }
            }
        }
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        if (this.info.sync && !this.data.isEmpty()) {
            tag.put("data", (Tag)this.data);
        }
        if (this.tick > 0) {
            tag.putInt("tick", this.tick);
        }
        if (this.cycle > 0) {
            tag.putInt("cycle", this.cycle);
        }
        return tag;
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void save() {
        if (this.level != null) {
            this.level.blockEntityChanged(this.worldPosition);
        }
    }

    public void sync() {
        if (this.level != null) {
            this.save();
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 11);
        }
    }

    public void sendEvent(int eventId, int data) {
        this.level.blockEvent(this.worldPosition, this.getBlockState().getBlock(), eventId, data);
    }

    public boolean triggerEvent(int eventId, int data) {
        BlockEntityEventCallback e;
        if (this.info.eventHandlers != null && (e = (BlockEntityEventCallback)this.info.eventHandlers.get(eventId)) != null) {
            e.accept(this, data);
            return true;
        }
        return false;
    }

    public BlockContainerJS getBlock() {
        if (this.block == null) {
            this.block = new BlockContainerJS(this.level, this.worldPosition);
            this.block.cachedEntity = this;
            this.block.cachedState = this.getBlockState();
        }
        return this.block;
    }

    private void tick() {
        if (this.tick % this.info.tickFrequency == this.info.tickOffset) {
            ScriptType side = this.level.kjs$getScriptType();
            try {
                if (this.tickEvent == null) {
                    this.tickEvent = new BlockEntityTickKubeEvent(this);
                }
                BlockEvents.BLOCK_ENTITY_TICK.post(side, this.blockKey, this.tickEvent);
            }
            catch (Exception ex) {
                side.console.error("Error while ticking KubeJS block entity '" + String.valueOf(this.info.blockBuilder.id) + "'", ex);
            }
            ++this.cycle;
        }
        ++this.tick;
    }
}

