/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.block.custom;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.latvian.mods.kubejs.block.BlockBuilder;
import dev.latvian.mods.kubejs.color.Color;
import dev.latvian.mods.rhino.util.ReturnsSelf;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ColorRGBA;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

@ReturnsSelf
public class FallingBlockBuilder
extends BlockBuilder {
    private int dustColor = -8356741;

    public FallingBlockBuilder(ResourceLocation i) {
        super(i);
    }

    @Override
    public Block createObject() {
        int dustRgb = this.dustColor & 0xFFFFFF;
        int dustAlpha = this.dustColor >> 24 & 0xFF;
        ColorRGBA dustColor = new ColorRGBA(dustRgb | dustAlpha << 24);
        return new KubeJSFallingBlock(dustColor, this.createProperties());
    }

    public FallingBlockBuilder dustColor(Color color) {
        this.dustColor = color.getArgbJS();
        return this;
    }

    static class KubeJSFallingBlock
    extends FallingBlock {
        private final ColorRGBA dustColor;
        private static final MapCodec<KubeJSFallingBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ColorRGBA.CODEC.fieldOf("falling_dust_color").forGetter(block -> block.dustColor), (App)KubeJSFallingBlock.propertiesCodec()).apply((Applicative)instance, KubeJSFallingBlock::new));

        public KubeJSFallingBlock(ColorRGBA dustColor, BlockBehaviour.Properties p) {
            super(p);
            this.dustColor = dustColor;
        }

        public int getDustColor(BlockState state, BlockGetter level, BlockPos pos) {
            return this.dustColor.rgba();
        }

        protected MapCodec<KubeJSFallingBlock> codec() {
            return CODEC;
        }
    }
}

