/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.block.custom;

import com.mojang.datafixers.util.Pair;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.block.BlockBuilder;
import dev.latvian.mods.kubejs.block.BlockRenderType;
import dev.latvian.mods.kubejs.block.RandomTickCallbackJS;
import dev.latvian.mods.kubejs.block.SeedItemBuilder;
import dev.latvian.mods.kubejs.block.custom.BasicCropBlockJS;
import dev.latvian.mods.kubejs.client.VariantBlockStateGenerator;
import dev.latvian.mods.kubejs.generator.KubeAssetGenerator;
import dev.latvian.mods.kubejs.level.BlockContainerJS;
import dev.latvian.mods.kubejs.typings.Info;
import dev.latvian.mods.rhino.util.ReturnsSelf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.Nullable;

@ReturnsSelf
public class CropBlockBuilder
extends BlockBuilder {
    public static final ResourceLocation[] CROP_BLOCK_TAGS = new ResourceLocation[]{BlockTags.CROPS.location()};
    public static final ResourceLocation[] CROP_ITEM_TAGS = new ResourceLocation[]{Tags.Items.SEEDS.location()};
    public transient int age = 7;
    protected transient List<VoxelShape> shapeByAge = Collections.nCopies(8, Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));
    public transient boolean dropSeed;
    public transient ToDoubleFunction<RandomTickCallbackJS> growSpeedCallback = null;
    public transient ToIntFunction<RandomTickCallbackJS> fertilizerCallback = null;
    public transient SurviveCallback surviveCallback = null;
    public transient List<Pair<Object, Double>> outputs;

    public CropBlockBuilder(ResourceLocation i) {
        super(i);
        this.renderType = BlockRenderType.CUTOUT;
        this.noCollision = true;
        this.itemBuilder = new SeedItemBuilder(this.newID("", "_seed"));
        ((SeedItemBuilder)this.itemBuilder).blockBuilder = this;
        this.hardness = 0.0f;
        this.resistance = 0.0f;
        this.dropSeed = true;
        this.outputs = new ArrayList<Pair<Object, Double>>();
        this.notSolid = true;
        this.soundType(SoundType.CROP);
        this.mapColor(MapColor.PLANT);
        for (int a = 0; a <= this.age; ++a) {
            this.texture(String.valueOf(a), this.id.getNamespace() + ":block/" + this.id.getPath() + a);
        }
        this.tagBlock(CROP_BLOCK_TAGS);
        this.tagItem(CROP_ITEM_TAGS);
    }

    @Info(value="Add a crop output with a 100% chance.")
    public CropBlockBuilder crop(Object output) {
        this.crop(output, 1.0);
        return this;
    }

    @Info(value="Add a crop output with a specific chance.")
    public CropBlockBuilder crop(Object output, double chance) {
        this.outputs.add((Pair<Object, Double>)new Pair(output, (Object)chance));
        return this;
    }

    @Info(value="Set the age of the crop. Note that the box will be the same for all ages (A full block size).")
    public CropBlockBuilder age(int age) {
        this.age(age, builder -> {});
        return this;
    }

    @Info(value="Set if the crop should drop seeds when harvested.")
    public CropBlockBuilder dropSeed(boolean dropSeed) {
        this.dropSeed = dropSeed;
        return this;
    }

    @Info(value="Set the age of the crop and the shape of the crop at that age.")
    public CropBlockBuilder age(int age, Consumer<ShapeBuilder> builder) {
        this.age = age;
        ShapeBuilder shapes = new ShapeBuilder(age);
        builder.accept(shapes);
        this.shapeByAge = shapes.getShapes();
        for (int i = 0; i <= age; ++i) {
            this.texture(String.valueOf(i), this.id.getNamespace() + ":block/" + this.id.getPath() + i);
        }
        return this;
    }

    @Override
    public BlockBuilder texture(String id, String tex) {
        try {
            int intId = (int)Double.parseDouble(id);
            return super.texture(String.valueOf(intId), tex);
        }
        catch (NumberFormatException e) {
            return super.texture(id, tex);
        }
    }

    public CropBlockBuilder bonemeal(ToIntFunction<RandomTickCallbackJS> bonemealCallback) {
        this.fertilizerCallback = bonemealCallback;
        return this;
    }

    public CropBlockBuilder survive(SurviveCallback surviveCallback) {
        this.surviveCallback = surviveCallback;
        return this;
    }

    public CropBlockBuilder growTick(ToDoubleFunction<RandomTickCallbackJS> growSpeedCallback) {
        this.growSpeedCallback = growSpeedCallback;
        return this;
    }

    @Override
    public BlockBuilder randomTick(@Nullable Consumer<RandomTickCallbackJS> randomTickCallback) {
        KubeJS.LOGGER.warn("randomTick is overridden by growTick to return grow speed, use it instead.");
        return this;
    }

    @Override
    @Nullable
    public LootTable generateLootTable() {
        if (this.drops != null) {
            return super.generateLootTable();
        }
        return null;
    }

    @Override
    protected void generateBlockStateJson(VariantBlockStateGenerator bs) {
        for (int i = 0; i <= this.age; ++i) {
            bs.simpleVariant("age=%s".formatted(i), (String)(this.model.isEmpty() ? this.id.getNamespace() + ":block/" + this.id.getPath() + i : this.model));
        }
    }

    @Override
    protected void generateBlockModelJsons(KubeAssetGenerator generator) {
        for (int i = 0; i <= this.age; ++i) {
            int fi = i;
            generator.blockModel(this.newID("", String.valueOf(i)), m -> {
                m.parent("minecraft:block/crop");
                m.texture("crop", this.textures.get(String.valueOf(fi)).getAsString());
            });
        }
    }

    @Override
    public Block createObject() {
        final IntegerProperty ageProperty = IntegerProperty.create((String)"age", (int)0, (int)this.age);
        return new BasicCropBlockJS(this){

            public IntegerProperty getAgeProperty() {
                return ageProperty;
            }

            @Override
            protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
                builder.add(new Property[]{ageProperty});
            }

            @Override
            public void randomTick(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource random) {
                double f = CropBlockBuilder.this.growSpeedCallback == null ? -1.0 : CropBlockBuilder.this.growSpeedCallback.applyAsDouble(new RandomTickCallbackJS(new BlockContainerJS((Level)serverLevel, blockPos), random));
                int age = this.getAge(blockState);
                if (age < this.getMaxAge()) {
                    if (f < 0.0) {
                        f = 1.getGrowthSpeed((BlockState)blockState, (BlockGetter)serverLevel, (BlockPos)blockPos);
                    }
                    if (f > 0.0 && random.nextInt((int)(25.0 / f) + 1) == 0) {
                        serverLevel.setBlock(blockPos, this.getStateForAge(age + 1), 2);
                    }
                }
            }

            @Override
            public void growCrops(Level level, BlockPos blockPos, BlockState blockState) {
                if (CropBlockBuilder.this.fertilizerCallback == null) {
                    super.growCrops(level, blockPos, blockState);
                } else {
                    int effect = CropBlockBuilder.this.fertilizerCallback.applyAsInt(new RandomTickCallbackJS(new BlockContainerJS(level, blockPos), level.random));
                    if (effect > 0) {
                        level.setBlock(blockPos, this.getStateForAge(Integer.min(this.getAge(blockState) + effect, this.getMaxAge())), 2);
                    }
                }
            }

            @Override
            public boolean canSurvive(BlockState blockState, LevelReader levelReader, BlockPos blockPos) {
                return CropBlockBuilder.this.surviveCallback != null ? CropBlockBuilder.this.surviveCallback.survive(blockState, levelReader, blockPos) : super.canSurvive(blockState, levelReader, blockPos);
            }
        };
    }

    @FunctionalInterface
    public static interface SurviveCallback {
        public boolean survive(BlockState var1, LevelReader var2, BlockPos var3);
    }

    public static class ShapeBuilder {
        private final List<VoxelShape> shapes;

        public ShapeBuilder(int age) {
            this.shapes = new ArrayList<VoxelShape>(Collections.nCopies(age + 1, Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)));
        }

        @Info(value="Describe the shape of the crop at a specific age.\n\nmin/max coordinates are double values between 0 and 16.\n")
        public ShapeBuilder shape(int age, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
            this.shapes.set(age, Block.box((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ));
            return this;
        }

        public List<VoxelShape> getShapes() {
            return List.copyOf(this.shapes);
        }
    }
}

