/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.block.custom;

import dev.latvian.mods.kubejs.block.BlockBuilder;
import dev.latvian.mods.kubejs.block.BlockRightClickedKubeEvent;
import dev.latvian.mods.kubejs.block.KubeJSBlockProperties;
import dev.latvian.mods.kubejs.block.RandomTickCallbackJS;
import dev.latvian.mods.kubejs.block.callbacks.AfterEntityFallenOnBlockCallbackJS;
import dev.latvian.mods.kubejs.block.callbacks.BlockExplodedCallbackJS;
import dev.latvian.mods.kubejs.block.callbacks.BlockStateMirrorCallbackJS;
import dev.latvian.mods.kubejs.block.callbacks.BlockStateModifyCallbackJS;
import dev.latvian.mods.kubejs.block.callbacks.BlockStateModifyPlacementCallbackJS;
import dev.latvian.mods.kubejs.block.callbacks.BlockStateRotateCallbackJS;
import dev.latvian.mods.kubejs.block.callbacks.CanBeReplacedCallbackJS;
import dev.latvian.mods.kubejs.block.callbacks.EntityFallenOnBlockCallbackJS;
import dev.latvian.mods.kubejs.block.callbacks.EntitySteppedOnBlockCallbackJS;
import dev.latvian.mods.kubejs.block.entity.BlockEntityAttachment;
import dev.latvian.mods.kubejs.block.entity.BlockEntityJS;
import dev.latvian.mods.kubejs.core.BlockKJS;
import dev.latvian.mods.kubejs.level.BlockContainerJS;
import dev.latvian.mods.kubejs.script.ScriptType;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class BasicBlockJS
extends Block
implements BlockKJS,
SimpleWaterloggedBlock {
    public final BlockBuilder blockBuilder;
    public final VoxelShape shape;

    public BasicBlockJS(BlockBuilder p) {
        super(p.createProperties());
        this.blockBuilder = p;
        this.shape = BlockBuilder.createShape(p.customShape);
        BlockState blockState = (BlockState)this.stateDefinition.any();
        if (this.blockBuilder.defaultStateModification != null) {
            BlockStateModifyCallbackJS callbackJS = new BlockStateModifyCallbackJS(blockState);
            if (this.safeCallback(this.blockBuilder.defaultStateModification, callbackJS, "Error while creating default blockState for block " + String.valueOf(p.id))) {
                this.registerDefaultState(callbackJS.getState());
            }
        } else if (this.blockBuilder.canBeWaterlogged()) {
            this.registerDefaultState((BlockState)blockState.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        }
    }

    @Override
    public BlockBuilder kjs$getBlockBuilder() {
        return this.blockBuilder;
    }

    public MutableComponent getName() {
        if (this.blockBuilder.displayName != null && this.blockBuilder.formattedDisplayName) {
            return Component.literal((String)"").append(this.blockBuilder.displayName);
        }
        return super.getName();
    }

    @Deprecated
    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.shape;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        BlockBehaviour.Properties properties = this.properties;
        if (properties instanceof KubeJSBlockProperties) {
            KubeJSBlockProperties kp = (KubeJSBlockProperties)properties;
            for (Property property : kp.blockBuilder.blockStateProperties) {
                builder.add(new Property[]{property});
            }
            kp.blockBuilder.blockStateProperties = Collections.unmodifiableSet(kp.blockBuilder.blockStateProperties);
        }
    }

    @Deprecated
    public FluidState getFluidState(BlockState state) {
        return state.getOptionalValue((Property)BlockStateProperties.WATERLOGGED).orElse(false) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockStateModifyPlacementCallbackJS callbackJS;
        if (this.blockBuilder.placementStateModification != null && this.safeCallback(this.blockBuilder.placementStateModification, callbackJS = new BlockStateModifyPlacementCallbackJS(context, this), "Error while modifying BlockState placement of " + String.valueOf(this.blockBuilder.id))) {
            return callbackJS.getState();
        }
        if (!this.blockBuilder.canBeWaterlogged()) {
            return this.defaultBlockState();
        }
        return (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(context.getLevel().getFluidState(context.getClickedPos()).getType() == Fluids.WATER));
    }

    public boolean canBeReplaced(BlockState blockState, BlockPlaceContext context) {
        if (this.blockBuilder.canBeReplacedFunction != null) {
            CanBeReplacedCallbackJS callbackJS = new CanBeReplacedCallbackJS(context, blockState);
            return this.blockBuilder.canBeReplacedFunction.test(callbackJS);
        }
        return super.canBeReplaced(blockState, context);
    }

    @Deprecated
    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos pos, BlockPos facingPos) {
        if (state.getOptionalValue((Property)BlockStateProperties.WATERLOGGED).orElse(false).booleanValue()) {
            world.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
        }
        return state;
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter level, BlockPos pos) {
        return this.blockBuilder.transparent || state.getOptionalValue((Property)BlockStateProperties.WATERLOGGED).orElse(false) == false;
    }

    @Deprecated
    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (this.blockBuilder.randomTickCallback != null) {
            RandomTickCallbackJS callback = new RandomTickCallbackJS(new BlockContainerJS((Level)level, pos), random);
            this.safeCallback(this.blockBuilder.randomTickCallback, callback, "Error while random ticking custom block ");
        }
    }

    public boolean isRandomlyTicking(BlockState state) {
        return this.blockBuilder.randomTickCallback != null;
    }

    @Deprecated
    public VoxelShape getVisualShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return this.blockBuilder.transparent ? Shapes.empty() : super.getVisualShape(state, level, pos, ctx);
    }

    @Deprecated
    public float getShadeBrightness(BlockState state, BlockGetter level, BlockPos pos) {
        return this.blockBuilder.transparent ? 1.0f : super.getShadeBrightness(state, level, pos);
    }

    @Deprecated
    public boolean skipRendering(BlockState state, BlockState state2, Direction direction) {
        return this.blockBuilder.transparent ? state2.is((Block)this) || super.skipRendering(state, state2, direction) : super.skipRendering(state, state2, direction);
    }

    @Nullable
    private <T> boolean safeCallback(Consumer<T> consumer, T value, String errorMessage) {
        try {
            consumer.accept(value);
        }
        catch (Throwable e) {
            ScriptType.STARTUP.console.error(errorMessage, e);
            return false;
        }
        return true;
    }

    public boolean canPlaceLiquid(Player player, BlockGetter blockGetter, BlockPos blockPos, BlockState blockState, Fluid fluid) {
        if (this.blockBuilder.canBeWaterlogged()) {
            return super.canPlaceLiquid(player, blockGetter, blockPos, blockState, fluid);
        }
        return false;
    }

    public boolean placeLiquid(LevelAccessor levelAccessor, BlockPos blockPos, BlockState blockState, FluidState fluidState) {
        if (this.blockBuilder.canBeWaterlogged()) {
            return super.placeLiquid(levelAccessor, blockPos, blockState, fluidState);
        }
        return false;
    }

    public ItemStack pickupBlock(Player player, LevelAccessor levelAccessor, BlockPos blockPos, BlockState blockState) {
        if (this.blockBuilder.canBeWaterlogged()) {
            return super.pickupBlock(player, levelAccessor, blockPos, blockState);
        }
        return ItemStack.EMPTY;
    }

    public Optional<SoundEvent> getPickupSound() {
        if (this.blockBuilder.canBeWaterlogged()) {
            return super.getPickupSound();
        }
        return Optional.empty();
    }

    public void stepOn(Level level, BlockPos blockPos, BlockState blockState, Entity entity) {
        if (this.blockBuilder.stepOnCallback != null) {
            EntitySteppedOnBlockCallbackJS callbackJS = new EntitySteppedOnBlockCallbackJS(level, entity, blockPos, blockState);
            this.safeCallback(this.blockBuilder.stepOnCallback, callbackJS, "Error while an entity stepped on custom block ");
        } else {
            super.stepOn(level, blockPos, blockState, entity);
        }
    }

    public void fallOn(Level level, BlockState blockState, BlockPos blockPos, Entity entity, float f) {
        if (this.blockBuilder.fallOnCallback != null) {
            EntityFallenOnBlockCallbackJS callbackJS = new EntityFallenOnBlockCallbackJS(level, entity, blockPos, blockState, f);
            this.safeCallback(this.blockBuilder.fallOnCallback, callbackJS, "Error while an entity fell on custom block ");
        } else {
            super.fallOn(level, blockState, blockPos, entity, f);
        }
    }

    public void updateEntityAfterFallOn(BlockGetter blockGetter, Entity entity) {
        if (this.blockBuilder.afterFallenOnCallback != null) {
            AfterEntityFallenOnBlockCallbackJS callbackJS = new AfterEntityFallenOnBlockCallbackJS(blockGetter, entity);
            this.safeCallback(this.blockBuilder.afterFallenOnCallback, callbackJS, "Error while bouncing entity from custom block ");
            if (!callbackJS.hasChangedVelocity()) {
                super.updateEntityAfterFallOn(blockGetter, entity);
            }
        } else {
            super.updateEntityAfterFallOn(blockGetter, entity);
        }
    }

    public void wasExploded(Level level, BlockPos blockPos, Explosion explosion) {
        if (this.blockBuilder.explodedCallback != null) {
            BlockExplodedCallbackJS callbackJS = new BlockExplodedCallbackJS(level, blockPos, explosion);
            this.safeCallback(this.blockBuilder.explodedCallback, callbackJS, "Error while exploding custom block ");
        } else {
            super.wasExploded(level, blockPos, explosion);
        }
    }

    public BlockState rotate(BlockState blockState, Rotation rotation) {
        BlockStateRotateCallbackJS callbackJS;
        if (this.blockBuilder.rotateStateModification != null && this.safeCallback(this.blockBuilder.rotateStateModification, callbackJS = new BlockStateRotateCallbackJS(blockState, rotation), "Error while rotating BlockState of ")) {
            return callbackJS.getState();
        }
        return super.rotate(blockState, rotation);
    }

    public BlockState mirror(BlockState blockState, Mirror mirror) {
        BlockStateMirrorCallbackJS callbackJS;
        if (this.blockBuilder.mirrorStateModification != null && this.safeCallback(this.blockBuilder.mirrorStateModification, callbackJS = new BlockStateMirrorCallbackJS(blockState, mirror), "Error while mirroring BlockState of ")) {
            return callbackJS.getState();
        }
        return super.mirror(blockState, mirror);
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (this.blockBuilder.rightClick != null) {
            if (!level.isClientSide()) {
                this.blockBuilder.rightClick.accept(new BlockRightClickedKubeEvent(stack, player, hand, pos, hit.getDirection(), hit));
            }
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean bl) {
        if (!state.is(newState.getBlock())) {
            BlockEntityAttachment[] blockEntityAttachmentArray = level.getBlockEntity(pos);
            if (blockEntityAttachmentArray instanceof BlockEntityJS) {
                BlockEntityJS entity = (BlockEntityJS)blockEntityAttachmentArray;
                if (level instanceof ServerLevel) {
                    for (BlockEntityAttachment attachment : entity.attachments) {
                        attachment.onRemove(newState);
                    }
                }
                level.updateNeighbourForOutputSignal(pos, (Block)this);
            }
            super.onRemove(state, level, pos, newState, bl);
        }
    }

    public void setPlacedBy(Level level, BlockPos blockPos, BlockState blockState, @Nullable LivingEntity livingEntity, ItemStack itemStack) {
        BlockEntity blockEntity;
        if (livingEntity != null && !level.isClientSide() && (blockEntity = level.getBlockEntity(blockPos)) instanceof BlockEntityJS) {
            BlockEntityJS e = (BlockEntityJS)blockEntity;
            e.placerId = livingEntity.getUUID();
        }
    }

    public static class WithEntity
    extends BasicBlockJS
    implements EntityBlock {
        public WithEntity(BlockBuilder p) {
            super(p);
        }

        @Nullable
        public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
            return this.blockBuilder.blockEntityInfo.createBlockEntity(blockPos, blockState);
        }

        @Nullable
        public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
            return this.blockBuilder.blockEntityInfo.getTicker(level);
        }
    }

    public static class Builder
    extends BlockBuilder {
        public Builder(ResourceLocation i) {
            super(i);
        }

        @Override
        public Block createObject() {
            return this.blockEntityInfo != null ? new WithEntity(this) : new BasicBlockJS(this);
        }
    }
}

