/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.bindings;

import dev.latvian.mods.kubejs.script.KubeJSContext;
import dev.latvian.mods.rhino.Context;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record RegistryWrapper<T>(Registry<T> registry) implements Iterable<T>
{
    public static RegistryWrapper<?> of(Context cx, ResourceLocation id) {
        return ((KubeJSContext)cx).getRegistries().wrapRegistry(id);
    }

    public T get(ResourceLocation id) {
        return (T)this.registry.get(id);
    }

    public boolean contains(ResourceLocation id) {
        return this.registry.containsKey(id);
    }

    public Set<Map.Entry<ResourceLocation, T>> getEntrySet() {
        return this.registry.entrySet().stream().map(e -> Map.entry(((ResourceKey)e.getKey()).location(), e.getValue())).collect(Collectors.toSet());
    }

    public Map<ResourceLocation, T> getValueMap() {
        return this.registry.entrySet().stream().collect(Collectors.toMap(e -> ((ResourceKey)e.getKey()).location(), Map.Entry::getValue));
    }

    public List<T> getValues() {
        return this.registry.stream().collect(Collectors.toList());
    }

    public Set<ResourceLocation> getKeys() {
        return this.registry.keySet();
    }

    @Nullable
    public ResourceLocation getId(T value) {
        return this.registry.getKey(value);
    }

    @Override
    @NotNull
    public ListIterator<T> iterator() {
        return this.getValues().listIterator();
    }
}

