/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.bindings;

import dev.latvian.mods.kubejs.ingredient.TagIngredient;
import dev.latvian.mods.kubejs.ingredient.WildcardIngredient;
import dev.latvian.mods.kubejs.typings.Info;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import org.jetbrains.annotations.Nullable;

@Info(value="Various Ingredient related helper methods")
public interface IngredientWrapper {
    @Info(value="A completely empty ingredient that will only match air")
    public static final Ingredient none = Ingredient.EMPTY;
    @Info(value="An ingredient that matches everything")
    public static final Ingredient all = WildcardIngredient.INSTANCE.toVanilla();

    @Info(value="Returns an ingredient of the input")
    public static Ingredient of(Ingredient ingredient) {
        return ingredient;
    }

    @Info(value="Returns an ingredient of the input, with the specified count")
    public static SizedIngredient of(Ingredient ingredient, int count) {
        return ingredient.kjs$withCount(count);
    }

    @Info(value="Checks if the passed in object is an Ingredient.\nNote that this does not mean it will not function as an Ingredient if passed to something that requests one.\n")
    public static boolean isIngredient(@Nullable Object o) {
        return o instanceof Ingredient;
    }

    public static ItemStack first(Ingredient ingredient) {
        return ingredient.kjs$getFirst();
    }

    @Nullable
    public static TagKey<Item> tagKeyOf(Ingredient in) {
        ICustomIngredient iCustomIngredient;
        if (!in.isCustom() && in.getValues().length == 1 && (iCustomIngredient = in.getValues()[0]) instanceof Ingredient.TagValue) {
            Ingredient.TagValue value = (Ingredient.TagValue)iCustomIngredient;
            return value.tag();
        }
        iCustomIngredient = in.getCustomIngredient();
        if (iCustomIngredient instanceof TagIngredient) {
            TagIngredient tin = (TagIngredient)iCustomIngredient;
            return tin.tagKey;
        }
        return null;
    }
}

