/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs;

import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.KubeJSPaths;
import dev.latvian.mods.kubejs.level.BlockContainerJS;
import dev.latvian.mods.kubejs.script.KubeJSContext;
import dev.latvian.mods.kubejs.util.NBTUtils;
import dev.latvian.mods.kubejs.util.UtilsJS;
import dev.latvian.mods.rhino.Context;
import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.util.valueproviders.ClampedInt;
import net.minecraft.util.valueproviders.ClampedNormalFloat;
import net.minecraft.util.valueproviders.ClampedNormalInt;
import net.minecraft.util.valueproviders.ConstantFloat;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformFloat;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.loot.providers.number.BinomialDistributionGenerator;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public interface KubeJSTypeWrappers {
    public static IntProvider intProviderOf(Context cx, Object o) {
        List l;
        if (o instanceof Number) {
            Number n = (Number)o;
            return ConstantInt.of((int)n.intValue());
        }
        if (o instanceof List && !(l = (List)o).isEmpty()) {
            Number min = (Number)l.get(0);
            Number max = l.size() >= 2 ? (Number)((Number)l.get(1)) : (Number)min;
            return UniformInt.of((int)min.intValue(), (int)max.intValue());
        }
        if (o instanceof Map) {
            Optional decoded;
            Map m = (Map)o;
            UniformInt intBounds = KubeJSTypeWrappers.parseIntBounds(m);
            if (intBounds != null) {
                return intBounds;
            }
            if (m.containsKey("clamped")) {
                IntProvider source = KubeJSTypeWrappers.intProviderOf(cx, m.get("clamped"));
                UniformInt clampTo = KubeJSTypeWrappers.parseIntBounds(m);
                if (clampTo != null) {
                    return ClampedInt.of((IntProvider)source, (int)clampTo.getMinValue(), (int)clampTo.getMaxValue());
                }
            } else if (m.containsKey("clamped_normal")) {
                UniformInt clampTo = KubeJSTypeWrappers.parseIntBounds(m);
                int mean = ((Number)m.get("mean")).intValue();
                int deviation = ((Number)m.get("deviation")).intValue();
                if (clampTo != null) {
                    return ClampedNormalInt.of((float)mean, (float)deviation, (int)clampTo.getMinValue(), (int)clampTo.getMaxValue());
                }
            }
            if ((decoded = IntProvider.CODEC.parse(((KubeJSContext)cx).getRegistries().nbt(), (Object)NBTUtils.toTagCompound(cx, m)).result()).isPresent()) {
                return (IntProvider)decoded.get();
            }
        }
        return ConstantInt.of((int)0);
    }

    public static FloatProvider floatProviderOf(Context cx, Object o) {
        List l;
        if (o instanceof Number) {
            Number n = (Number)o;
            return ConstantFloat.of((float)n.floatValue());
        }
        if (o instanceof List && !(l = (List)o).isEmpty()) {
            Number min = (Number)l.get(0);
            Number max = l.size() >= 2 ? (Number)((Number)l.get(1)) : (Number)min;
            return UniformFloat.of((float)min.floatValue(), (float)max.floatValue());
        }
        if (o instanceof Map) {
            Optional decoded;
            Map m = (Map)o;
            UniformFloat floatBounds = KubeJSTypeWrappers.parseFloatBounds(m);
            if (floatBounds != null) {
                return floatBounds;
            }
            if (m.containsKey("clamped_normal")) {
                UniformFloat clampTo = KubeJSTypeWrappers.parseFloatBounds(m);
                int mean = ((Number)m.get("mean")).intValue();
                int deviation = ((Number)m.get("deviation")).intValue();
                if (clampTo != null) {
                    return ClampedNormalFloat.of((float)mean, (float)deviation, (float)clampTo.getMinValue(), (float)clampTo.getMaxValue());
                }
            }
            if ((decoded = FloatProvider.CODEC.parse(((KubeJSContext)cx).getRegistries().nbt(), (Object)NBTUtils.toTagCompound(cx, m)).result()).isPresent()) {
                return (FloatProvider)decoded.get();
            }
        }
        return ConstantFloat.of((float)0.0f);
    }

    public static NumberProvider numberProviderOf(Object o) {
        List l;
        if (o instanceof Number) {
            Number n = (Number)o;
            float f = n.floatValue();
            return UniformGenerator.between((float)f, (float)f);
        }
        if (o instanceof List && !(l = (List)o).isEmpty()) {
            Number min = (Number)l.get(0);
            Number max = l.size() >= 2 ? (Number)((Number)l.get(1)) : (Number)min;
            return UniformGenerator.between((float)min.floatValue(), (float)max.floatValue());
        }
        if (o instanceof Map) {
            Map m = (Map)o;
            if (m.containsKey("min") && m.containsKey("max")) {
                return UniformGenerator.between((float)((Number)m.get("min")).intValue(), (float)((Number)m.get("max")).floatValue());
            }
            if (m.containsKey("n") && m.containsKey("p")) {
                return BinomialDistributionGenerator.binomial((int)((Number)m.get("n")).intValue(), (float)((Number)m.get("p")).floatValue());
            }
            if (m.containsKey("value")) {
                float f = ((Number)m.get("value")).floatValue();
                return UniformGenerator.between((float)f, (float)f);
            }
        }
        return ConstantValue.exactly((float)0.0f);
    }

    public static Vec3 vec3Of(@Nullable Object o) {
        List list;
        if (o instanceof Vec3) {
            Vec3 vec = (Vec3)o;
            return vec;
        }
        if (o instanceof Entity) {
            Entity entity = (Entity)o;
            return entity.position();
        }
        if (o instanceof List && (list = (List)o).size() >= 3) {
            return new Vec3(UtilsJS.parseDouble(list.get(0), 0.0), UtilsJS.parseDouble(list.get(1), 0.0), UtilsJS.parseDouble(list.get(2), 0.0));
        }
        if (o instanceof BlockPos) {
            BlockPos pos = (BlockPos)o;
            return new Vec3((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5);
        }
        if (o instanceof BlockContainerJS) {
            BlockContainerJS block = (BlockContainerJS)o;
            return new Vec3((double)block.getPos().getX() + 0.5, (double)block.getPos().getY() + 0.5, (double)block.getPos().getZ() + 0.5);
        }
        return Vec3.ZERO;
    }

    public static BlockPos blockPosOf(@Nullable Object o) {
        List list;
        if (o instanceof BlockPos) {
            BlockPos pos = (BlockPos)o;
            return pos;
        }
        if (o instanceof List && (list = (List)o).size() >= 3) {
            return new BlockPos(UtilsJS.parseInt(list.get(0), 0), UtilsJS.parseInt(list.get(1), 0), UtilsJS.parseInt(list.get(2), 0));
        }
        if (o instanceof BlockContainerJS) {
            BlockContainerJS block = (BlockContainerJS)o;
            return block.getPos();
        }
        if (o instanceof Vec3) {
            Vec3 vec = (Vec3)o;
            return BlockPos.containing((double)vec.x, (double)vec.y, (double)vec.z);
        }
        return BlockPos.ZERO;
    }

    private static UniformInt parseIntBounds(Map<String, Object> m) {
        Object object = m.get("bounds");
        if (object instanceof List) {
            List bounds = (List)object;
            return UniformInt.of((int)UtilsJS.parseInt(bounds.get(0), 0), (int)UtilsJS.parseInt(bounds.get(1), 0));
        }
        if (m.containsKey("min") && m.containsKey("max")) {
            return UniformInt.of((int)((Number)m.get("min")).intValue(), (int)((Number)m.get("max")).intValue());
        }
        if (m.containsKey("min_inclusive") && m.containsKey("max_inclusive")) {
            return UniformInt.of((int)((Number)m.get("min_inclusive")).intValue(), (int)((Number)m.get("max_inclusive")).intValue());
        }
        if (m.containsKey("value")) {
            int f = ((Number)m.get("value")).intValue();
            return UniformInt.of((int)f, (int)f);
        }
        return null;
    }

    private static UniformFloat parseFloatBounds(Map<String, Object> m) {
        Object object = m.get("bounds");
        if (object instanceof List) {
            List bounds = (List)object;
            return UniformFloat.of((float)((float)UtilsJS.parseDouble(bounds.get(0), 0.0)), (float)((float)UtilsJS.parseDouble(bounds.get(1), 0.0)));
        }
        if (m.containsKey("min") && m.containsKey("max")) {
            return UniformFloat.of((float)((Number)m.get("min")).floatValue(), (float)((Number)m.get("max")).floatValue());
        }
        if (m.containsKey("min_inclusive") && m.containsKey("max_inclusive")) {
            return UniformFloat.of((float)((Number)m.get("min_inclusive")).floatValue(), (float)((Number)m.get("max_inclusive")).floatValue());
        }
        if (m.containsKey("value")) {
            float f = ((Number)m.get("value")).floatValue();
            return UniformFloat.of((float)f, (float)f);
        }
        return null;
    }

    @Nullable
    public static Path pathOf(Object o) {
        try {
            if (o instanceof Path) {
                return KubeJS.verifyFilePath((Path)o);
            }
            if (o == null || o.toString().isEmpty()) {
                return null;
            }
            return KubeJS.verifyFilePath(KubeJSPaths.GAMEDIR.resolve(o.toString()));
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Nullable
    public static File fileOf(Object o) {
        try {
            if (o instanceof File) {
                return KubeJS.verifyFilePath(((File)o).toPath()).toFile();
            }
            if (o == null || o.toString().isEmpty()) {
                return null;
            }
            return KubeJS.verifyFilePath(KubeJSPaths.GAMEDIR.resolve(o.toString())).toFile();
        }
        catch (Exception ex) {
            return null;
        }
    }
}

