/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.latvian.mods.kubejs.util.UtilsJS;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;

public interface KubeJSCodecs {
    public static final Codec<Character> CHARACTER = Codec.STRING.xmap(str -> Character.valueOf(str.charAt(0)), Object::toString);
    public static final StreamCodec<? super RegistryFriendlyByteBuf, IntProvider> INT_PROVIDER_STREAM_CODEC = ByteBufCodecs.fromCodecWithRegistries((Codec)IntProvider.CODEC);

    public static <E> Codec<E> stringResolverCodec(Function<E, String> toStringFunction, Function<String, E> fromStringFunction) {
        return Codec.STRING.flatXmap(str -> Optional.ofNullable(fromStringFunction.apply((String)str)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown element id: " + str)), object -> DataResult.success((Object)((String)toStringFunction.apply(object))));
    }

    public static <E extends Enum<E>> E byName(Codec<E> codec, String s) {
        return (E)((Enum)KubeJSCodecs.fromJsonOrThrow((JsonElement)new JsonPrimitive(s), codec));
    }

    public static <E> E fromJsonOrThrow(JsonElement json, Codec<E> codec) {
        return KubeJSCodecs.fromJsonOrThrow(json, codec, str -> {
            throw new JsonSyntaxException("Could not decode element from JSON: " + str);
        });
    }

    public static <E> JsonElement toJsonOrThrow(E value, Codec<E> codec) {
        return KubeJSCodecs.toJsonOrThrow(value, codec, str -> {
            throw new IllegalArgumentException("Could not encode element to JSON: " + str);
        });
    }

    public static <E, X extends Throwable> E fromJsonOrThrow(JsonElement json, Codec<E> codec, Function<String, X> onError) throws X {
        return (E)codec.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(onError);
    }

    public static <E, X extends Throwable> JsonElement toJsonOrThrow(E value, Codec<E> codec, Function<String, X> onError) throws X {
        return (JsonElement)codec.encodeStart((DynamicOps)JsonOps.INSTANCE, value).getOrThrow(onError);
    }

    public static <T> String getUniqueId(T input, Codec<T> codec) {
        return UtilsJS.getUniqueId(input, (T o) -> KubeJSCodecs.toJsonOrThrow(o, codec));
    }

    public static JsonElement numberProviderJson(NumberProvider gen) {
        return KubeJSCodecs.toJsonOrThrow(gen, NumberProviders.CODEC);
    }

    public static <T> Codec<List<T>> listOfOrSelf(Codec<T> codec) {
        return Codec.withAlternative((Codec)codec.listOf(), (Codec)codec.xmap(List::of, List::getFirst));
    }
}

