/*
 * Decompiled with CFR 0.152.
 */
package com.matthewperiut.chisel.inventory;

import com.matthewperiut.chisel.block.ChiselGroupLookup;
import com.matthewperiut.chisel.inventory.IInventory;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ChiselInventory
implements IInventory {
    private final NonNullList<ItemStack> inventory = NonNullList.withSize((int)61, (Object)ItemStack.EMPTY);

    @Override
    public NonNullList<ItemStack> getItems() {
        return this.inventory;
    }

    @Override
    public void setItem(int slot, ItemStack stack) {
        this.getItems().set(slot, (Object)stack);
        if (slot == 0) {
            this.refresh(stack.getItem());
        }
    }

    @Override
    public ItemStack removeItem(int slot, int count) {
        ItemStack result = ContainerHelper.removeItem(this.getItems(), (int)slot, (int)count);
        if (!result.isEmpty()) {
            this.setChanged();
            if (slot != 0) {
                result.setCount(((ItemStack)this.inventory.get(0)).getCount());
            }
        }
        return result;
    }

    public void refresh(Item item) {
        if (!(item instanceof BlockItem)) {
            this.clearInv();
            return;
        }
        List<Item> chiselBlocks = ChiselGroupLookup.getBlocksInGroup(item);
        this.populate(chiselBlocks);
    }

    public void populate(List<Item> chiselBlocks) {
        this.clearInv();
        for (int i = 0; i < 60 && i < chiselBlocks.size(); ++i) {
            this.setItem(i + 1, new ItemStack((ItemLike)chiselBlocks.get(i), 1));
        }
    }

    public void clearInv() {
        for (int i = 1; i < this.inventory.size(); ++i) {
            this.setItem(i, ItemStack.EMPTY);
        }
    }
}

