/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.tiab.common.entities;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.state.BlockState;
import org.mangorage.tiab.common.core.CommonRegistration;

public class TimeAcceleratorEntity
extends Entity {
    private static final EntityDataAccessor<Integer> timeRate = SynchedEntityData.defineId(TimeAcceleratorEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> timeRemaining = SynchedEntityData.defineId(TimeAcceleratorEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private BlockPos pos;

    public TimeAcceleratorEntity(EntityType entityType, Level worldIn) {
        super(entityType, worldIn);
        this.entityData.set(timeRate, (Object)1);
    }

    public TimeAcceleratorEntity(Level worldIn, BlockPos pos) {
        this(CommonRegistration.ACCELERATOR_ENTITY.get(), worldIn);
        this.pos = pos;
        this.setPos((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(timeRate, (Object)1);
        builder.define(timeRemaining, (Object)0);
    }

    public void tick() {
        super.tick();
        Level level = this.level();
        if (this.pos == null) {
            if (!level.isClientSide) {
                this.remove(Entity.RemovalReason.KILLED);
            }
            return;
        }
        BlockState blockState = level.getBlockState(this.pos);
        ServerLevel serverWorld = level.getServer().getLevel(level.dimension());
        BlockEntity targetTE = level.getBlockEntity(this.pos);
        for (int i = 0; i < this.getTimeRate(); ++i) {
            if (targetTE != null) {
                BlockEntityTicker ticker = targetTE.getBlockState().getTicker(level, targetTE.getType());
                if (ticker == null) continue;
                ticker.tick(level, this.pos, targetTE.getBlockState(), targetTE);
                continue;
            }
            if (serverWorld != null && blockState.isRandomlyTicking()) {
                if (level.random.nextInt(1365) != 0) continue;
                blockState.randomTick(serverWorld, this.pos, level.random);
                continue;
            }
            this.remove(Entity.RemovalReason.KILLED);
            break;
        }
        this.setRemainingTime(this.getRemainingTime() - 1);
        if (this.getRemainingTime() <= 0 && !level.isClientSide) {
            this.remove(Entity.RemovalReason.KILLED);
        }
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        this.entityData.set(timeRate, (Object)compound.getInt("timeRate"));
        this.setRemainingTime(compound.getInt("remainingTime"));
        this.pos = NbtUtils.readBlockPos((CompoundTag)compound, (String)"position").orElse(new BlockPos(0, 0, 0));
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        compound.putInt("timeRate", this.getTimeRate());
        compound.putInt("remainingTime", this.getRemainingTime());
        compound.put("position", NbtUtils.writeBlockPos((BlockPos)this.pos));
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity serverEntity) {
        return new ClientboundAddEntityPacket((Entity)this, serverEntity);
    }

    public int getTimeRate() {
        return (Integer)this.entityData.get(timeRate);
    }

    public void setTimeRate(int rate) {
        this.entityData.set(timeRate, (Object)rate);
    }

    public int getRemainingTime() {
        return (Integer)this.entityData.get(timeRemaining);
    }

    public void setRemainingTime(int remainingTime) {
        this.entityData.set(timeRemaining, (Object)remainingTime);
    }
}

