/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.tiab.common.core.registry;

import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import org.mangorage.tiab.common.core.registry.RegistryWrapper;

public class RegistryHolder<T>
implements Supplier<T> {
    private final ResourceLocation id;
    private final Registry<?> defaultRegistry;
    private Supplier<T> supplier;
    private Holder<T> minecraftHolder;

    RegistryHolder(ResourceLocation id, Registry<?> defaultRegistry, Supplier<T> supplier) {
        this.id = id;
        this.defaultRegistry = defaultRegistry;
        this.supplier = supplier;
    }

    T getUnSafe() {
        T instance = this.supplier.get();
        this.supplier = null;
        return instance;
    }

    @Override
    public T get() {
        if (this.minecraftHolder == null) {
            throw new IllegalStateException("RegistryHolder not yet populated...");
        }
        return (T)this.minecraftHolder.value();
    }

    public Supplier<T> asSupplier() {
        return this;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public Holder<T> getHolder() {
        return this.minecraftHolder;
    }

    void handleRegister(RegistryWrapper registry) {
        this.minecraftHolder = registry.registerForHolder(this.id, this.getUnSafe());
    }

    void handleDefaultRegister() {
        this.minecraftHolder = Registry.registerForHolder(this.defaultRegistry, (ResourceLocation)this.id, this.getUnSafe());
    }
}

