/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.tiab.common.core.registry;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import org.mangorage.tiab.common.core.registry.RegistryHolder;
import org.mangorage.tiab.common.core.registry.RegistryWrapper;

public final class RegistryController {
    private static final Set<ResourceKey<? extends Registry<?>>> RESOURCE_KEYS = new LinkedHashSet();
    private final Map<ResourceKey<Registry<?>>, List<RegistryHolder<?>>> REGISTRIES = new LinkedHashMap();
    private final String modID;
    private boolean frozen = false;

    public static RegistryController create(String modID) {
        return new RegistryController(modID);
    }

    private RegistryController(String modID) {
        this.modID = modID;
    }

    public <T extends E, E> RegistryHolder<T> register(String id, ResourceKey<Registry<E>> resourceKey, Registry<E> defaultRegistry, Supplier<T> supplier) {
        if (this.frozen) {
            throw new IllegalStateException("Cannot register, RegistryController is frozen.");
        }
        RegistryHolder<T> holder = new RegistryHolder<T>(ResourceLocation.fromNamespaceAndPath((String)this.modID, (String)id), defaultRegistry, supplier);
        this.REGISTRIES.computeIfAbsent(resourceKey, o -> new ArrayList()).add(holder);
        return holder;
    }

    public void register(ResourceKey<? extends Registry<?>> resourceKey, RegistryWrapper registry) {
        this.frozen = true;
        List<RegistryHolder<?>> list = this.REGISTRIES.get(resourceKey);
        if (list == null) {
            return;
        }
        list.forEach(holder -> holder.handleRegister(registry));
        this.REGISTRIES.remove(resourceKey);
    }

    public void registerUsingDefault() {
        RESOURCE_KEYS.forEach(key -> this.register((ResourceKey<? extends Registry<?>>)key, new RegistryWrapper(){
            final /* synthetic */ ResourceKey val$key;
            {
                this.val$key = resourceKey;
            }

            @Override
            public <T> Holder<T> registerForHolder(ResourceLocation id, T object) {
                return Registry.registerForHolder((Registry)((Registry)BuiltInRegistries.REGISTRY.get(this.val$key.location())), (ResourceLocation)id, object);
            }
        }));
    }

    static {
        RESOURCE_KEYS.add(Registries.DATA_COMPONENT_TYPE);
        RESOURCE_KEYS.add(Registries.ITEM);
        RESOURCE_KEYS.add(Registries.ENTITY_TYPE);
        RESOURCE_KEYS.add(Registries.CREATIVE_MODE_TAB);
    }
}

