/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.tiab.common.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.MessageArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.mangorage.tiab.common.core.CommonRegistration;
import org.mangorage.tiab.common.core.StoredTimeComponent;
import org.mangorage.tiab.common.items.TiabItem;
import org.mangorage.tiab.common.misc.CommonHelper;

public class TiabCommands {
    private static final String ADD_TIME_COMMAND = "addTime";
    private static final String REMOVE_TIME_COMMAND = "removeTime";
    private static final String TIME_PARAM = "seconds";
    public static LiteralArgumentBuilder<CommandSourceStack> addTimeCommand = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"addTime").requires(commandSource -> commandSource.hasPermission(2))).then(Commands.argument((String)"seconds", (ArgumentType)MessageArgument.message()).executes(ctx -> {
        try {
            return TiabCommands.processTimeCommand((CommandContext<CommandSourceStack>)ctx, true);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }));
    public static LiteralArgumentBuilder<CommandSourceStack> removeTimeCommand = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"removeTime").requires(commandSource -> commandSource.hasPermission(2))).then(Commands.argument((String)"seconds", (ArgumentType)MessageArgument.message()).executes(ctx -> {
        try {
            return TiabCommands.processTimeCommand((CommandContext<CommandSourceStack>)ctx, false);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }));

    private static int processTimeCommand(CommandContext<CommandSourceStack> ctx, boolean isAdd) throws CommandSyntaxException {
        Component messageValue = MessageArgument.getMessage(ctx, (String)TIME_PARAM);
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        ServerPlayer player = source.getPlayerOrException();
        if (!messageValue.getString().isEmpty()) {
            try {
                int timeToAdd = Integer.parseInt(messageValue.getString());
                if (timeToAdd < 0) {
                    throw new NumberFormatException();
                }
                if (timeToAdd > CommonRegistration.SERVER_CONFIG.get().MAX_STORED_TIME() / CommonRegistration.SERVER_CONFIG.get().TICKS_CONST()) {
                    timeToAdd = CommonRegistration.SERVER_CONFIG.get().MAX_STORED_TIME() / CommonRegistration.SERVER_CONFIG.get().TICKS_CONST();
                }
                boolean success = false;
                for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
                    int timeToAddFinal;
                    ItemStack invStack = player.getInventory().getItem(i);
                    Item item = invStack.getItem();
                    if (!(item instanceof TiabItem)) continue;
                    TiabItem itemTiab = (TiabItem)item;
                    int currentStoredEnergy = itemTiab.getStoredComponent(invStack).stored();
                    if (!isAdd) {
                        if (currentStoredEnergy / CommonRegistration.SERVER_CONFIG.get().TICKS_CONST() < timeToAdd) {
                            timeToAdd = currentStoredEnergy / CommonRegistration.SERVER_CONFIG.get().TICKS_CONST();
                        }
                        timeToAdd = -timeToAdd;
                    }
                    if (CommonHelper.isPositive(currentStoredEnergy + (timeToAddFinal = timeToAdd) * CommonRegistration.SERVER_CONFIG.get().TICKS_CONST())) {
                        CommonHelper.modify(invStack, CommonRegistration.STORED_TIME_COMPONENT.get(), () -> new StoredTimeComponent(0, 0), old -> new StoredTimeComponent(currentStoredEnergy + timeToAddFinal * CommonRegistration.SERVER_CONFIG.get().TICKS_CONST(), old.total()));
                        CommonHelper.sendStatusMessage(player, String.format("%s %d seconds", isAdd ? "Added" : "Removed ", timeToAdd));
                    }
                    success = true;
                }
                if (!success) {
                    CommonHelper.sendStatusMessage(player, "No Time in a bottle item in inventory");
                }
                return 1;
            }
            catch (NumberFormatException ex) {
                CommonHelper.sendStatusMessage(player, "Invalid time parameter! (is the number too big?)");
            }
        } else {
            CommonHelper.sendStatusMessage(player, "Empty time parameter!");
        }
        return 0;
    }
}

