/*
 * Decompiled with CFR 0.152.
 */
package einstein.tbouncepad;

import einstein.tbouncepad.TinkersBouncePad;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class BouncePadBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final IntegerProperty DIRECTION = IntegerProperty.create((String)"direction", (int)0, (int)7);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    protected static final VoxelShape BOTTOM = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    protected static final VoxelShape TOP = Block.box((double)2.0, (double)8.0, (double)2.0, (double)14.0, (double)10.0, (double)14.0);
    protected static final VoxelShape[] SHAPES = new VoxelShape[]{Shapes.or((VoxelShape)BOTTOM, (VoxelShape[])new VoxelShape[]{TOP, Block.box((double)6.0, (double)8.0, (double)1.0, (double)10.0, (double)11.0, (double)5.0)}), Shapes.or((VoxelShape)BOTTOM, (VoxelShape[])new VoxelShape[]{TOP, Block.box((double)11.0, (double)8.0, (double)1.0, (double)15.0, (double)11.0, (double)5.0)}), Shapes.or((VoxelShape)BOTTOM, (VoxelShape[])new VoxelShape[]{TOP, Block.box((double)11.0, (double)8.0, (double)6.0, (double)15.0, (double)11.0, (double)10.0)}), Shapes.or((VoxelShape)BOTTOM, (VoxelShape[])new VoxelShape[]{TOP, Block.box((double)11.0, (double)8.0, (double)11.0, (double)15.0, (double)11.0, (double)15.0)}), Shapes.or((VoxelShape)BOTTOM, (VoxelShape[])new VoxelShape[]{TOP, Block.box((double)6.0, (double)8.0, (double)11.0, (double)10.0, (double)11.0, (double)15.0)}), Shapes.or((VoxelShape)BOTTOM, (VoxelShape[])new VoxelShape[]{TOP, Block.box((double)1.0, (double)8.0, (double)11.0, (double)5.0, (double)11.0, (double)15.0)}), Shapes.or((VoxelShape)BOTTOM, (VoxelShape[])new VoxelShape[]{TOP, Block.box((double)1.0, (double)8.0, (double)6.0, (double)5.0, (double)11.0, (double)10.0)}), Shapes.or((VoxelShape)BOTTOM, (VoxelShape[])new VoxelShape[]{TOP, Block.box((double)1.0, (double)8.0, (double)1.0, (double)5.0, (double)11.0, (double)5.0)})};

    public BouncePadBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)DIRECTION, (Comparable)Integer.valueOf(0))).setValue((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return SHAPES[(Integer)state.getValue((Property)DIRECTION)];
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)DIRECTION, (Comparable)Integer.valueOf(Mth.floor((float)((180.0f + context.getRotation()) * 8.0f / 360.0f + 0.5f)) & 7));
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{DIRECTION, WATERLOGGED});
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)DIRECTION, (Comparable)Integer.valueOf(rotation.rotate(((Integer)state.getValue((Property)DIRECTION)).intValue(), 8)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return (BlockState)state.setValue((Property)DIRECTION, (Comparable)Integer.valueOf(mirror.mirror(((Integer)state.getValue((Property)DIRECTION)).intValue(), 8)));
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        double moveX = 0.0;
        double moveZ = 0.0;
        double force = 0.25;
        if (!entity.isCrouching()) {
            switch ((Integer)state.getValue((Property)DIRECTION)) {
                default: {
                    moveZ -= force;
                    break;
                }
                case 1: {
                    moveZ -= force;
                    moveX += force;
                    break;
                }
                case 2: {
                    moveX += force;
                    break;
                }
                case 3: {
                    moveZ += force;
                    moveX += force;
                    break;
                }
                case 4: {
                    moveZ += force;
                    break;
                }
                case 5: {
                    moveZ += force;
                    moveX -= force;
                    break;
                }
                case 6: {
                    moveX -= force;
                    break;
                }
                case 7: {
                    moveZ -= force;
                    moveX -= force;
                }
            }
            entity.push(moveX, 0.5, moveZ);
            if (((Boolean)TinkersBouncePad.BOUNCE_SOUND.get()).booleanValue()) {
                level.playLocalSound((double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.5f), (double)((float)pos.getZ() + 0.5f), this.soundType.getStepSound(), SoundSource.BLOCKS, this.soundType.getVolume() / 2.0f, this.soundType.getPitch() * 0.65f, false);
            }
        }
        if (entity instanceof ItemEntity) {
            entity.yOld += 1.0;
            entity.push(moveX, 0.5, moveZ);
        }
        entity.resetFallDistance();
    }
}

