/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.util;

import com.direwolf20.justdirethings.client.particles.itemparticle.ItemFlowParticleData;
import com.mojang.authlib.GameProfile;
import java.util.OptionalInt;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemCooldowns;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.util.FakePlayer;

public class UsefulFakePlayer
extends FakePlayer {
    private double reach;

    public UsefulFakePlayer(Level world, GameProfile name) {
        super((ServerLevel)world, name);
        this.setReach(this.getAttributeValue(Attributes.BLOCK_INTERACTION_RANGE));
    }

    public OptionalInt openMenu(MenuProvider p_9033_) {
        return OptionalInt.empty();
    }

    public float getAttackStrengthScale(float adjustTicks) {
        return 1.0f;
    }

    public ItemCooldowns getCooldowns() {
        return new ItemCooldowns();
    }

    public boolean canBeSeenByAnyone() {
        return false;
    }

    public Entity changeDimension(DimensionTransition dimensionTransition) {
        return UsefulFakePlayer.createPlayer((Level)dimensionTransition.newLevel(), this.getGameProfile());
    }

    public void fakeupdateUsingItem(ItemStack itemStack) {
        this.updateUsingItem(itemStack);
    }

    public double getReach() {
        return this.reach;
    }

    public void setReach(double reach) {
        this.reach = reach;
    }

    public static UsefulFakePlayer createPlayer(Level world, GameProfile profile) {
        return new UsefulFakePlayer(world, profile);
    }

    public void drawParticles(ServerLevel serverLevel, ItemStack itemStack) {
        Vec3 base = new Vec3(this.getX(), this.getEyeY(), this.getZ());
        Vec3 look = this.getLookAngle();
        Vec3 target = base.add(look.x * 0.9, look.y * 0.9, look.z * 0.9);
        ItemFlowParticleData data = new ItemFlowParticleData(itemStack, target.x, target.y, target.z, 5);
        double d0 = base.x();
        double d1 = base.y();
        double d2 = base.z();
        serverLevel.sendParticles((ParticleOptions)data, d0, d1, d2, 10, 0.0, 0.0, 0.0, 0.0);
    }
}

