/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.common.items.tools.basetools;

import com.direwolf20.justdirethings.common.items.interfaces.Ability;
import com.direwolf20.justdirethings.common.items.interfaces.AbilityParams;
import com.direwolf20.justdirethings.common.items.interfaces.LeftClickableTool;
import com.direwolf20.justdirethings.common.items.interfaces.PoweredTool;
import com.direwolf20.justdirethings.common.items.interfaces.ToggleableTool;
import com.direwolf20.justdirethings.setup.Config;
import com.direwolf20.justdirethings.util.TooltipHelpers;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.Nullable;

public class BaseAxe
extends AxeItem
implements ToggleableTool,
LeftClickableTool {
    protected final EnumSet<Ability> abilities = EnumSet.noneOf(Ability.class);
    protected final Map<Ability, AbilityParams> abilityParams = new EnumMap<Ability, AbilityParams>(Ability.class);

    public BaseAxe(Tier pTier, Item.Properties pProperties) {
        super(pTier, pProperties);
    }

    public InteractionResult useOn(UseOnContext pContext) {
        if (this.bindDrops(pContext)) {
            return InteractionResult.SUCCESS;
        }
        Level level = pContext.getLevel();
        boolean oldSnapshot = level.captureBlockSnapshots;
        level.captureBlockSnapshots = false;
        this.useOnAbility(pContext);
        level.captureBlockSnapshots = oldSnapshot;
        return super.useOn(pContext);
    }

    public boolean mineBlock(ItemStack pStack, Level pLevel, BlockState pState, BlockPos pPos, LivingEntity pEntityLiving) {
        return true;
    }

    public boolean hurtEnemy(ItemStack pStack, LivingEntity pTarget, LivingEntity pAttacker) {
        return this.hurtEnemyAbility(pStack, pTarget, pAttacker);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null || mc.player == null) {
            return;
        }
        boolean sneakPressed = Screen.hasShiftDown();
        TooltipHelpers.appendFEText(stack, tooltip);
        if (sneakPressed) {
            TooltipHelpers.appendToolEnabled(stack, tooltip);
            TooltipHelpers.appendAbilityList(stack, tooltip);
        } else {
            TooltipHelpers.appendToolEnabled(stack, tooltip);
            TooltipHelpers.appendShiftForInfo(stack, tooltip);
        }
    }

    public ItemAttributeModifiers getDefaultAttributeModifiers(ItemStack stack) {
        ItemAttributeModifiers itemAttributeModifiers = super.getDefaultAttributeModifiers(stack);
        Item item = stack.getItem();
        if (!(item instanceof PoweredTool)) {
            return itemAttributeModifiers;
        }
        PoweredTool poweredTool = (PoweredTool)item;
        return poweredTool.getPoweredAttributeModifiers(stack, itemAttributeModifiers);
    }

    @Override
    public EnumSet<Ability> getAllAbilities() {
        return this.abilities;
    }

    @Override
    public EnumSet<Ability> getAbilities() {
        return this.abilities.stream().filter(ability -> (Boolean)Config.AVAILABLE_ABILITY_MAP.get(ability).get()).collect(Collectors.toCollection(() -> EnumSet.noneOf(Ability.class)));
    }

    @Override
    public Map<Ability, AbilityParams> getAbilityParamsMap() {
        return this.abilityParams;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        if (!level.isClientSide && player.isShiftKeyDown()) {
            this.openSettings(player);
        }
        this.useAbility(level, player, hand);
        return super.use(level, player, hand);
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, @Nullable T entity, Consumer<Item> onBroken) {
        Item item = stack.getItem();
        if (item instanceof PoweredTool) {
            PoweredTool poweredTool = (PoweredTool)item;
            IEnergyStorage energyStorage = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
            if (energyStorage == null) {
                return amount;
            }
            HolderLookup.RegistryLookup registrylookup = entity.level().getServer().registryAccess().lookupOrThrow(Registries.ENCHANTMENT);
            int unbreakingLevel = stack.getEnchantmentLevel((Holder)registrylookup.getOrThrow(Enchantments.UNBREAKING));
            double reductionFactor = Math.min(1.0, (double)unbreakingLevel * 0.1);
            int finalEnergyCost = (int)Math.max(0.0, (double)amount - (double)amount * reductionFactor);
            energyStorage.extractEnergy(finalEnergyCost, false);
            return 0;
        }
        return amount;
    }

    public boolean isPrimaryItemFor(ItemStack stack, Holder<Enchantment> enchantment) {
        if (stack.getItem() instanceof PoweredTool) {
            return super.isPrimaryItemFor(stack, enchantment) && this.canAcceptEnchantments(enchantment);
        }
        return super.isPrimaryItemFor(stack, enchantment);
    }

    private boolean canAcceptEnchantments(Holder<Enchantment> enchantment) {
        return !((Enchantment)enchantment.value()).effects().has(EnchantmentEffectComponents.REPAIR_WITH_XP);
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.NONE;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }
}

