/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.common.items.interfaces;

import com.direwolf20.justdirethings.common.items.datacomponents.JustDireDataComponents;
import com.direwolf20.justdirethings.common.items.interfaces.Ability;
import com.direwolf20.justdirethings.common.items.interfaces.ToolRecords;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public interface LeftClickableTool {
    public static void setBindingMode(ItemStack stack, Ability ability, int mode) {
        stack.set((Supplier)JustDireDataComponents.ABILITY_BINDING_MODES.get((Object)ability), (Object)mode);
    }

    public static int getBindingMode(ItemStack stack, Ability ability) {
        return (Integer)stack.getOrDefault((Supplier)JustDireDataComponents.ABILITY_BINDING_MODES.get((Object)ability), (Object)0);
    }

    public static void removeFromLeftClickList(ItemStack stack, Ability ability) {
        Set<Ability> abilityList = LeftClickableTool.getLeftClickList(stack);
        abilityList.remove((Object)ability);
        LeftClickableTool.setLeftClickList(stack, abilityList);
    }

    public static void addToLeftClickList(ItemStack stack, Ability ability) {
        Set<Ability> abilityList = LeftClickableTool.getLeftClickList(stack);
        abilityList.add(ability);
        LeftClickableTool.setLeftClickList(stack, abilityList);
    }

    public static void setLeftClickList(ItemStack stack, Set<Ability> abilityList) {
        ArrayList<String> abilitiesNamesList = new ArrayList<String>();
        for (Ability ability : abilityList) {
            abilitiesNamesList.add(ability.getName());
        }
        stack.set(JustDireDataComponents.LEFT_CLICK_ABILITIES, abilitiesNamesList);
    }

    public static Set<Ability> getLeftClickList(ItemStack stack) {
        HashSet<Ability> abilities = new HashSet<Ability>();
        List abilitiesList = (List)stack.getOrDefault(JustDireDataComponents.LEFT_CLICK_ABILITIES, new ArrayList());
        for (String abilityName : abilitiesList) {
            abilities.add(Ability.byName(abilityName));
        }
        return abilities;
    }

    public static ToolRecords.AbilityBinding getAbilityBinding(ItemStack stack, Ability ability) {
        List<ToolRecords.AbilityBinding> abilityBindings = LeftClickableTool.getCustomBindingList(stack);
        return abilityBindings.stream().filter(k -> k.abilityName().equals(ability.getName())).findFirst().orElse(null);
    }

    public static void removeFromCustomBindingList(ItemStack stack, Ability ability) {
        ArrayList<ToolRecords.AbilityBinding> abilityBindings = new ArrayList<ToolRecords.AbilityBinding>(LeftClickableTool.getCustomBindingList(stack));
        abilityBindings.removeIf(k -> k.abilityName().equals(ability.getName()));
        LeftClickableTool.setCustomBindingList(stack, abilityBindings);
    }

    public static void addToCustomBindingList(ItemStack stack, ToolRecords.AbilityBinding binding) {
        Ability ability = Ability.byName(binding.abilityName());
        LeftClickableTool.removeFromCustomBindingList(stack, ability);
        List<ToolRecords.AbilityBinding> abilityList = LeftClickableTool.getCustomBindingList(stack);
        abilityList.add(binding);
        LeftClickableTool.setCustomBindingList(stack, abilityList);
    }

    public static void setCustomBindingList(ItemStack stack, List<ToolRecords.AbilityBinding> abilityList) {
        stack.set(JustDireDataComponents.ABILITY_BINDINGS, abilityList);
    }

    public static List<ToolRecords.AbilityBinding> getCustomBindingList(ItemStack stack) {
        return (List)stack.getOrDefault(JustDireDataComponents.ABILITY_BINDINGS, new ArrayList());
    }

    public static List<Ability> getCustomBindingListFor(ItemStack stack, int key, boolean isMouse) {
        ArrayList<Ability> returnSet = new ArrayList<Ability>();
        List<ToolRecords.AbilityBinding> abilityBindings = LeftClickableTool.getCustomBindingList(stack);
        returnSet.addAll(abilityBindings.stream().filter(k -> k.isMouse() == isMouse && k.key() == key && (Integer)stack.get((Supplier)JustDireDataComponents.ABILITY_BINDING_MODES.get((Object)Ability.byName(k.abilityName()))) == 2).map(ToolRecords.AbilityBinding::abilityName).map(Ability::byName).toList());
        return returnSet;
    }

    public static ItemStack getLeftClickableItem(Player player) {
        ItemStack mainHand = player.getMainHandItem();
        if (mainHand.getItem() instanceof LeftClickableTool) {
            return mainHand;
        }
        ItemStack offHand = player.getOffhandItem();
        if (offHand.getItem() instanceof LeftClickableTool) {
            return offHand;
        }
        return ItemStack.EMPTY;
    }
}

