/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.common.items.interfaces;

import com.direwolf20.justdirethings.common.items.interfaces.PoweredItem;
import com.direwolf20.justdirethings.util.TooltipHelpers;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public abstract class BasePoweredItem
extends Item {
    public BasePoweredItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null || mc.player == null) {
            return;
        }
        TooltipHelpers.appendFEText(stack, tooltip);
    }

    public boolean isBarVisible(ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof PoweredItem) {
            PoweredItem poweredItem = (PoweredItem)item;
            return poweredItem.isPowerBarVisible(stack);
        }
        return super.isBarVisible(stack);
    }

    public int getBarWidth(ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof PoweredItem) {
            PoweredItem poweredItem = (PoweredItem)item;
            return poweredItem.getPowerBarWidth(stack);
        }
        return super.getBarWidth(stack);
    }

    public int getBarColor(ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof PoweredItem) {
            PoweredItem poweredItem = (PoweredItem)item;
            int color = poweredItem.getPowerBarColor(stack);
            if (color == -1) {
                return super.getBarColor(stack);
            }
            return color;
        }
        return super.getBarColor(stack);
    }
}

