/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.common.items.interfaces;

import com.direwolf20.justdirethings.common.items.interfaces.AbilityMethods;
import com.direwolf20.justdirethings.common.items.interfaces.AbilityParams;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;

public enum Ability {
    MOBSCANNER(SettingType.TOGGLE, 10, 500, UseType.USE, BindingType.LEFT_AND_CUSTOM, AbilityMethods::scanForMobScanner, false),
    OREMINER(SettingType.TOGGLE, 1, 50, UseType.PASSIVE, BindingType.CUSTOM_ONLY),
    ORESCANNER(SettingType.TOGGLE, 10, 500, UseType.USE, BindingType.LEFT_AND_CUSTOM, AbilityMethods::scanForOreScanner, false),
    LAWNMOWER(SettingType.TOGGLE, 1, 50, UseType.USE, BindingType.LEFT_AND_CUSTOM, AbilityMethods::lawnmower, false),
    SKYSWEEPER(SettingType.TOGGLE, 1, 50, UseType.PASSIVE, BindingType.CUSTOM_ONLY),
    TREEFELLER(SettingType.TOGGLE, 1, 50, UseType.PASSIVE, BindingType.CUSTOM_ONLY),
    LEAFBREAKER(SettingType.TOGGLE, 1, 50, UseType.USE_ON, BindingType.LEFT_AND_CUSTOM, AbilityMethods::leafbreaker, false),
    RUNSPEED(SettingType.SLIDER, 1, 5, UseType.PASSIVE_TICK, BindingType.CUSTOM_ONLY, AbilityMethods::runSpeed, false),
    WALKSPEED(SettingType.SLIDER, 1, 5, UseType.PASSIVE_TICK, BindingType.CUSTOM_ONLY, AbilityMethods::walkSpeed, false),
    STEPHEIGHT(SettingType.TOGGLE, 1, 5, UseType.PASSIVE, BindingType.CUSTOM_ONLY),
    JUMPBOOST(SettingType.SLIDER, 1, 5, UseType.PASSIVE, BindingType.CUSTOM_ONLY, AbilityMethods::jumpBoost, false),
    MINDFOG(SettingType.TOGGLE, 1, 50, UseType.PASSIVE, BindingType.CUSTOM_ONLY),
    INVULNERABILITY(SettingType.SLIDER, 25, 5000, UseType.USE_COOLDOWN, BindingType.CUSTOM_ONLY, AbilityMethods::invulnerability, false, ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/overlay/invulnerability.png")),
    SMELTER(SettingType.TOGGLE, 1, 50, UseType.PASSIVE, BindingType.CUSTOM_ONLY),
    SMOKER(SettingType.TOGGLE, 1, 50, UseType.PASSIVE, BindingType.CUSTOM_ONLY),
    HAMMER(SettingType.CYCLE, 1, 50, UseType.PASSIVE, BindingType.CUSTOM_ONLY),
    LAVAREPAIR(SettingType.TOGGLE, 0, 0, UseType.PASSIVE, BindingType.CUSTOM_ONLY),
    CAUTERIZEWOUNDS(SettingType.TOGGLE, 30, 1500, UseType.USE_COOLDOWN, BindingType.LEFT_AND_CUSTOM, AbilityMethods::cauterizeWounds, false, ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/overlay/cauterizewounds.png")),
    AIRBURST(SettingType.SLIDER, 1, 250, UseType.USE, BindingType.LEFT_AND_CUSTOM, AbilityMethods::airBurst, false),
    SWIMSPEED(SettingType.SLIDER, 1, 5, UseType.PASSIVE_TICK, BindingType.CUSTOM_ONLY, AbilityMethods::swimSpeed, false),
    GROUNDSTOMP(SettingType.SLIDER, 25, 5000, UseType.USE_COOLDOWN, BindingType.CUSTOM_ONLY, AbilityMethods::groundstomp, false, ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/overlay/groundstomp.png")),
    EXTINGUISH(SettingType.SLIDER, 25, 5000, UseType.PASSIVE_COOLDOWN, BindingType.CUSTOM_ONLY, AbilityMethods::extinguish, false, ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/overlay/extinguish.png")),
    STUPEFY(SettingType.SLIDER, 25, 5000, UseType.USE_COOLDOWN, BindingType.CUSTOM_ONLY, AbilityMethods::stupefy, false, ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/overlay/stupefy.png")),
    DROPTELEPORT(SettingType.TOGGLE, 2, 100, UseType.PASSIVE, BindingType.CUSTOM_ONLY),
    VOIDSHIFT(SettingType.SLIDER, 1, 50, UseType.USE, BindingType.LEFT_AND_CUSTOM, AbilityMethods::voidShift, true),
    OREXRAY(SettingType.TOGGLE, 100, 5000, UseType.USE, BindingType.LEFT_AND_CUSTOM, AbilityMethods::scanForOreXRAY, false),
    GLOWING(SettingType.TOGGLE, 100, 5000, UseType.USE, BindingType.LEFT_AND_CUSTOM, AbilityMethods::glowing, false),
    INSTABREAK(SettingType.TOGGLE, 2, 250, UseType.PASSIVE, BindingType.CUSTOM_ONLY),
    ECLIPSEGATE(SettingType.TOGGLE, 1, 250, UseType.USE_ON, BindingType.LEFT_AND_CUSTOM, AbilityMethods::eclipseGate, false);

    final String name = this.name().toLowerCase(Locale.ROOT);
    final String localization;
    final SettingType settingType;
    final ResourceLocation iconLocation;
    final int durabilityCost;
    final int feCost;
    final BindingType bindingType;
    final boolean renderButton;
    final UseType useType;
    private static final Map<Ability, AbilityParams> dynamicParams;
    public AbilityAction action;
    public UseOnAbilityAction useOnAction;
    private ResourceLocation cooldownIcon;

    private Ability(SettingType settingType, int durabilityCost, int feCost, UseType useType, BindingType bindingType, boolean renderButton) {
        this.settingType = settingType;
        this.localization = "justdirethings.ability." + this.name;
        this.iconLocation = ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)("textures/gui/buttons/" + this.name + ".png"));
        this.durabilityCost = durabilityCost;
        this.feCost = feCost;
        this.bindingType = bindingType;
        this.renderButton = renderButton;
        this.useType = useType;
    }

    private Ability(SettingType settingType, int durabilityCost, int feCost, UseType useType, BindingType bindingType) {
        this(settingType, durabilityCost, feCost, useType, bindingType, false);
    }

    private Ability(SettingType settingType, int durabilityCost, int feCost, UseType useType, BindingType bindingType, AbilityAction action, boolean renderButton) {
        this(settingType, durabilityCost, feCost, useType, bindingType, renderButton);
        this.action = action;
    }

    private Ability(SettingType settingType, int durabilityCost, int feCost, UseType useType, BindingType bindingType, AbilityAction action, boolean renderButton, ResourceLocation cooldownIcon) {
        this(settingType, durabilityCost, feCost, useType, bindingType, renderButton);
        this.action = action;
        this.cooldownIcon = cooldownIcon;
    }

    private Ability(SettingType settingType, int durabilityCost, int feCost, UseType useType, BindingType bindingType, UseOnAbilityAction useOnAction, boolean renderButton) {
        this(settingType, durabilityCost, feCost, useType, bindingType, renderButton);
        this.useOnAction = useOnAction;
    }

    public boolean hasDynamicParams(Ability toolAbility) {
        return dynamicParams.containsKey((Object)toolAbility);
    }

    public String getLocalization() {
        return this.localization;
    }

    public String getName() {
        return this.name;
    }

    public SettingType getSettingType() {
        return this.settingType;
    }

    public ResourceLocation getIconLocation() {
        return this.iconLocation;
    }

    public int getDurabilityCost() {
        return this.durabilityCost;
    }

    public int getFeCost() {
        return this.feCost;
    }

    public boolean isBindable() {
        return this.bindingType != BindingType.NONE;
    }

    public BindingType getBindingType() {
        return this.bindingType;
    }

    public boolean hasRenderButton() {
        return this.renderButton;
    }

    public static Ability byName(String name) {
        return Ability.valueOf(name.toUpperCase(Locale.ROOT));
    }

    public ResourceLocation getCooldownIcon() {
        return this.cooldownIcon;
    }

    static {
        dynamicParams = new EnumMap<Ability, AbilityParams>(Ability.class);
    }

    public static enum SettingType {
        TOGGLE,
        SLIDER,
        CYCLE;

    }

    public static enum BindingType {
        NONE,
        CUSTOM_ONLY,
        LEFT_AND_CUSTOM;

    }

    public static enum UseType {
        USE,
        USE_ON,
        USE_COOLDOWN,
        PASSIVE,
        PASSIVE_TICK,
        PASSIVE_COOLDOWN;

    }

    @FunctionalInterface
    public static interface AbilityAction {
        public boolean execute(Level var1, Player var2, ItemStack var3);
    }

    @FunctionalInterface
    public static interface UseOnAbilityAction {
        public boolean execute(UseOnContext var1);
    }
}

