/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.common.items;

import com.direwolf20.justdirethings.common.entities.PortalEntity;
import com.direwolf20.justdirethings.common.entities.PortalProjectile;
import com.direwolf20.justdirethings.common.items.datacomponents.JustDireDataComponents;
import com.direwolf20.justdirethings.common.items.interfaces.BasePoweredItem;
import com.direwolf20.justdirethings.common.items.interfaces.PoweredItem;
import com.direwolf20.justdirethings.setup.Config;
import com.direwolf20.justdirethings.setup.Registration;
import java.util.List;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;

public class PortalGun
extends BasePoweredItem
implements PoweredItem {
    public PortalGun() {
        super(new Item.Properties().stacksTo(1));
    }

    @Override
    public int getMaxEnergy() {
        return (Integer)Config.PORTAL_GUN_V1_RF_CAPACITY.get();
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (!level.isClientSide) {
            if (!player.isShiftKeyDown()) {
                PortalGun.spawnProjectile(level, player, itemStack, false);
            } else {
                PortalGun.closeMyPortals((ServerLevel)level, itemStack);
            }
        }
        return InteractionResultHolder.fail((Object)itemStack);
    }

    public static void closeMyPortals(ServerLevel level, ItemStack itemStack) {
        UUID portalGunUUID = PortalGun.getUUID(itemStack);
        MinecraftServer server = level.getServer();
        for (ServerLevel serverLevel : server.getAllLevels()) {
            List customEntities = serverLevel.getEntities((EntityTypeTest)Registration.PortalEntity.get(), k -> k.getPortalGunUUID().equals(portalGunUUID));
            for (PortalEntity entity : customEntities) {
                entity.setDying();
            }
        }
    }

    public static void spawnProjectile(Level level, Player player, ItemStack itemStack, boolean isPrimaryType) {
        if (!PoweredItem.consumeEnergy(itemStack, (Integer)Config.PORTAL_GUN_V1_RF_COST.get())) {
            player.displayClientMessage((Component)Component.translatable((String)"justdirethings.lowenergy"), true);
            player.playNotifySound(SoundEvents.VAULT_INSERT_ITEM_FAIL, SoundSource.PLAYERS, 1.0f, 1.0f);
            return;
        }
        PortalProjectile projectile = new PortalProjectile(level, player, PortalGun.getUUID(itemStack), isPrimaryType, false);
        projectile.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 1.0f, 1.0f);
        level.addFreshEntity((Entity)projectile);
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.NONE;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public static UUID setUUID(ItemStack itemStack) {
        UUID uuid = UUID.randomUUID();
        itemStack.set(JustDireDataComponents.PORTALGUN_UUID, (Object)uuid);
        return uuid;
    }

    public static UUID getUUID(ItemStack itemStack) {
        if (!itemStack.has(JustDireDataComponents.PORTALGUN_UUID)) {
            return PortalGun.setUUID(itemStack);
        }
        return (UUID)itemStack.get(JustDireDataComponents.PORTALGUN_UUID);
    }
}

