/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.common.fluids.unstableportalfluid;

import com.direwolf20.justdirethings.datagen.JustDireBiomeTags;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.common.SoundActions;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidType;
import org.jetbrains.annotations.Nullable;

public class UnstablePortalFluidType
extends FluidType {
    public UnstablePortalFluidType() {
        super(FluidType.Properties.create().density(1000).viscosity(1000).temperature(300).sound(SoundActions.BUCKET_FILL, SoundEvents.BUCKET_FILL).sound(SoundActions.BUCKET_EMPTY, SoundEvents.BUCKET_EMPTY).sound(SoundActions.FLUID_VAPORIZE, SoundEvents.FIRE_EXTINGUISH));
    }

    public boolean isVaporizedOnPlacement(Level level, BlockPos pos, FluidStack stack) {
        return !level.getBiome(pos).is(JustDireBiomeTags.UNSTABLE_PORTAL_FLUID_VIABLE);
    }

    public void onVaporize(@Nullable Player player, Level level, BlockPos pos, FluidStack stack) {
        SoundEvent sound = this.getSound(player, (BlockGetter)level, pos, SoundActions.FLUID_VAPORIZE);
        level.playSound(player, pos, sound != null ? sound : SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 0.5f, 2.6f + (level.random.nextFloat() - level.random.nextFloat()) * 0.8f);
        for (int l = 0; l < 8; ++l) {
            level.addAlwaysVisibleParticle((ParticleOptions)ParticleTypes.DRAGON_BREATH, (double)pos.getX() + Math.random(), (double)pos.getY() + Math.random(), (double)pos.getZ() + Math.random(), 0.0, 0.0, 0.0);
        }
    }

    public boolean canConvertToSource(FluidState state, LevelReader reader, BlockPos pos) {
        return false;
    }

    public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
        consumer.accept(new IClientFluidTypeExtensions(this){
            private static final ResourceLocation UNDERWATER_LOCATION = ResourceLocation.parse((String)"textures/misc/underwater.png");
            private static final ResourceLocation UNSTABLE_PORTALFLUID_STILL = ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"block/fluid_source");
            private static final ResourceLocation UNSTABLE_PORTALFLUID_FLOW = ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"block/fluid_flowing");
            private static final ResourceLocation UNSTABLE_PORTALFLUID_OVERLAY = ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"block/fluid_overlay");

            public ResourceLocation getStillTexture() {
                return UNSTABLE_PORTALFLUID_STILL;
            }

            public ResourceLocation getFlowingTexture() {
                return UNSTABLE_PORTALFLUID_FLOW;
            }

            public ResourceLocation getOverlayTexture() {
                return UNSTABLE_PORTALFLUID_OVERLAY;
            }

            public ResourceLocation getRenderOverlayTexture(Minecraft mc) {
                return UNDERWATER_LOCATION;
            }

            public int getTintColor() {
                return -7077677;
            }

            public int getTintColor(FluidState state, BlockAndTintGetter getter, BlockPos pos) {
                return -7077677;
            }
        });
    }
}

