/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.common.events;

import com.direwolf20.justdirethings.common.items.interfaces.Ability;
import com.direwolf20.justdirethings.common.items.interfaces.PoweredItem;
import com.direwolf20.justdirethings.common.items.interfaces.PoweredTool;
import com.direwolf20.justdirethings.common.items.interfaces.ToggleableTool;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;

public class PlayerEvents {
    @SubscribeEvent
    public static void BreakSpeed(PlayerEvent.BreakSpeed event) {
        Player player = event.getEntity();
        ItemStack stack = player.getMainHandItem();
        int rfCost = 0;
        Item item = stack.getItem();
        if (item instanceof ToggleableTool) {
            ToggleableTool toggleableTool = (ToggleableTool)item;
            if (stack.isCorrectToolForDrops(event.getState())) {
                Item item2 = stack.getItem();
                if (item2 instanceof PoweredTool) {
                    PoweredTool poweredTool = (PoweredTool)item2;
                    if (PoweredItem.getAvailableEnergy(stack) < poweredTool.getBlockBreakFECost()) {
                        event.setNewSpeed(0.1f);
                        return;
                    }
                }
                Level level = player.level();
                BlockPos originalPos = (BlockPos)event.getPosition().get();
                BlockState originalState = level.getBlockState((BlockPos)event.getPosition().get());
                float originalDestroySpeed = originalState.getDestroySpeed((BlockGetter)level, originalPos);
                float targetSpeed = event.getOriginalSpeed();
                float cumulativeDestroy = 0.0f;
                if (originalDestroySpeed <= 0.0f) {
                    return;
                }
                Set<BlockPos> breakBlockPositions = toggleableTool.getBreakBlockPositions(stack, level, originalPos, (LivingEntity)player, originalState);
                if (!breakBlockPositions.isEmpty()) {
                    int radius = toggleableTool.canUseAbility(stack, Ability.HAMMER) ? ToggleableTool.getToolValue(stack, Ability.HAMMER.getName()) : 1;
                    for (BlockPos pos : breakBlockPositions) {
                        BlockState blockState = level.getBlockState(pos);
                        float destroySpeedTarget = blockState.getDestroySpeed((BlockGetter)level, pos);
                        cumulativeDestroy += destroySpeedTarget;
                    }
                    rfCost = ToggleableTool.getInstantRFCost(cumulativeDestroy);
                    float modifier = (float)breakBlockPositions.size() / (float)radius < 1.0f ? 1.0f : (float)breakBlockPositions.size() / (float)radius;
                    cumulativeDestroy = cumulativeDestroy / (float)breakBlockPositions.size() * modifier;
                    float relative = originalDestroySpeed / cumulativeDestroy;
                    targetSpeed = event.getOriginalSpeed() * relative;
                }
                if (toggleableTool.canUseAbility(stack, Ability.INSTABREAK) && stack.getItem() instanceof PoweredItem && PoweredItem.getAvailableEnergy(stack) >= rfCost) {
                    targetSpeed = 10000.0f;
                }
                if (targetSpeed != event.getOriginalSpeed()) {
                    event.setNewSpeed(targetSpeed);
                }
            }
        }
    }
}

