/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.common.events;

import com.direwolf20.justdirethings.datagen.recipes.FluidDropRecipe;
import com.direwolf20.justdirethings.setup.Registration;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.RecipesUpdatedEvent;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidType;
import org.jetbrains.annotations.Nullable;

public class EntityEvents {
    static Map<FluidInputs, BlockState> fluidCraftCache = new HashMap<FluidInputs, BlockState>();

    @SubscribeEvent
    public static void entityTick(EntityTickEvent.Post e) {
        BlockPos blockPos;
        Entity entity = e.getEntity();
        Level level = entity.level();
        if (!(entity instanceof ItemEntity)) {
            return;
        }
        ItemEntity itemEntity = (ItemEntity)entity;
        BlockState blockState = entity.getInBlockState();
        if (!(blockState.getBlock() instanceof LiquidBlock)) {
            return;
        }
        BlockState fluidDropOutput = EntityEvents.findRecipe(blockState, itemEntity);
        if (!fluidDropOutput.isAir() && level.setBlockAndUpdate(blockPos = entity.blockPosition(), fluidDropOutput)) {
            itemEntity.getItem().shrink(1);
            FluidStack fluidStack = new FluidStack(level.getFluidState(blockPos).getType(), 1000);
            FluidType fluidType = fluidStack.getFluidType();
            if (fluidType.isVaporizedOnPlacement(level, blockPos, fluidStack)) {
                level.setBlockAndUpdate(blockPos, Blocks.AIR.defaultBlockState());
                fluidType.onVaporize(null, level, blockPos, fluidStack);
            } else if (!level.isClientSide) {
                level.playSound(null, blockPos, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
    }

    @Nullable
    private static BlockState findRecipe(BlockState blockState, ItemEntity entity) {
        FluidInputs fluidInputs = new FluidInputs(blockState, entity.getItem().getItem());
        if (fluidCraftCache.containsKey(fluidInputs)) {
            return fluidCraftCache.get(fluidInputs);
        }
        RecipeManager recipeManager = entity.level().getRecipeManager();
        for (RecipeHolder recipe : recipeManager.getAllRecipesFor(Registration.FLUID_DROP_RECIPE_TYPE.get())) {
            FluidDropRecipe fluidDropRecipe;
            Recipe recipe2 = recipe.value();
            if (!(recipe2 instanceof FluidDropRecipe) || !(fluidDropRecipe = (FluidDropRecipe)recipe2).matches(blockState, entity.getItem())) continue;
            fluidCraftCache.put(fluidInputs, fluidDropRecipe.getOutput());
            break;
        }
        if (!fluidCraftCache.containsKey(fluidInputs)) {
            fluidCraftCache.put(fluidInputs, Blocks.AIR.defaultBlockState());
        }
        return fluidCraftCache.get(fluidInputs);
    }

    private static void clearCache() {
        fluidCraftCache.clear();
    }

    @SubscribeEvent
    public static void onServerStarted(ServerStartedEvent e) {
        EntityEvents.clearCache();
    }

    @SubscribeEvent
    public static void onReloadServerResources(AddReloadListenerEvent e) {
        EntityEvents.clearCache();
    }

    @SubscribeEvent
    public static void onClientRecipesUpdated(RecipesUpdatedEvent e) {
        EntityEvents.clearCache();
    }

    public record FluidInputs(BlockState blockState, Item item) {
    }
}

