/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.common.containers.handlers;

import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.ItemStackHandler;

public class PlayerHandler
extends ItemStackHandler {
    public final Player player;
    public final InventoryType inventoryType;

    public PlayerHandler(Player player, InventoryType inventoryType) {
        super(inventoryType.equals((Object)InventoryType.Inventory) ? player.getInventory().items : (inventoryType.equals((Object)InventoryType.Armor) ? player.getInventory().armor : player.getInventory().offhand));
        this.player = player;
        this.inventoryType = inventoryType;
    }

    public Inventory getInventory() {
        if (this.player == null) {
            return null;
        }
        return this.player.getInventory();
    }

    public boolean isPlayerInvalid() {
        return this.player == null || this.player.isRemoved();
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        if (this.isPlayerInvalid()) {
            return;
        }
        super.setStackInSlot(slot, stack);
    }

    public ItemStack getStackInSlot(int slot) {
        if (this.isPlayerInvalid()) {
            return ItemStack.EMPTY;
        }
        return super.getStackInSlot(slot);
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (this.isPlayerInvalid()) {
            return stack;
        }
        return super.insertItem(slot, stack, simulate);
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (this.isPlayerInvalid()) {
            return ItemStack.EMPTY;
        }
        return super.extractItem(slot, amount, simulate);
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        if (this.isPlayerInvalid()) {
            return false;
        }
        if (this.inventoryType.equals((Object)InventoryType.Inventory)) {
            return true;
        }
        if (this.inventoryType.equals((Object)InventoryType.Armor)) {
            if (slot == 0) {
                return stack.canEquip(EquipmentSlot.FEET, (LivingEntity)this.player);
            }
            if (slot == 1) {
                return stack.canEquip(EquipmentSlot.LEGS, (LivingEntity)this.player);
            }
            if (slot == 2) {
                return stack.canEquip(EquipmentSlot.CHEST, (LivingEntity)this.player);
            }
            if (slot == 3) {
                return stack.canEquip(EquipmentSlot.HEAD, (LivingEntity)this.player);
            }
        }
        return this.inventoryType.equals((Object)InventoryType.Offhand);
    }

    public static enum InventoryType {
        Inventory,
        Armor,
        Offhand;


        public InventoryType next() {
            InventoryType[] values = InventoryType.values();
            int nextOrdinal = (this.ordinal() + 1) % values.length;
            return values[nextOrdinal];
        }
    }
}

