/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.common.containers;

import com.direwolf20.justdirethings.common.containers.basecontainers.BaseContainer;
import com.direwolf20.justdirethings.common.containers.handlers.DataComponentHandler;
import com.direwolf20.justdirethings.common.containers.slots.FuelSlot;
import com.direwolf20.justdirethings.setup.Registration;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;

public class PocketGeneratorContainer
extends BaseContainer {
    public static final int SLOTS = 1;
    public DataComponentHandler handler;
    public ItemStack pocketGeneratorItemStack;
    public Player playerEntity;

    public PocketGeneratorContainer(int windowId, Inventory playerInventory, Player player, RegistryFriendlyByteBuf extraData) {
        this(windowId, playerInventory, player, (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)extraData));
    }

    public PocketGeneratorContainer(int windowId, Inventory playerInventory, Player player, ItemStack pocketGenerator) {
        super((MenuType)Registration.PocketGenerator_Container.get(), windowId);
        this.playerEntity = player;
        this.handler = new DataComponentHandler(pocketGenerator, 1);
        this.pocketGeneratorItemStack = pocketGenerator;
        if (this.handler != null) {
            this.addGeneratorSlots((IItemHandler)this.handler, 0, 80, 35, 1, 18);
        }
        this.addPlayerSlots(playerInventory, 8, 84);
    }

    public boolean stillValid(Player playerIn) {
        return playerIn.getMainHandItem().equals(this.pocketGeneratorItemStack);
    }

    protected int addGeneratorSlots(IItemHandler handler, int index, int x, int y, int amount, int dx) {
        for (int i = 0; i < amount; ++i) {
            this.addSlot((Slot)new FuelSlot(handler, index, x, y));
            x += dx;
            ++index;
        }
        return index;
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack currentStack = slot.getItem();
            if (index < 1 && !this.moveItemStackTo(currentStack, 1, 37, true)) {
                return ItemStack.EMPTY;
            }
            if (index >= 1 && !this.moveItemStackTo(currentStack, 0, 1, false)) {
                return ItemStack.EMPTY;
            }
            if (currentStack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.set(currentStack);
                slot.setChanged();
            }
            if (currentStack.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(playerIn, currentStack);
        }
        return itemstack;
    }

    public void removed(Player playerIn) {
        super.removed(playerIn);
    }
}

