/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.common.blocks.soil;

import com.direwolf20.justdirethings.common.blockentities.GooSoilBE;
import com.direwolf20.justdirethings.common.items.interfaces.Helpers;
import com.direwolf20.justdirethings.common.items.interfaces.ToggleableTool;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.CactusBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.piston.MovingPistonBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.common.util.TriState;
import net.neoforged.neoforge.items.IItemHandler;

public class GooSoilBase
extends FarmBlock {
    public GooSoilBase() {
        super(BlockBehaviour.Properties.of().sound(SoundType.GRAVEL).strength(2.0f).randomTicks());
    }

    public boolean canSurvive(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        BlockState blockstate = pLevel.getBlockState(pPos.above());
        if (blockstate.is(Blocks.BAMBOO) || blockstate.is(Blocks.CACTUS) || blockstate.is(Blocks.BAMBOO_SAPLING)) {
            return true;
        }
        return !blockstate.isSolid() || blockstate.getBlock() instanceof FenceGateBlock || blockstate.getBlock() instanceof MovingPistonBlock;
    }

    public TriState canSustainPlant(BlockState state, BlockGetter level, BlockPos soilPosition, Direction facing, BlockState plant) {
        if (facing != Direction.UP) {
            return TriState.FALSE;
        }
        if (plant.getBlock() == Blocks.CACTUS) {
            return TriState.TRUE;
        }
        if (plant.getBlock() == Blocks.SUGAR_CANE) {
            return TriState.TRUE;
        }
        if (plant.getBlock() == Blocks.BAMBOO || plant.getBlock() == Blocks.BAMBOO_SAPLING) {
            return TriState.TRUE;
        }
        if (plant.getBlock() == Blocks.NETHER_WART) {
            return TriState.TRUE;
        }
        if (plant.getBlock() instanceof BushBlock) {
            return TriState.TRUE;
        }
        return TriState.DEFAULT;
    }

    public void fallOn(Level pLevel, BlockState pState, BlockPos pPos, Entity pEntity, float pFallDistance) {
        pEntity.causeFallDamage(pFallDistance, 1.0f, pEntity.damageSources().fall());
    }

    public void tick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        super.tick(pState, pLevel, pPos, pRandom);
    }

    public void randomTick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        super.randomTick(pState, pLevel, pPos, pRandom);
    }

    public static void bonemealMe(ServerLevel pLevel, BlockPos pPos) {
        BlockState soilState = pLevel.getBlockState(pPos);
        if (!(soilState.getBlock() instanceof GooSoilBase) || (Integer)soilState.getValue((Property)MOISTURE) < 7) {
            return;
        }
        BlockPos cropPos = pPos.above();
        BlockState crop = pLevel.getBlockState(cropPos);
        BlockState crop1 = null;
        Block block = crop.getBlock();
        if (block instanceof CropBlock) {
            CropBlock cropblock = (CropBlock)block;
            if (!cropblock.isMaxAge(crop)) {
                crop1 = cropblock.getStateForAge(cropblock.getAge(crop) + 1);
            }
        } else if (crop.getBlock() instanceof StemBlock) {
            int k = (Integer)crop.getValue((Property)StemBlock.AGE);
            if (k < 7) {
                crop1 = (BlockState)crop.setValue((Property)StemBlock.AGE, (Comparable)Integer.valueOf(k + 1));
            }
        } else if (crop.is(Blocks.SWEET_BERRY_BUSH)) {
            int j = (Integer)crop.getValue((Property)SweetBerryBushBlock.AGE);
            if (j < 3) {
                crop1 = (BlockState)crop.setValue((Property)SweetBerryBushBlock.AGE, (Comparable)Integer.valueOf(j + 1));
            }
        } else if (crop.is(Blocks.SUGAR_CANE) || crop.is(Blocks.CACTUS)) {
            BlockPos blockpos = cropPos.above();
            int j = (Integer)crop.getValue((Property)CactusBlock.AGE);
            if (j == 15) {
                pLevel.setBlockAndUpdate(blockpos, crop.getBlock().defaultBlockState());
                BlockState blockstate = (BlockState)crop.setValue((Property)CactusBlock.AGE, (Comparable)Integer.valueOf(0));
                pLevel.setBlock(cropPos, blockstate, 4);
                pLevel.neighborChanged(blockstate, blockpos, crop.getBlock(), cropPos, false);
            } else {
                pLevel.setBlock(cropPos, (BlockState)crop.setValue((Property)CactusBlock.AGE, (Comparable)Integer.valueOf(j + 1)), 4);
            }
        }
        if (crop1 != null) {
            pLevel.setBlockAndUpdate(cropPos, crop1);
        }
    }

    public static List<ItemStack> harvestCrop(ServerLevel pLevel, BlockPos cropPos, BlockState crop) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        Block block = crop.getBlock();
        if (block instanceof CropBlock) {
            CropBlock cropBlock = (CropBlock)block;
            if (cropBlock.isMaxAge(crop)) {
                BlockState placeState = Blocks.AIR.defaultBlockState();
                BlockEntity blockEntity = pLevel.getBlockEntity(cropPos);
                drops.addAll(Block.getDrops((BlockState)crop, (ServerLevel)pLevel, (BlockPos)cropPos, (BlockEntity)blockEntity));
                for (ItemStack drop : drops) {
                    Item item = drop.getItem();
                    if (!(item instanceof BlockItem)) continue;
                    BlockItem blockItem = (BlockItem)item;
                    placeState = blockItem.getBlock().defaultBlockState();
                    drop.shrink(1);
                    break;
                }
                pLevel.destroyBlock(cropPos, false);
                pLevel.setBlockAndUpdate(cropPos, placeState);
            }
        } else if (crop.is(Blocks.SUGAR_CANE) || crop.is(Blocks.CACTUS) || crop.is(Blocks.BAMBOO)) {
            BlockPos pos;
            int i;
            ArrayList<BlockPos> posToCheck = new ArrayList<BlockPos>();
            for (i = 0; i < 10 && pLevel.getBlockState(pos = cropPos.above(i)).is(crop.getBlock()); ++i) {
                posToCheck.add(pos);
            }
            for (i = posToCheck.size() - 1; i >= 0; --i) {
                BlockPos clearPos = (BlockPos)posToCheck.get(i);
                BlockEntity blockEntity = pLevel.getBlockEntity(clearPos);
                drops.addAll(Block.getDrops((BlockState)pLevel.getBlockState(clearPos), (ServerLevel)pLevel, (BlockPos)clearPos, (BlockEntity)blockEntity));
                pLevel.destroyBlock(clearPos, false);
            }
        }
        return drops;
    }

    public static void teleportDrops(ServerLevel pLevel, BlockPos pPos, List<ItemStack> drops, BlockPos cropPos) {
        GooSoilBE gooSoilBE;
        IItemHandler handler;
        BlockEntity blockEntity = pLevel.getBlockEntity(pPos);
        if (blockEntity != null && blockEntity instanceof GooSoilBE && (handler = (gooSoilBE = (GooSoilBE)blockEntity).getAttachedInventory(pLevel)) != null) {
            Helpers.teleportDrops(drops, handler);
            if (drops.isEmpty()) {
                ToggleableTool.teleportParticles(pLevel, cropPos, 5);
            }
        }
    }

    public static void dropDrops(ServerLevel pLevel, List<ItemStack> drops, BlockPos cropPos) {
        for (ItemStack drop : drops) {
            ItemEntity itemEntity = new ItemEntity((Level)pLevel, (double)cropPos.getX(), (double)cropPos.getY(), (double)cropPos.getZ(), drop);
            itemEntity.lifespan = 40;
            pLevel.addFreshEntity((Entity)itemEntity);
        }
    }

    public static void autoHarvest(ServerLevel pLevel, BlockPos pPos) {
        List<ItemStack> drops;
        BlockPos secondPos;
        BlockState secondState;
        BlockPos cropPos = pPos.above();
        BlockState crop = pLevel.getBlockState(cropPos);
        if (crop.getBlock() instanceof CropBlock) {
            List<ItemStack> drops2 = GooSoilBase.harvestCrop(pLevel, cropPos, crop);
            if (!drops2.isEmpty()) {
                GooSoilBase.teleportDrops(pLevel, pPos, drops2, cropPos);
                GooSoilBase.dropDrops(pLevel, drops2, cropPos);
            }
        } else if ((crop.is(Blocks.SUGAR_CANE) || crop.is(Blocks.CACTUS) || crop.is(Blocks.BAMBOO)) && (secondState = pLevel.getBlockState(secondPos = cropPos.above())).is(crop.getBlock()) && !(drops = GooSoilBase.harvestCrop(pLevel, secondPos, secondState)).isEmpty()) {
            GooSoilBase.teleportDrops(pLevel, pPos, drops, secondPos);
            GooSoilBase.dropDrops(pLevel, drops, secondPos);
        }
    }
}

