/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.common.blockentities.basebe;

import com.direwolf20.justdirethings.common.capabilities.MachineEnergyStorage;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;

public interface PoweredMachineBE {
    default public int getMaxEnergy() {
        return 100000;
    }

    public ContainerData getContainerData();

    public MachineEnergyStorage getEnergyStorage();

    default public int getEnergyStored() {
        return this.getEnergyStorage().getEnergyStored();
    }

    default public void setEnergyStored(int value) {
        this.getEnergyStorage().setEnergy(value);
    }

    public int getStandardEnergyCost();

    default public boolean hasEnoughPower(int power) {
        return this.getEnergyStorage().extractEnergy(power, true) >= power;
    }

    default public int insertEnergy(int power, boolean simulate) {
        return this.getEnergyStorage().receiveEnergy(power, simulate);
    }

    default public int extractEnergy(int power, boolean simulate) {
        return this.getEnergyStorage().extractEnergy(power, simulate);
    }

    default public void chargeItemStack(ItemStack itemStack) {
        int acceptedEnergy;
        IEnergyStorage slotEnergy = (IEnergyStorage)itemStack.getCapability(Capabilities.EnergyStorage.ITEM);
        if (slotEnergy != null && (acceptedEnergy = slotEnergy.receiveEnergy(500, true)) > 0) {
            int extractedEnergy = this.getEnergyStorage().extractEnergy(acceptedEnergy, false);
            slotEnergy.receiveEnergy(extractedEnergy, false);
        }
    }
}

