/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.common.blockentities.basebe;

import com.direwolf20.justdirethings.client.particles.gooexplodeparticle.GooExplodeParticleData;
import com.direwolf20.justdirethings.datagen.recipes.GooSpreadRecipe;
import com.direwolf20.justdirethings.setup.Registration;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class GooBlockBE_Base
extends BlockEntity {
    public final Map<Direction, Integer> sidedCounters = new Object2IntOpenHashMap();
    public final Map<Direction, Integer> sidedDurations = new Object2IntOpenHashMap();

    public GooBlockBE_Base(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        for (Direction direction : Direction.values()) {
            this.sidedCounters.put(direction, -1);
            this.sidedDurations.put(direction, -1);
        }
    }

    public void updateSideCounter(Direction direction, int newCounter) {
        int oldCounter = this.sidedCounters.get(direction);
        this.sidedCounters.put(direction, newCounter);
        if (oldCounter >= 0 && newCounter == -1 && this.level.isClientSide) {
            this.spawnParticles(direction);
        }
    }

    public int counterReducer() {
        return 1;
    }

    public int getTier() {
        return 0;
    }

    public int getCraftingDuration(Direction direction) {
        return this.sidedDurations.get(direction);
    }

    public int getRemainingTimeFor(Direction direction) {
        return this.sidedCounters.get(direction);
    }

    public void tickClient() {
        this.tickCounters();
    }

    public void tickServer() {
        this.checkSides();
        this.tickCounters();
        this.setChanged();
    }

    public void spawnParticles(Direction side) {
        Random random = new Random();
        BlockPos startPos = this.getBlockPos().relative(side);
        ItemStack itemStack = new ItemStack((ItemLike)this.getBlockState().getBlock());
        GooExplodeParticleData data = new GooExplodeParticleData(itemStack);
        for (Direction direction : Direction.values()) {
            for (int i = 0; i < 100; ++i) {
                double randomX = 0.5 + 0.6 * (double)direction.getNormal().getX() + (direction.getNormal().getX() == 0 ? random.nextDouble() - 0.5 : 0.0);
                double randomY = 0.5 + 0.6 * (double)direction.getNormal().getY() + (direction.getNormal().getY() == 0 ? random.nextDouble() - 0.5 : 0.0);
                double randomZ = 0.5 + 0.6 * (double)direction.getNormal().getZ() + (direction.getNormal().getZ() == 0 ? random.nextDouble() - 0.5 : 0.0);
                this.level.addParticle((ParticleOptions)data, (double)startPos.getX() + randomX, (double)startPos.getY() + randomY, (double)startPos.getZ() + randomZ, 0.0, 0.0, 0.0);
            }
        }
    }

    public void tickCounters() {
        for (Direction direction : Direction.values()) {
            int sideCounter = this.sidedCounters.get(direction);
            if (sideCounter <= 0) continue;
            sideCounter = Math.max(sideCounter - this.counterReducer(), 0);
            this.updateSideCounter(direction, sideCounter);
        }
    }

    public void checkSides() {
        for (Direction direction : Direction.values()) {
            GooSpreadRecipe gooSpreadRecipe = this.findRecipe(this.getBlockPos().relative(direction));
            int sideCounter = this.sidedCounters.get(direction);
            if (gooSpreadRecipe != null) {
                if (sideCounter == -1) {
                    sideCounter = gooSpreadRecipe.getCraftingDuration();
                    this.updateSideCounter(direction, sideCounter);
                    this.sidedDurations.put(direction, sideCounter);
                    this.markDirtyClient();
                    continue;
                }
                if (sideCounter != 0) continue;
                this.setBlockToTarget(gooSpreadRecipe, direction);
                this.markDirtyClient();
                continue;
            }
            if (sideCounter == -1) continue;
            sideCounter = -1;
            this.updateSideCounter(direction, sideCounter);
            this.sidedDurations.put(direction, sideCounter);
            this.markDirtyClient();
        }
    }

    public void setBlockToTarget(GooSpreadRecipe gooSpreadRecipe, Direction direction) {
        if (gooSpreadRecipe.getOutput().hasProperty((Property)BlockStateProperties.FACING)) {
            this.level.setBlockAndUpdate(this.getBlockPos().relative(direction), (BlockState)gooSpreadRecipe.getOutput().setValue((Property)BlockStateProperties.FACING, (Comparable)direction));
        } else {
            this.level.setBlockAndUpdate(this.getBlockPos().relative(direction), gooSpreadRecipe.getOutput());
        }
        this.updateSideCounter(direction, -1);
        this.sidedDurations.put(direction, -1);
        this.level.playSound(null, this.getBlockPos(), SoundEvents.SCULK_BLOCK_BREAK, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    @Nullable
    private GooSpreadRecipe findRecipe(BlockPos coords) {
        BlockState state = this.getLevel().getBlockState(coords);
        RecipeManager recipeManager = this.getLevel().getRecipeManager();
        for (RecipeHolder recipe : recipeManager.getAllRecipesFor(Registration.GOO_SPREAD_RECIPE_TYPE.get())) {
            GooSpreadRecipe gooSpreadRecipe;
            Recipe recipe2 = recipe.value();
            if (!(recipe2 instanceof GooSpreadRecipe) || !(gooSpreadRecipe = (GooSpreadRecipe)recipe2).matches(this.getLevel(), coords, this, state)) continue;
            return gooSpreadRecipe;
        }
        return null;
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        ListTag counterListTag = new ListTag();
        for (Direction direction : Direction.values()) {
            CompoundTag counterTag = new CompoundTag();
            counterTag.putInt("side", direction.ordinal());
            counterTag.putInt("counter", this.sidedCounters.get(direction).intValue());
            counterListTag.add((Object)counterTag);
        }
        tag.put("sideCounters", (Tag)counterListTag);
        ListTag durationListTag = new ListTag();
        for (Direction direction : Direction.values()) {
            CompoundTag durationTag = new CompoundTag();
            durationTag.putInt("side", direction.ordinal());
            durationTag.putInt("duration", this.sidedDurations.get(direction).intValue());
            durationListTag.add((Object)durationTag);
        }
        tag.put("sideDurations", (Tag)durationListTag);
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        int direction;
        CompoundTag sideCounterTag;
        int i;
        ListTag listNBT;
        if (tag.contains("sideCounters")) {
            listNBT = tag.getList("sideCounters", 10);
            for (i = 0; i < listNBT.size(); ++i) {
                sideCounterTag = listNBT.getCompound(i);
                direction = sideCounterTag.getInt("side");
                int counter = sideCounterTag.getInt("counter");
                this.updateSideCounter(Direction.values()[direction], counter);
            }
        }
        if (tag.contains("sideDurations")) {
            listNBT = tag.getList("sideDurations", 10);
            for (i = 0; i < listNBT.size(); ++i) {
                sideCounterTag = listNBT.getCompound(i);
                direction = sideCounterTag.getInt("side");
                int duration = sideCounterTag.getInt("duration");
                this.sidedDurations.put(Direction.values()[direction], duration);
            }
        }
        super.loadAdditional(tag, provider);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        this.loadAdditional(tag, lookupProvider);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider p_323910_) {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag, p_323910_);
        return tag;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider lookupProvider) {
        this.loadAdditional(pkt.getTag(), lookupProvider);
    }

    public void markDirtyClient() {
        this.setChanged();
        if (this.getLevel() != null) {
            BlockState state = this.getLevel().getBlockState(this.getBlockPos());
            this.getLevel().sendBlockUpdated(this.getBlockPos(), state, state, 3);
        }
    }
}

