/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.common.blockentities.basebe;

import com.direwolf20.justdirethings.common.blockentities.basebe.BaseMachineBE;
import com.direwolf20.justdirethings.common.containers.handlers.FilterBasicHandler;
import com.direwolf20.justdirethings.util.ItemStackKey;
import com.direwolf20.justdirethings.util.interfacehelpers.FilterData;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;

public interface FilterableBE {
    public FilterBasicHandler getFilterHandler();

    public FilterData getFilterData();

    default public void setFilterData(FilterData filterData) {
        FilterData existingData = this.getFilterData();
        existingData = filterData;
    }

    public BlockEntity getBlockEntity();

    default public void saveFilterSettings(CompoundTag tag) {
        tag.putBoolean("allowlist", this.getFilterData().allowlist);
        tag.putBoolean("compareNBT", this.getFilterData().compareNBT);
        tag.putInt("blockitemfilter", this.getFilterData().blockItemFilter);
    }

    default public void loadFilterSettings(CompoundTag tag) {
        this.getFilterData().allowlist = tag.getBoolean("allowlist");
        this.getFilterData().compareNBT = tag.getBoolean("compareNBT");
        this.getFilterData().blockItemFilter = tag.getInt("blockitemfilter");
    }

    default public void setFilterSettings(FilterData filterData) {
        this.getFilterData().allowlist = filterData.allowlist;
        this.getFilterData().compareNBT = filterData.compareNBT;
        this.getFilterData().blockItemFilter = filterData.blockItemFilter;
        BlockEntity blockEntity = this.getBlockEntity();
        if (blockEntity instanceof BaseMachineBE) {
            BaseMachineBE baseMachineBE = (BaseMachineBE)blockEntity;
            baseMachineBE.markDirtyClient();
        }
    }

    default public boolean isStackValidFilter(ItemStack testStack) {
        ItemStackKey key = new ItemStackKey(testStack, this.getFilterData().compareNBT);
        if (this.getFilterData().filterCache.containsKey(key)) {
            return this.getFilterData().filterCache.get(key);
        }
        FilterBasicHandler filteredItems = this.getFilterHandler();
        for (int i = 0; i < filteredItems.getSlots(); ++i) {
            ItemStack stack = filteredItems.getStackInSlot(i);
            if (stack.isEmpty() || !key.equals(new ItemStackKey(stack, this.getFilterData().compareNBT))) continue;
            this.getFilterData().filterCache.put(key, this.getFilterData().allowlist);
            return this.getFilterData().allowlist;
        }
        this.getFilterData().filterCache.put(key, !this.getFilterData().allowlist);
        return !this.getFilterData().allowlist;
    }

    default public boolean isStackValidFilter(LiquidBlock liquidBlock) {
        ItemStack testStack = new ItemStack((ItemLike)liquidBlock.fluid.getBucket());
        ItemStackKey key = new ItemStackKey(testStack, this.getFilterData().compareNBT);
        if (this.getFilterData().filterCache.containsKey(key)) {
            return this.getFilterData().filterCache.get(key);
        }
        FilterBasicHandler filteredItems = this.getFilterHandler();
        for (int i = 0; i < filteredItems.getSlots(); ++i) {
            ItemStack stack = filteredItems.getStackInSlot(i);
            if (stack.isEmpty() || !key.equals(new ItemStackKey(stack, this.getFilterData().compareNBT))) continue;
            this.getFilterData().filterCache.put(key, this.getFilterData().allowlist);
            return this.getFilterData().allowlist;
        }
        this.getFilterData().filterCache.put(key, !this.getFilterData().allowlist);
        return !this.getFilterData().allowlist;
    }
}

