/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.common.blockentities;

import com.direwolf20.justdirethings.common.blockentities.basebe.BaseMachineBE;
import com.direwolf20.justdirethings.common.blockentities.basebe.FluidContainerData;
import com.direwolf20.justdirethings.common.blockentities.basebe.FluidMachineBE;
import com.direwolf20.justdirethings.common.blockentities.basebe.PoweredMachineBE;
import com.direwolf20.justdirethings.common.blockentities.basebe.PoweredMachineContainerData;
import com.direwolf20.justdirethings.common.blockentities.basebe.RedstoneControlledBE;
import com.direwolf20.justdirethings.common.capabilities.EnergyStorageNoReceive;
import com.direwolf20.justdirethings.common.capabilities.JustDireFluidTank;
import com.direwolf20.justdirethings.common.capabilities.MachineEnergyStorage;
import com.direwolf20.justdirethings.common.fluids.basefluids.RefinedFuel;
import com.direwolf20.justdirethings.setup.Config;
import com.direwolf20.justdirethings.setup.Registration;
import com.direwolf20.justdirethings.util.interfacehelpers.RedstoneControlData;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.neoforged.neoforge.items.ItemStackHandler;

public class GeneratorFluidT1BE
extends BaseMachineBE
implements RedstoneControlledBE,
PoweredMachineBE,
FluidMachineBE {
    public RedstoneControlData redstoneControlData = new RedstoneControlData();
    public final PoweredMachineContainerData poweredMachineData;
    public final FluidContainerData fluidContainerData;
    private final Map<Direction, BlockCapabilityCache<IEnergyStorage, Direction>> energyHandlers = new HashMap<Direction, BlockCapabilityCache<IEnergyStorage, Direction>>();

    public GeneratorFluidT1BE(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
        this.MACHINE_SLOTS = 1;
        this.fluidContainerData = new FluidContainerData(this);
        this.poweredMachineData = new PoweredMachineContainerData(this);
    }

    public GeneratorFluidT1BE(BlockPos pPos, BlockState pBlockState) {
        this((BlockEntityType)Registration.GeneratorFluidT1BE.get(), pPos, pBlockState);
    }

    @Override
    public int getMaxMB() {
        return 4000;
    }

    @Override
    public JustDireFluidTank getFluidTank() {
        return (JustDireFluidTank)((Object)this.getData(Registration.GENERATOR_FLUID_HANDLER));
    }

    @Override
    public ContainerData getFluidContainerData() {
        return this.fluidContainerData;
    }

    @Override
    public RedstoneControlData getRedstoneControlData() {
        return this.redstoneControlData;
    }

    @Override
    public BlockEntity getBlockEntity() {
        return this;
    }

    @Override
    public ContainerData getContainerData() {
        return this.poweredMachineData;
    }

    @Override
    public MachineEnergyStorage getEnergyStorage() {
        return (MachineEnergyStorage)((Object)this.getData(Registration.ENERGYSTORAGE_GENERATORS));
    }

    @Override
    public int getStandardEnergyCost() {
        return 0;
    }

    @Override
    public void tickClient() {
    }

    @Override
    public void tickServer() {
        super.tickServer();
        this.handleItemStack();
        this.doGenerate();
        this.providePowerAdjacent();
    }

    public ItemStack getItemStack() {
        return this.getMachineHandler().getStackInSlot(0);
    }

    @Override
    public ItemStackHandler getMachineHandler() {
        return (ItemStackHandler)this.getData(Registration.GENERATOR_FLUID_ITEM_HANDLER);
    }

    public boolean isStackValid(ItemStack itemStack) {
        if (itemStack.isEmpty()) {
            return false;
        }
        IFluidHandlerItem fluidHandlerItem = (IFluidHandlerItem)itemStack.getCapability(Capabilities.FluidHandler.ITEM);
        if (fluidHandlerItem == null) {
            return false;
        }
        FluidStack fluidStack = fluidHandlerItem.drain(1000, IFluidHandler.FluidAction.SIMULATE);
        if (fluidStack.getAmount() == 0) {
            return false;
        }
        if (!this.getFluidStack().isEmpty() && !this.getFluidStack().is(fluidStack.getFluid())) {
            return false;
        }
        return this.getFluidTank().isFluidValid(fluidStack);
    }

    public void handleItemStack() {
        if (this.isFull()) {
            return;
        }
        ItemStack itemStack = this.getItemStack();
        if (!this.isStackValid(itemStack)) {
            return;
        }
        IFluidHandlerItem fluidHandlerItem = (IFluidHandlerItem)itemStack.getCapability(Capabilities.FluidHandler.ITEM);
        FluidStack testExtract = fluidHandlerItem.drain(1000, IFluidHandler.FluidAction.SIMULATE);
        int insertAmt = this.getFluidTank().fill(testExtract, IFluidHandler.FluidAction.SIMULATE);
        if (insertAmt > 0) {
            FluidStack extractedStack = fluidHandlerItem.drain(insertAmt, IFluidHandler.FluidAction.EXECUTE);
            this.getFluidTank().fill(extractedStack, IFluidHandler.FluidAction.EXECUTE);
            if (itemStack.getItem() instanceof BucketItem) {
                this.getMachineHandler().setStackInSlot(0, fluidHandlerItem.getContainer());
            }
        }
    }

    @Override
    public int insertEnergy(int power, boolean simulate) {
        MachineEnergyStorage energyStorage = this.getEnergyStorage();
        if (energyStorage instanceof EnergyStorageNoReceive) {
            EnergyStorageNoReceive energyStorageNoReceive = (EnergyStorageNoReceive)energyStorage;
            return energyStorageNoReceive.forceReceiveEnergy(power, simulate);
        }
        return 0;
    }

    public IEnergyStorage getHandler(Direction direction) {
        BlockCapabilityCache tempStorage = this.energyHandlers.get(direction);
        if (tempStorage == null) {
            BlockPos targetPos = this.getBlockPos().relative(direction);
            tempStorage = BlockCapabilityCache.create((BlockCapability)Capabilities.EnergyStorage.BLOCK, (ServerLevel)((ServerLevel)this.level), (BlockPos)targetPos, (Object)direction.getOpposite());
            this.energyHandlers.put(direction, (BlockCapabilityCache<IEnergyStorage, Direction>)tempStorage);
        }
        return (IEnergyStorage)tempStorage.getCapability();
    }

    public void providePowerAdjacent() {
        if (this.getEnergyStorage().getEnergyStored() <= 0) {
            return;
        }
        for (Direction direction : Direction.values()) {
            int amtFit;
            IEnergyStorage iEnergyStorage = this.getHandler(direction);
            if (iEnergyStorage == null || (amtFit = iEnergyStorage.receiveEnergy(this.getFEOutputPerTick(), true)) <= 0) continue;
            int extractAmt = this.extractEnergy(amtFit, false);
            iEnergyStorage.receiveEnergy(extractAmt, false);
        }
    }

    public void doGenerate() {
        boolean canInsertEnergy;
        if (!this.isActiveRedstone() || this.getFluidStack().isEmpty()) {
            return;
        }
        int fePerFuelTick = this.getFePerFuelTick();
        boolean bl = canInsertEnergy = this.insertEnergy(fePerFuelTick, true) == fePerFuelTick;
        if (fePerFuelTick == 0 || !canInsertEnergy) {
            return;
        }
        FluidStack extractedStack = this.getFluidTank().drain(1, IFluidHandler.FluidAction.EXECUTE);
        if (extractedStack.getAmount() == 0) {
            return;
        }
        this.insertEnergy(fePerFuelTick, false);
        this.setChanged();
    }

    @Override
    public void handleTicks() {
    }

    @Override
    public boolean canRun() {
        return true;
    }

    @Override
    public int getMaxEnergy() {
        return (Integer)Config.GENERATOR_FLUID_T1_MAX_FE.get();
    }

    public int getFEOutputPerTick() {
        return (Integer)Config.GENERATOR_FLUID_T1_FE_PER_TICK.get();
    }

    public int getFePerFuelTick() {
        int n;
        Fluid fluid = this.getFluidTank().getFluid().getFluid();
        if (fluid instanceof RefinedFuel) {
            RefinedFuel refinedFuel = (RefinedFuel)fluid;
            n = refinedFuel.fePerMb();
        } else {
            n = 0;
        }
        return n;
    }
}

