/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.common.blockentities;

import com.direwolf20.justdirethings.common.blockentities.DropperT1BE;
import com.direwolf20.justdirethings.common.blockentities.basebe.AreaAffectingBE;
import com.direwolf20.justdirethings.common.blockentities.basebe.FilterableBE;
import com.direwolf20.justdirethings.common.blockentities.basebe.PoweredMachineBE;
import com.direwolf20.justdirethings.common.blockentities.basebe.PoweredMachineContainerData;
import com.direwolf20.justdirethings.common.capabilities.MachineEnergyStorage;
import com.direwolf20.justdirethings.common.containers.handlers.FilterBasicHandler;
import com.direwolf20.justdirethings.setup.Registration;
import com.direwolf20.justdirethings.util.ItemStackKey;
import com.direwolf20.justdirethings.util.interfacehelpers.AreaAffectingData;
import com.direwolf20.justdirethings.util.interfacehelpers.FilterData;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class DropperT2BE
extends DropperT1BE
implements AreaAffectingBE,
PoweredMachineBE,
FilterableBE {
    public FilterData filterData = new FilterData();
    public AreaAffectingData areaAffectingData = new AreaAffectingData();
    public final PoweredMachineContainerData poweredMachineData;
    public List<ItemStack> filteredList;

    public DropperT2BE(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
        this.MACHINE_SLOTS = 9;
        this.poweredMachineData = new PoweredMachineContainerData(this);
    }

    public DropperT2BE(BlockPos pPos, BlockState pBlockState) {
        this((BlockEntityType)Registration.DropperT2BE.get(), pPos, pBlockState);
    }

    @Override
    public PoweredMachineContainerData getContainerData() {
        return this.poweredMachineData;
    }

    @Override
    public MachineEnergyStorage getEnergyStorage() {
        return (MachineEnergyStorage)((Object)this.getData(Registration.ENERGYSTORAGE_MACHINES));
    }

    @Override
    public int getStandardEnergyCost() {
        return 25;
    }

    @Override
    public AreaAffectingData getAreaAffectingData() {
        return this.areaAffectingData;
    }

    @Override
    public FilterBasicHandler getFilterHandler() {
        return (FilterBasicHandler)((Object)this.getData(Registration.HANDLER_BASIC_FILTER));
    }

    @Override
    public FilterData getFilterData() {
        return this.filterData;
    }

    public List<ItemStack> getFilteredList() {
        if (this.filteredList == null) {
            this.filteredList = new ArrayList<ItemStack>();
            for (int slot = 0; slot < this.getFilterHandler().getSlots(); ++slot) {
                ItemStack itemStack = this.getFilterHandler().getStackInSlot(slot);
                if (itemStack.isEmpty()) continue;
                this.filteredList.add(itemStack);
            }
        }
        return this.filteredList;
    }

    public void populateFilteredDropSlots() {
        for (ItemStack filterStack : this.getFilteredList()) {
            ItemStackKey filterKey = new ItemStackKey(filterStack, this.getFilterData().compareNBT);
            boolean foundThisOne = false;
            for (int machineSlot = 0; machineSlot < this.getMachineHandler().getSlots(); ++machineSlot) {
                ItemStack itemStack = this.getMachineHandler().getStackInSlot(machineSlot);
                if (itemStack.isEmpty() || !filterKey.equals(new ItemStackKey(itemStack, this.getFilterData().compareNBT))) continue;
                foundThisOne = true;
                this.slotsToDropList.add(machineSlot);
                break;
            }
            if (foundThisOne) continue;
            this.slotsToDropList.clear();
            return;
        }
    }

    @Override
    public void populateDropSlots() {
        if (!this.getFilteredList().isEmpty()) {
            this.populateFilteredDropSlots();
            return;
        }
        super.populateDropSlots();
    }

    @Override
    public boolean canDrop() {
        int cost = this.getStandardEnergyCost();
        return this.hasEnoughPower(cost);
    }

    @Override
    public BlockPos getDropPos() {
        BlockPos blockPos = this.getBlockPos().offset(this.getAreaAffectingData().xOffset, this.getAreaAffectingData().yOffset, this.getAreaAffectingData().zOffset);
        if (this.isBlockPosValid(blockPos)) {
            return blockPos;
        }
        return null;
    }

    @Override
    public void spawnItem(Level level, ItemStack stack, double speed, Direction direction, Vec3 position) {
        super.spawnItem(level, stack, speed, direction, position);
        this.extractEnergy(this.getStandardEnergyCost(), false);
    }

    @Override
    public void setChanged() {
        super.setChanged();
        this.filteredList = null;
    }
}

