/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.client.screens.standardbuttons;

import com.direwolf20.justdirethings.client.screens.widgets.GrayscaleButton;
import com.direwolf20.justdirethings.client.screens.widgets.NumberButton;
import com.direwolf20.justdirethings.client.screens.widgets.ToggleButton;
import com.direwolf20.justdirethings.common.items.interfaces.Ability;
import com.direwolf20.justdirethings.setup.Config;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class ToggleButtonFactory {
    private static final int STANDARD_WIDTH = 16;
    private static final int STANDARD_HEIGHT = 16;
    private static final Map<Ability, List<TextureLocalization>> abilityTextureMap = new HashMap<Ability, List<TextureLocalization>>(){
        {
            this.put(Ability.HAMMER, HAMMER_TEXTURES);
        }
    };
    private static final List<TextureLocalization> REDSTONE_TEXTURES = List.of(new TextureLocalization(ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/buttons/redstoneignore.png"), Component.translatable((String)"justdirethings.screen.ignored")), new TextureLocalization(ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/buttons/redstonelow.png"), Component.translatable((String)"justdirethings.screen.low")), new TextureLocalization(ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/buttons/redstonehigh.png"), Component.translatable((String)"justdirethings.screen.high")), new TextureLocalization(ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/buttons/redstonepulse.png"), Component.translatable((String)"justdirethings.screen.pulse")));
    private static final List<TextureLocalization> ALLOW_LIST_TEXTURES = List.of(new TextureLocalization(ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/buttons/allowlistfalse.png"), Component.translatable((String)"justdirethings.screen.denylist")), new TextureLocalization(ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/buttons/allowlisttrue.png"), Component.translatable((String)"justdirethings.screen.allowlist")));
    private static final ResourceLocation COMPARE_NBT = ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/buttons/matchnbttrue.png");
    private static final Component COMPARE_NBT_LOCALIZATION = Component.translatable((String)"justdirethings.screen.comparenbt");
    private static final ResourceLocation RENDER_AREA = ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/buttons/area.png");
    private static final Component RENDER_AREA_LOCALIZATION = Component.translatable((String)"justdirethings.screen.renderarea");
    private static final List<TextureLocalization> DIRECTION_TEXTURES = List.of(new TextureLocalization(ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/buttons/direction-down.png"), Component.translatable((String)"justdirethings.screen.direction-down")), new TextureLocalization(ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/buttons/direction-up.png"), Component.translatable((String)"justdirethings.screen.direction-up")), new TextureLocalization(ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/buttons/direction-north.png"), Component.translatable((String)"justdirethings.screen.direction-north")), new TextureLocalization(ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/buttons/direction-south.png"), Component.translatable((String)"justdirethings.screen.direction-south")), new TextureLocalization(ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/buttons/direction-west.png"), Component.translatable((String)"justdirethings.screen.direction-west")), new TextureLocalization(ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/buttons/direction-east.png"), Component.translatable((String)"justdirethings.screen.direction-east")));
    private static final List<TextureLocalization> DIRECTION_NONE_TEXTURES = List.of(new TextureLocalization(ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/buttons/direction-none.png"), Component.translatable((String)"justdirethings.screen.direction-none")), new TextureLocalization(ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/buttons/direction-down.png"), Component.translatable((String)"justdirethings.screen.direction-down")), new TextureLocalization(ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/buttons/direction-up.png"), Component.translatable((String)"justdirethings.screen.direction-up")), new TextureLocalization(ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/buttons/direction-north.png"), Component.translatable((String)"justdirethings.screen.direction-north")), new TextureLocalization(ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/buttons/direction-south.png"), Component.translatable((String)"justdirethings.screen.direction-south")), new TextureLocalization(ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/buttons/direction-west.png"), Component.translatable((String)"justdirethings.screen.direction-west")), new TextureLocalization(ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/buttons/direction-east.png"), Component.translatable((String)"justdirethings.screen.direction-east")));
    private static final List<TextureLocalization> FILTERBLOCKITEM_TEXTURES = List.of(new TextureLocalization(ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/buttons/filter-block.png"), Component.translatable((String)"justdirethings.screen.filter-block")), new TextureLocalization(ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/buttons/filter-item.png"), Component.translatable((String)"justdirethings.screen.filter-item")));
    private static final List<TextureLocalization> HAMMER_TEXTURES = List.of(new TextureLocalization(ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/buttons/ignore.png"), Component.translatable((String)"justdirethings.ability.hammer_off")), new TextureLocalization(ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/buttons/hammer3.png"), Component.translatable((String)"justdirethings.ability.hammer_3")), new TextureLocalization(ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/buttons/hammer5.png"), Component.translatable((String)"justdirethings.ability.hammer_5")), new TextureLocalization(ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/buttons/hammer7.png"), Component.translatable((String)"justdirethings.ability.hammer_7")));
    private static Component ticksButtonLocalization = Component.translatable((String)"justdirethings.screen.tickspeed");
    private static final List<TextureLocalization> LEFT_RIGHT_CLICK_TEXTURES = List.of(new TextureLocalization(ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/buttons/click-right.png"), Component.translatable((String)"justdirethings.screen.click-right")), new TextureLocalization(ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/buttons/click-left.png"), Component.translatable((String)"justdirethings.screen.click-left")), new TextureLocalization(ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/buttons/click-hold.png"), Component.translatable((String)"justdirethings.screen.click-hold")));
    private static final List<TextureLocalization> CLICK_TARGET_TEXTURES = List.of(new TextureLocalization(ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/buttons/filter-block.png"), Component.translatable((String)"justdirethings.screen.target-block")), new TextureLocalization(ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/buttons/filter-air.png"), Component.translatable((String)"justdirethings.screen.target-air")), new TextureLocalization(ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/buttons/mobscanner.png"), Component.translatable((String)"justdirethings.screen.target-hostile")), new TextureLocalization(ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/buttons/passivemob.png"), Component.translatable((String)"justdirethings.screen.target-passive")), new TextureLocalization(ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/buttons/passivemob-adult.png"), Component.translatable((String)"justdirethings.screen.target-adult")), new TextureLocalization(ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/buttons/passivemob-child.png"), Component.translatable((String)"justdirethings.screen.target-child")), new TextureLocalization(ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/buttons/player.png"), Component.translatable((String)"justdirethings.screen.target-player")), new TextureLocalization(ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/buttons/glowing.png"), Component.translatable((String)"justdirethings.screen.target-living")));
    private static final ResourceLocation SNEAK_BUTTON = ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/buttons/click-sneak.png");
    private static final Component SNEAK_LOCALIZATION = Component.translatable((String)"justdirethings.screen.sneak-click");
    private static final ResourceLocation SHOWFAKEPLAYER_BUTTON = ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/buttons/showfakeplayer.png");
    private static final Component SHOWFAKEPLAYER_LOCALIZATION = Component.translatable((String)"justdirethings.screen.showfakeplayer");
    private static final List<TextureLocalization> SENSOR_TARGET_TEXTURES = List.of(new TextureLocalization(ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/buttons/filter-block.png"), Component.translatable((String)"justdirethings.screen.target-block")), new TextureLocalization(ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/buttons/filter-air.png"), Component.translatable((String)"justdirethings.screen.target-air")), new TextureLocalization(ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/buttons/mobscanner.png"), Component.translatable((String)"justdirethings.screen.target-hostile")), new TextureLocalization(ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/buttons/passivemob.png"), Component.translatable((String)"justdirethings.screen.target-passive")), new TextureLocalization(ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/buttons/passivemob-adult.png"), Component.translatable((String)"justdirethings.screen.target-adult")), new TextureLocalization(ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/buttons/passivemob-child.png"), Component.translatable((String)"justdirethings.screen.target-child")), new TextureLocalization(ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/buttons/player.png"), Component.translatable((String)"justdirethings.screen.target-player")), new TextureLocalization(ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/buttons/glowing.png"), Component.translatable((String)"justdirethings.screen.target-living")), new TextureLocalization(ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/buttons/item.png"), Component.translatable((String)"justdirethings.screen.target-item")));
    private static final List<TextureLocalization> STRONG_WEAK_REDSTONE_TEXTURES = List.of(new TextureLocalization(ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/buttons/redstonelow.png"), Component.translatable((String)"justdirethings.screen.redstone-weak")), new TextureLocalization(ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/buttons/redstonehigh.png"), Component.translatable((String)"justdirethings.screen.redstone-strong")));
    private static final List<TextureLocalization> EQUALITY_TEXTURES = List.of(new TextureLocalization(ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/buttons/greaterthan.png"), Component.translatable((String)"justdirethings.screen.greaterthan")), new TextureLocalization(ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/buttons/lessthan.png"), Component.translatable((String)"justdirethings.screen.lessthan")), new TextureLocalization(ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/buttons/equals.png"), Component.translatable((String)"justdirethings.screen.equals")));
    private static final ResourceLocation SHOW_PARTICLES_BUTTON = ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/buttons/showfakeplayer.png");
    private static final Component SHOW_PARTICLES_LOCALIZATION = Component.translatable((String)"justdirethings.screen.showparticles");
    private static final List<TextureLocalization> SWAPPER_ENTITY_TEXTURES = List.of(new TextureLocalization(ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/buttons/entity-none.png"), Component.translatable((String)"justdirethings.screen.entity-none")), new TextureLocalization(ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/buttons/mobscanner.png"), Component.translatable((String)"justdirethings.screen.target-hostile")), new TextureLocalization(ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/buttons/passivemob.png"), Component.translatable((String)"justdirethings.screen.target-passive")), new TextureLocalization(ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/buttons/passivemob-adult.png"), Component.translatable((String)"justdirethings.screen.target-adult")), new TextureLocalization(ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/buttons/passivemob-child.png"), Component.translatable((String)"justdirethings.screen.target-child")), new TextureLocalization(ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/buttons/player.png"), Component.translatable((String)"justdirethings.screen.target-player")), new TextureLocalization(ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/buttons/glowing.png"), Component.translatable((String)"justdirethings.screen.target-living")), new TextureLocalization(ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/buttons/item.png"), Component.translatable((String)"justdirethings.screen.target-item")), new TextureLocalization(ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/buttons/entity-all.png"), Component.translatable((String)"justdirethings.screen.entity-all")));
    private static final List<TextureLocalization> SWAPPER_BLOCK_TEXTURES = List.of(new TextureLocalization(ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/buttons/filter-block.png"), Component.translatable((String)"justdirethings.screen.target-block")), new TextureLocalization(ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/buttons/filter-air.png"), Component.translatable((String)"justdirethings.screen.target-noblock")));
    private static final List<TextureLocalization> INVENTORY_CONNECTION_TEXTURES = List.of(new TextureLocalization(ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/buttons/inv-normal.png"), Component.translatable((String)"justdirethings.screen.inv-normal")), new TextureLocalization(ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/buttons/inv-armor.png"), Component.translatable((String)"justdirethings.screen.inv-armor")), new TextureLocalization(ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/buttons/inv-offhand.png"), Component.translatable((String)"justdirethings.screen.inv-offhand")));
    private static final List<TextureLocalization> LEFT_RIGHT_ONLY_CLICK_TEXTURES = List.of(new TextureLocalization(ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/buttons/click-right.png"), Component.translatable((String)"justdirethings.screen.click-right")), new TextureLocalization(ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/buttons/click-left.png"), Component.translatable((String)"justdirethings.screen.click-left")), new TextureLocalization(ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/buttons/click-sneak.png"), Component.translatable((String)"justdirethings.screen.click-custom")));
    private static final List<TextureLocalization> CUSTOM_ONLY_CLICK_TEXTURES = List.of(new TextureLocalization(ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/buttons/click-sneak.png"), Component.translatable((String)"justdirethings.screen.click-custom")));
    private static final ResourceLocation BIND_BUTTON = ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/buttons/click-hold.png");
    private static final Component BIND_LOCALIZATION = Component.translatable((String)"justdirethings.screen.setbinding");
    private static final ResourceLocation HIDE_RENDER_BUTTON = ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/buttons/showfakeplayer.png");
    private static final Component HIDE_RENDER_LOCALIZATION = Component.translatable((String)"justdirethings.screen.showrender");
    private static final ResourceLocation COPY_AREA_BUTTON = ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/buttons/area.png");
    private static final Component COPY_AREA_LOCALIZATION = Component.translatable((String)"justdirethings.screen.copy_area");
    private static final ResourceLocation COPY_OFFSET_BUTTON = ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/buttons/stepheight.png");
    private static final Component COPY_OFFSET_LOCALIZATION = Component.translatable((String)"justdirethings.screen.copy_offset");
    private static final ResourceLocation COPY_FILTER_BUTTON = ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/buttons/matchnbttrue.png");
    private static final Component COPY_FILTER_LOCALIZATION = Component.translatable((String)"justdirethings.screen.copy_filter");
    private static final ResourceLocation COPY_REDSTONE_BUTTON = ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/buttons/redstonepulse.png");
    private static final Component COPY_REDSTONE_LOCALIZATION = Component.translatable((String)"justdirethings.screen.copy_redstone");

    public static ToggleButton REDSTONEBUTTON(int x, int y, int startingValue, Button.OnPress onPress) {
        return new ToggleButton(x, y, 16, 16, REDSTONE_TEXTURES, startingValue, onPress);
    }

    public static ToggleButton ALLOWLISTBUTTON(int x, int y, boolean startingValue, Button.OnPress onPress) {
        return new ToggleButton(x, y, 16, 16, ALLOW_LIST_TEXTURES, startingValue, onPress);
    }

    public static GrayscaleButton COMPARENBTBUTTON(int x, int y, boolean startingValue, Button.OnPress onPress) {
        return new GrayscaleButton(x, y, 16, 16, COMPARE_NBT, COMPARE_NBT_LOCALIZATION, startingValue, onPress);
    }

    public static GrayscaleButton RENDERAREABUTTON(int x, int y, boolean startingValue, Button.OnPress onPress) {
        return new GrayscaleButton(x, y, 16, 16, RENDER_AREA, RENDER_AREA_LOCALIZATION, startingValue, onPress);
    }

    public static ToggleButton DIRECTIONBUTTON(int x, int y, int startingValue, Button.OnPress onPress) {
        return new ToggleButton(x, y, 16, 16, DIRECTION_TEXTURES, startingValue, onPress);
    }

    public static ToggleButton DIRECTIONNONEBUTTON(int x, int y, int startingValue, Button.OnPress onPress) {
        return new ToggleButton(x, y, 16, 16, DIRECTION_NONE_TEXTURES, startingValue, onPress);
    }

    public static ToggleButton FILTERBLOCKITEMBUTTON(int x, int y, int startingValue, Button.OnPress onPress) {
        return new ToggleButton(x, y, 16, 16, FILTERBLOCKITEM_TEXTURES, startingValue, onPress);
    }

    public static ToggleButton ABILITYCYCLEBUTTON(int x, int y, Ability ability, int startingValue, int maxValue, Button.OnPress onPress) {
        return new ToggleButton(x, y, 16, 16, HAMMER_TEXTURES, startingValue, maxValue, onPress);
    }

    public static NumberButton TICKSPEEDBUTTON(int x, int y, int value, Button.OnPress onPress) {
        return new NumberButton(x, y, 24, 12, value, (Integer)Config.MINIMUM_MACHINE_TICK_SPEED.get(), 1200, ticksButtonLocalization, onPress);
    }

    public static NumberButton TICKSPEEDBUTTON(int x, int y, int value, int min, Button.OnPress onPress) {
        return new NumberButton(x, y, 24, 12, value, min, 1200, ticksButtonLocalization, onPress);
    }

    public static ToggleButton LEFTRIGHTCLICKBUTTON(int x, int y, int startingValue, Button.OnPress onPress) {
        return new ToggleButton(x, y, 16, 16, LEFT_RIGHT_CLICK_TEXTURES, startingValue, onPress);
    }

    public static ToggleButton CLICKTARGETBUTTON(int x, int y, int startingValue, Button.OnPress onPress) {
        return new ToggleButton(x, y, 16, 16, CLICK_TARGET_TEXTURES, startingValue, onPress);
    }

    public static GrayscaleButton SNEAKCLICKBUTTON(int x, int y, boolean startingValue, Button.OnPress onPress) {
        return new GrayscaleButton(x, y, 16, 16, SNEAK_BUTTON, SNEAK_LOCALIZATION, startingValue, onPress);
    }

    public static GrayscaleButton SHOWFAKEPLAYERBUTTON(int x, int y, boolean startingValue, Button.OnPress onPress) {
        return new GrayscaleButton(x, y, 16, 16, SHOWFAKEPLAYER_BUTTON, SHOWFAKEPLAYER_LOCALIZATION, startingValue, onPress);
    }

    public static ToggleButton SENSORTARGETBUTTON(int x, int y, int startingValue, Button.OnPress onPress) {
        return new ToggleButton(x, y, 16, 16, SENSOR_TARGET_TEXTURES, startingValue, onPress);
    }

    public static ToggleButton STRONGWEAKREDSTONEBUTTON(int x, int y, int startingValue, Button.OnPress onPress) {
        return new ToggleButton(x, y, 16, 16, STRONG_WEAK_REDSTONE_TEXTURES, startingValue, onPress);
    }

    public static ToggleButton EQUALSBUTTON(int x, int y, int startingValue, Button.OnPress onPress) {
        return new ToggleButton(x, y, 16, 16, EQUALITY_TEXTURES, startingValue, onPress);
    }

    public static GrayscaleButton SHOWPARTICLESBUTTON(int x, int y, boolean startingValue, Button.OnPress onPress) {
        return new GrayscaleButton(x, y, 16, 16, SHOW_PARTICLES_BUTTON, SHOW_PARTICLES_LOCALIZATION, startingValue, onPress);
    }

    public static ToggleButton SWAPPERENTITYBUTTON(int x, int y, int startingValue, Button.OnPress onPress) {
        return new ToggleButton(x, y, 16, 16, SWAPPER_ENTITY_TEXTURES, startingValue, onPress);
    }

    public static ToggleButton SWAPPERBLOCKBUTTON(int x, int y, int startingValue, Button.OnPress onPress) {
        return new ToggleButton(x, y, 16, 16, SWAPPER_BLOCK_TEXTURES, startingValue, onPress);
    }

    public static ToggleButton INVENTORYCONNECTIONBUTTON(int x, int y, MutableComponent component, int startingValue, Button.OnPress onPress) {
        ArrayList<TextureLocalization> textureLocalizations = new ArrayList<TextureLocalization>();
        for (TextureLocalization textureLocalization : INVENTORY_CONNECTION_TEXTURES) {
            textureLocalizations.add(new TextureLocalization(textureLocalization.texture, Component.literal((String)"").append((Component)component).append((Component)Component.literal((String)": ")).append((Component)textureLocalization.localization)));
        }
        return new ToggleButton(x, y, 16, 16, textureLocalizations, startingValue, onPress);
    }

    public static ToggleButton LEFTRIGHTCUSTOMCLICKBUTTON(int x, int y, int startingValue, Button.OnPress onPress) {
        return new ToggleButton(x, y, 16, 16, LEFT_RIGHT_ONLY_CLICK_TEXTURES, startingValue, onPress);
    }

    public static ToggleButton CUSTOMCLICKBUTTON(int x, int y, int startingValue, Button.OnPress onPress) {
        return new ToggleButton(x, y, 16, 16, CUSTOM_ONLY_CLICK_TEXTURES, startingValue, onPress);
    }

    public static GrayscaleButton KEYBIND_BUTTON(int x, int y, boolean startingValue, Button.OnPress onPress) {
        return new GrayscaleButton(x, y, 16, 16, BIND_BUTTON, BIND_LOCALIZATION, startingValue, onPress);
    }

    public static GrayscaleButton HIDE_RENDER_ABILITY_BUTTON(int x, int y, boolean startingValue, Button.OnPress onPress) {
        return new GrayscaleButton(x, y, 16, 16, HIDE_RENDER_BUTTON, HIDE_RENDER_LOCALIZATION, startingValue, onPress);
    }

    public static GrayscaleButton COPY_AREA_BUTTON(int x, int y, boolean startingValue, Button.OnPress onPress) {
        return new GrayscaleButton(x, y, 16, 16, COPY_AREA_BUTTON, COPY_AREA_LOCALIZATION, startingValue, onPress);
    }

    public static GrayscaleButton COPY_OFFSET_BUTTON(int x, int y, boolean startingValue, Button.OnPress onPress) {
        return new GrayscaleButton(x, y, 16, 16, COPY_OFFSET_BUTTON, COPY_OFFSET_LOCALIZATION, startingValue, onPress);
    }

    public static GrayscaleButton COPY_FILTER_BUTTON(int x, int y, boolean startingValue, Button.OnPress onPress) {
        return new GrayscaleButton(x, y, 16, 16, COPY_FILTER_BUTTON, COPY_FILTER_LOCALIZATION, startingValue, onPress);
    }

    public static GrayscaleButton COPY_REDSTONE_BUTTON(int x, int y, boolean startingValue, Button.OnPress onPress) {
        return new GrayscaleButton(x, y, 16, 16, COPY_REDSTONE_BUTTON, COPY_REDSTONE_LOCALIZATION, startingValue, onPress);
    }

    public record TextureLocalization(ResourceLocation texture, MutableComponent localization) {
    }
}

