/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.client.screens;

import com.direwolf20.justdirethings.client.KeyBindings;
import com.direwolf20.justdirethings.client.OurSounds;
import com.direwolf20.justdirethings.client.renderers.OurRenderTypes;
import com.direwolf20.justdirethings.client.screens.AdvPortalEditMenu;
import com.direwolf20.justdirethings.client.screens.standardbuttons.ToggleButtonFactory;
import com.direwolf20.justdirethings.client.screens.widgets.BaseButton;
import com.direwolf20.justdirethings.client.screens.widgets.GrayscaleButton;
import com.direwolf20.justdirethings.common.items.PortalGunV2;
import com.direwolf20.justdirethings.common.network.data.PortalGunFavoriteChangePayload;
import com.direwolf20.justdirethings.common.network.data.PortalGunFavoritePayload;
import com.direwolf20.justdirethings.setup.Registration;
import com.direwolf20.justdirethings.util.NBTHelpers;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import org.joml.Matrix4f;

public class AdvPortalRadialMenu
extends Screen {
    ToggleButtonFactory.TextureLocalization ADD_BUTTON = new ToggleButtonFactory.TextureLocalization(ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/buttons/add.png"), Component.translatable((String)"justdirethings.screen.add_favorite"));
    ToggleButtonFactory.TextureLocalization REMOVE_BUTTON = new ToggleButtonFactory.TextureLocalization(ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/buttons/remove.png"), Component.translatable((String)"justdirethings.screen.remove_favorite"));
    ToggleButtonFactory.TextureLocalization EDIT_BUTTON = new ToggleButtonFactory.TextureLocalization(ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/buttons/matchnbttrue.png"), Component.translatable((String)"justdirethings.screen.edit_favorite"));
    ToggleButtonFactory.TextureLocalization STAYOPEN_BUTTON = new ToggleButtonFactory.TextureLocalization(ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/buttons/area.png"), Component.translatable((String)"justdirethings.screen.stay_open"));
    private static final int SEGMENTS = 12;
    private int timeIn = 0;
    private int slotHovered = -1;
    private int slotSelected = 0;
    private ItemStack portalGun;
    private static final int radiusMin = 26;
    private static final int radiusMax = 120;
    private boolean staysOpen = false;

    public AdvPortalRadialMenu(ItemStack stack) {
        super((Component)Component.literal((String)""));
        this.portalGun = stack;
        this.slotSelected = PortalGunV2.getFavoritePosition(this.portalGun);
        this.staysOpen = PortalGunV2.getStayOpen(this.portalGun);
    }

    private static float mouseAngle(int x, int y, int mx, int my) {
        Vector2f baseVec = new Vector2f(1.0f, 0.0f);
        Vector2f mouseVec = new Vector2f(mx - x, my - y);
        float ang = (float)(Math.acos(baseVec.dot(mouseVec) / (baseVec.length() * mouseVec.length())) * 57.29577951308232);
        return my < y ? 360.0f - ang : ang;
    }

    public void renderBackground(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
    }

    public void init() {
        GrayscaleButton addButton = new GrayscaleButton(this.width / 2 - 150, this.height / 2 - 20, 16, 16, this.ADD_BUTTON.texture(), (Component)this.ADD_BUTTON.localization(), true, clicked -> this.addFavorite());
        this.addRenderableWidget((GuiEventListener)addButton);
        GrayscaleButton removeButton = new GrayscaleButton(this.width / 2 + 140, this.height / 2 - 20, 16, 16, this.REMOVE_BUTTON.texture(), (Component)this.REMOVE_BUTTON.localization(), true, clicked -> this.removeFavorite());
        this.addRenderableWidget((GuiEventListener)removeButton);
        GrayscaleButton editButton = new GrayscaleButton(this.width / 2 - 150, this.height / 2 + 20, 16, 16, this.EDIT_BUTTON.texture(), (Component)this.EDIT_BUTTON.localization(), true, clicked -> this.editFavorite());
        this.addRenderableWidget((GuiEventListener)editButton);
        GrayscaleButton stayOpenButton = new GrayscaleButton(this.width / 2 + 140, this.height / 2 + 20, 16, 16, this.STAYOPEN_BUTTON.texture(), (Component)this.STAYOPEN_BUTTON.localization(), this.staysOpen, clicked -> {
            this.staysOpen = !this.staysOpen;
            this.saveFavorite();
            ((GrayscaleButton)clicked).toggleActive();
        });
        this.addRenderableWidget((GuiEventListener)stayOpenButton);
    }

    public void render(GuiGraphics guiGraphics, int mx, int my, float partialTicks) {
        this.renderTooltip(guiGraphics, mx, my);
        this.portalGun = PortalGunV2.getPortalGunv2((Player)Minecraft.getInstance().player);
        PoseStack matrices = guiGraphics.pose();
        float speedOfButtonGrowth = 5.0f;
        float fract = Math.min(speedOfButtonGrowth, (float)this.timeIn + partialTicks) / speedOfButtonGrowth;
        int x = this.width / 2;
        int y = this.height / 2;
        boolean inRange = this.isInRange(mx, my);
        matrices.pushPose();
        matrices.translate((1.0f - fract) * (float)x, (1.0f - fract) * (float)y, 0.0f);
        matrices.scale(fract, fract, fract);
        super.render(guiGraphics, mx, my, partialTicks);
        matrices.popPose();
        float angle = AdvPortalRadialMenu.mouseAngle(x, y, mx, my);
        float totalDeg = 0.0f;
        float degPer = 30.0f;
        for (int seg = 0; seg < 12; ++seg) {
            NBTHelpers.PortalDestination favorite = this.getFavorite(seg);
            String favoriteName = favorite != null ? favorite.name() : "Empty";
            String dimension = favorite != null && !favorite.equals(NBTHelpers.PortalDestination.EMPTY) ? favorite.globalVec3().dimension().location().getPath().toString() : "";
            String coordinates = favorite != null && !favorite.equals(NBTHelpers.PortalDestination.EMPTY) ? String.format("(%d, %d, %d)", (int)favorite.globalVec3().position().x(), (int)favorite.globalVec3().position().y(), (int)favorite.globalVec3().position().z()) : "";
            boolean mouseInSector = this.isCursorInSlice(angle, totalDeg, degPer, inRange);
            float delayBetweenSegments = 1.0f;
            float speedOfSegmentGrowth = 25.0f;
            float radius = Math.max(0.0f, Math.min(((float)this.timeIn + partialTicks - (float)seg * delayBetweenSegments / 12.0f) * speedOfSegmentGrowth, 120.0f));
            float gs = 0.25f;
            if (seg % 2 == 0) {
                gs += 0.1f;
            }
            float r = gs;
            float g = gs;
            float b = gs;
            float a = 0.4f;
            if (mouseInSector) {
                this.slotHovered = seg;
                b = 1.0f;
                g = 1.0f;
                r = 1.0f;
            }
            if (seg == this.slotSelected) {
                g = 1.0f;
                r = 1.0f;
                a = 0.6f;
            }
            MultiBufferSource.BufferSource bufferSource = Minecraft.getInstance().renderBuffers().bufferSource();
            VertexConsumer buffer = bufferSource.getBuffer(OurRenderTypes.TRIANGLE_STRIP);
            for (float i = degPer; i >= 0.0f; i -= 1.0f) {
                float rad = (float)((double)((i + totalDeg) / 180.0f) * Math.PI);
                float xp = (float)((double)x + Math.cos(rad) * (double)radius);
                float yp = (float)((double)y + Math.sin(rad) * (double)radius);
                Matrix4f pose = matrices.last().pose();
                buffer.addVertex(pose, (float)((double)x + Math.cos(rad) * (double)radius / (double)2.3f), (float)((double)y + Math.sin(rad) * (double)radius / (double)2.3f), 0.0f).setColor(r, g, b, a);
                buffer.addVertex(xp, yp, 0.0f).setColor(r, g, b, a);
            }
            bufferSource.endBatch(OurRenderTypes.TRIANGLE_STRIP);
            float nameAngle = ((totalDeg += degPer) - degPer / 2.0f) * (float)Math.PI / 180.0f;
            float nameX = (float)x + (float)(Math.cos(nameAngle) * 85.71428571428572);
            float nameY = (float)y + (float)(Math.sin(nameAngle) * 85.71428571428572);
            int textWidth = this.font.width(favoriteName);
            int dimensionWidth = this.font.width(dimension);
            int coordinatesWidth = this.font.width(coordinates);
            matrices.pushPose();
            matrices.translate(nameX, nameY, 0.0f);
            matrices.scale(0.85f, 0.85f, 0.85f);
            if ((double)nameAngle > 1.5707963267948966 && (double)nameAngle < 4.71238898038469) {
                matrices.mulPose(Axis.ZP.rotation(nameAngle + (float)Math.PI));
            } else {
                matrices.mulPose(Axis.ZP.rotation(nameAngle));
            }
            guiGraphics.drawString(this.font, favoriteName, -textWidth / 2, -15, Color.WHITE.getRGB());
            matrices.popPose();
            matrices.pushPose();
            matrices.translate(nameX, nameY, 0.0f);
            matrices.scale(0.7f, 0.7f, 0.7f);
            if ((double)nameAngle > 1.5707963267948966 && (double)nameAngle < 4.71238898038469) {
                matrices.mulPose(Axis.ZP.rotation(nameAngle + (float)Math.PI));
            } else {
                matrices.mulPose(Axis.ZP.rotation(nameAngle));
            }
            guiGraphics.drawString(this.font, dimension, -dimensionWidth / 2, -5, Color.LIGHT_GRAY.getRGB());
            guiGraphics.drawString(this.font, coordinates, -coordinatesWidth / 2, 10, Color.LIGHT_GRAY.getRGB());
            matrices.popPose();
        }
    }

    private boolean isCursorInSlice(float angle, float totalDeg, float degPer, boolean inRange) {
        return inRange && angle > totalDeg && angle < totalDeg + degPer;
    }

    public boolean isInRange(double mouseX, double mouseY) {
        int x = this.width / 2;
        int y = this.height / 2;
        double dist = new Vec3((double)x, (double)y, 0.0).distanceTo(new Vec3(mouseX, mouseY, 0.0));
        return dist > 26.0 && dist < 120.0;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (this.isInRange(mouseX, mouseY)) {
            this.saveFavorite();
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public boolean keyPressed(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (this.staysOpen && (p_keyPressed_1_ == 256 || p_keyPressed_1_ == KeyBindings.toggleTool.getKey().getValue())) {
            this.onClose();
            return true;
        }
        return super.keyPressed(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
    }

    public void tick() {
        if (!this.staysOpen && !InputConstants.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)KeyBindings.toggleTool.getKey().getValue())) {
            this.onClose();
        }
        ++this.timeIn;
    }

    protected void renderTooltip(GuiGraphics pGuiGraphics, int pX, int pY) {
        for (Renderable renderable : this.renderables) {
            BaseButton button;
            if (!(renderable instanceof BaseButton) || (button = (BaseButton)renderable).getLocalization(pX, pY).equals((Object)Component.empty())) continue;
            pGuiGraphics.renderTooltip(this.font, button.getLocalization(), pX, pY);
        }
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void saveFavorite() {
        this.slotSelected = this.slotHovered;
        PacketDistributor.sendToServer((CustomPacketPayload)new PortalGunFavoritePayload(this.slotSelected, this.staysOpen), (CustomPacketPayload[])new CustomPacketPayload[0]);
        OurSounds.playSound(Registration.BEEP.get());
    }

    public void addFavorite() {
        PacketDistributor.sendToServer((CustomPacketPayload)new PortalGunFavoriteChangePayload(this.slotSelected, true, "UNNAMED", false, Vec3.ZERO), (CustomPacketPayload[])new CustomPacketPayload[0]);
        OurSounds.playSound(Registration.BEEP.get());
    }

    public void removeFavorite() {
        PacketDistributor.sendToServer((CustomPacketPayload)new PortalGunFavoriteChangePayload(this.slotSelected, false, "NOTNEEDED", false, Vec3.ZERO), (CustomPacketPayload[])new CustomPacketPayload[0]);
        OurSounds.playSound(Registration.BEEP.get());
    }

    public void editFavorite() {
        Minecraft.getInstance().setScreen((Screen)new AdvPortalEditMenu(this.portalGun, this.slotSelected));
        OurSounds.playSound(Registration.BEEP.get());
    }

    public NBTHelpers.PortalDestination getFavorite(int slot) {
        return PortalGunV2.getFavorite(this.portalGun, slot);
    }

    private static class Vector2f {
        public float x;
        public float y;

        public Vector2f(float x, float y) {
            this.x = x;
            this.y = y;
        }

        public final float dot(Vector2f v1) {
            return this.x * v1.x + this.y * v1.y;
        }

        public final float length() {
            return (float)Math.sqrt(this.x * this.x + this.y * this.y);
        }
    }
}

