/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.client.particles.itemparticle;

import com.direwolf20.justdirethings.client.particles.itemparticle.ItemFlowParticleData;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.BreakingItemParticle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;

public class ItemFlowParticle
extends BreakingItemParticle {
    private double targetX;
    private double targetY;
    private double targetZ;
    Random random = new Random();
    public static ParticleProvider<ItemFlowParticleData> FACTORY = (data, world, x, y, z, xSpeed, ySpeed, zSpeed) -> new ItemFlowParticle(world, x, y, z, data.targetX, data.targetY, data.targetZ, data.getItemStack(), data.ticksPerBlock);

    public ItemFlowParticle(ClientLevel world, double x, double y, double z, double targetX, double targetY, double targetZ, ItemStack itemStack, int ticksPerBlock) {
        this(world, x, y, z, itemStack);
        this.xd = 0.0;
        this.yd = 0.0;
        this.zd = 0.0;
        this.targetX = targetX;
        this.targetY = targetY;
        this.targetZ = targetZ;
        Vec3 target = new Vec3(targetX, targetY, targetZ);
        Vec3 source = new Vec3(this.x, this.y, this.z);
        Vec3 path = target.subtract(source).normalize().multiply(1.0, 1.0, 1.0);
        this.gravity = 0.0f;
        double distance = target.distanceTo(source);
        this.hasPhysics = false;
        float minSize = 0.1f;
        float maxSize = 0.2f;
        float partSize = minSize + this.random.nextFloat() * (maxSize - minSize);
        float speedModifier = 0.5f * (partSize - minSize) / (maxSize - minSize) + 0.25f;
        float speedAdjust = (float)ticksPerBlock * (1.0f / speedModifier);
        this.xd += path.x / (double)speedAdjust;
        this.yd += path.y / (double)speedAdjust;
        this.zd += path.z / (double)speedAdjust;
        this.lifetime = (int)(distance * (double)speedAdjust);
        this.scale(partSize);
        if (this.sprite == null) {
            this.setSprite(Minecraft.getInstance().getItemRenderer().getModel(new ItemStack((ItemLike)Blocks.COBBLESTONE), (Level)world, (LivingEntity)null, 0).getParticleIcon());
        }
    }

    public ItemFlowParticle(ClientLevel world, double x, double y, double z, ItemStack itemStack) {
        super(world, x, y, z, itemStack);
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        } else {
            this.yd -= 0.04 * (double)this.gravity;
            this.move(this.xd, this.yd, this.zd);
        }
    }
}

