/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.client.overlays;

import com.direwolf20.justdirethings.common.items.datacomponents.JustDireDataComponents;
import com.direwolf20.justdirethings.common.items.interfaces.Ability;
import com.direwolf20.justdirethings.common.items.interfaces.ToggleableTool;
import com.direwolf20.justdirethings.common.items.interfaces.ToolRecords;
import com.direwolf20.justdirethings.setup.Config;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class AbilityCooldownOverlay
implements LayeredDraw.Layer {
    public static final AbilityCooldownOverlay INSTANCE = new AbilityCooldownOverlay();
    private static final EquipmentSlot[] EQUIPMENT_ORDER = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET, EquipmentSlot.MAINHAND, EquipmentSlot.OFFHAND};

    public void render(@NotNull GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null) {
            return;
        }
        int screenWidth = guiGraphics.guiWidth();
        int screenHeight = guiGraphics.guiHeight();
        int renderedIcons = 0;
        double scaleFactor = mc.getWindow().getGuiScale();
        for (EquipmentSlot slot : EQUIPMENT_ORDER) {
            List abilityCooldowns;
            ItemStack itemStack = player.getItemBySlot(slot);
            Item item = itemStack.getItem();
            if (!(item instanceof ToggleableTool)) continue;
            ToggleableTool toggleableTool = (ToggleableTool)item;
            if (!itemStack.has(JustDireDataComponents.ABILITY_COOLDOWNS) || (abilityCooldowns = (List)itemStack.get(JustDireDataComponents.ABILITY_COOLDOWNS)) == null) continue;
            for (ToolRecords.AbilityCooldown abilityCooldown : abilityCooldowns) {
                int xPosition = screenWidth / 2 - (Integer)Config.OVERLAY_X.get() + renderedIcons % 7 * 11;
                int yPosition = screenHeight - (Integer)Config.OVERLAY_Y.get() - renderedIcons / 7 * 11;
                Ability ability = Ability.byName(abilityCooldown.abilityName());
                int cooldown = abilityCooldown.cooldownTicks();
                boolean active = abilityCooldown.isactive();
                if (active) {
                    abilityParams = toggleableTool.getAbilityParams(ability);
                    int activeMax = abilityParams.activeCooldown;
                    iconHeight = cooldown * 8 / activeMax + 1;
                    blitYPosition = yPosition + (18 - iconHeight);
                    textureYOffset = 9 - iconHeight;
                    guiGraphics.blit(ability.getCooldownIcon(), xPosition, blitYPosition, 0.0f, (float)textureYOffset, 9, iconHeight, 9, 9);
                    RenderSystem.enableBlend();
                    RenderSystem.defaultBlendFunc();
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.25f);
                    guiGraphics.blit(ability.getCooldownIcon(), xPosition, yPosition + 9, 0.0f, 0.0f, 9, 9, 9, 9);
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                } else {
                    abilityParams = toggleableTool.getAbilityParams(ability);
                    int cooldownMax = abilityParams.cooldown;
                    iconHeight = 9 - cooldown * 9 / cooldownMax;
                    blitYPosition = yPosition + (18 - iconHeight);
                    textureYOffset = 9 - iconHeight;
                    RenderSystem.setShaderColor((float)1.0f, (float)0.5f, (float)0.5f, (float)1.0f);
                    guiGraphics.blit(ability.getCooldownIcon(), xPosition, blitYPosition, 0.0f, (float)textureYOffset, 9, iconHeight, 9, 9);
                    RenderSystem.enableBlend();
                    RenderSystem.defaultBlendFunc();
                    RenderSystem.setShaderColor((float)1.0f, (float)0.5f, (float)0.5f, (float)0.25f);
                    guiGraphics.blit(ability.getCooldownIcon(), xPosition, yPosition + 9, 0.0f, 0.0f, 9, 9, 9, 9);
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                }
                ++renderedIcons;
            }
        }
    }
}

