/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.client.jei;

import com.direwolf20.justdirethings.datagen.recipes.FluidDropRecipe;
import com.direwolf20.justdirethings.setup.Registration;
import com.mojang.blaze3d.systems.RenderSystem;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;

public class FluidDropRecipeCategory
implements IRecipeCategory<FluidDropRecipe> {
    public static final RecipeType<FluidDropRecipe> TYPE = RecipeType.create((String)"justdirethings", (String)"fluid_drop_recipe", FluidDropRecipe.class);
    public static final int width = 120;
    public static final int height = 40;
    private final IDrawable background;
    private final IDrawable slot;
    private final IDrawable icon;
    private final Component localizedName;
    private final IDrawableStatic arrow;

    public FluidDropRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(120, 40);
        this.slot = guiHelper.getSlotDrawable();
        this.icon = guiHelper.createDrawableItemStack(new ItemStack((ItemLike)Registration.PolymorphicCatalyst.get()));
        this.localizedName = Component.translatable((String)"justdirethings.fluiddroprecipe.title");
        this.arrow = guiHelper.createDrawable(ResourceLocation.fromNamespaceAndPath((String)"jei", (String)"textures/jei/gui/gui_vanilla.png"), 82, 128, 24, 17);
    }

    public RecipeType<FluidDropRecipe> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(FluidDropRecipe recipe, IRecipeSlotsView slotsView, GuiGraphics gui, double mouseX, double mouseY) {
        RenderSystem.enableBlend();
        this.arrow.draw(gui, 34, 20);
        this.background.draw(gui, 17, 0);
        RenderSystem.disableBlend();
    }

    public void setRecipe(IRecipeLayoutBuilder builder, FluidDropRecipe recipe, IFocusGroup focuses) {
        BlockState input = recipe.getInput();
        IRecipeSlotBuilder inputSlotBuilder = builder.addSlot(RecipeIngredientRole.INPUT, 9, 20);
        Block block = input.getBlock();
        if (block instanceof LiquidBlock) {
            LiquidBlock liquidBlock = (LiquidBlock)block;
            inputSlotBuilder.addFluidStack((Fluid)liquidBlock.fluid, 1000L);
        }
        builder.addSlot(RecipeIngredientRole.CATALYST, 9, 0).addItemStack(new ItemStack((ItemLike)recipe.getCatalyst()));
        BlockState output = recipe.getOutput();
        Block block2 = output.getBlock();
        if (block2 instanceof LiquidBlock) {
            LiquidBlock liquidBlock = (LiquidBlock)block2;
            builder.addSlot(RecipeIngredientRole.OUTPUT, 68, 20).addFluidStack((Fluid)liquidBlock.fluid, 1000L);
        }
    }
}

