/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.client.events;

import com.direwolf20.justdirethings.client.KeyBindings;
import com.direwolf20.justdirethings.client.screens.AdvPortalRadialMenu;
import com.direwolf20.justdirethings.common.items.PortalGunV2;
import com.direwolf20.justdirethings.common.items.interfaces.Ability;
import com.direwolf20.justdirethings.common.items.interfaces.LeftClickableTool;
import com.direwolf20.justdirethings.common.items.interfaces.ToggleableItem;
import com.direwolf20.justdirethings.common.items.interfaces.ToggleableTool;
import com.direwolf20.justdirethings.common.network.data.LeftClickPayload;
import com.direwolf20.justdirethings.common.network.data.ToggleToolPayload;
import com.direwolf20.justdirethings.util.MiscTools;
import java.util.List;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.settings.KeyModifier;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(modid="justdirethings", value={Dist.CLIENT})
public class EventKeyInput {
    @SubscribeEvent
    public static void handleEventInput(ClientTickEvent.Post event) {
        ItemStack toggleableItem;
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            return;
        }
        KeyMapping keyMapping = KeyBindings.toggleTool;
        ItemStack portalGun = PortalGunV2.getPortalGunv2((Player)mc.player);
        if (!portalGun.isEmpty() && !(mc.screen instanceof AdvPortalRadialMenu) && keyMapping.consumeClick() && (keyMapping.getKeyModifier() == KeyModifier.NONE && KeyModifier.getActiveModifier() == KeyModifier.NONE || keyMapping.getKeyModifier() != KeyModifier.NONE)) {
            mc.setScreen((Screen)new AdvPortalRadialMenu(portalGun));
        }
        if (!(toggleableItem = ToggleableItem.getToggleableItem((Player)mc.player)).isEmpty() && KeyBindings.toggleTool.consumeClick()) {
            PacketDistributor.sendToServer((CustomPacketPayload)new ToggleToolPayload("enabled"), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @SubscribeEvent
    public static void onKeyInput(InputEvent.Key event) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null || mc.player == null || mc.screen != null) {
            return;
        }
        LocalPlayer player = mc.player;
        if (event.getAction() == 1) {
            ToggleableTool toggleableTool;
            Item item;
            ItemStack itemStack;
            int i;
            for (i = 0; i < mc.player.getInventory().items.size(); ++i) {
                itemStack = mc.player.getInventory().getItem(i);
                item = itemStack.getItem();
                if (!(item instanceof ToggleableTool)) continue;
                toggleableTool = (ToggleableTool)item;
                if (!(itemStack.getItem() instanceof LeftClickableTool)) continue;
                EventKeyInput.activateAbilities(itemStack, event.getKey(), toggleableTool, (Player)player, i, false);
            }
            for (i = mc.player.getInventory().items.size(); i < mc.player.getInventory().items.size() + mc.player.getInventory().armor.size(); ++i) {
                itemStack = mc.player.getInventory().getItem(i);
                item = itemStack.getItem();
                if (!(item instanceof ToggleableTool)) continue;
                toggleableTool = (ToggleableTool)item;
                if (!(itemStack.getItem() instanceof LeftClickableTool)) continue;
                EventKeyInput.activateAbilities(itemStack, event.getKey(), toggleableTool, (Player)player, i, false);
            }
            for (i = mc.player.getInventory().items.size() + mc.player.getInventory().armor.size(); i < mc.player.getInventory().items.size() + mc.player.getInventory().armor.size() + mc.player.getInventory().offhand.size(); ++i) {
                itemStack = mc.player.getInventory().getItem(i);
                item = itemStack.getItem();
                if (!(item instanceof ToggleableTool)) continue;
                toggleableTool = (ToggleableTool)item;
                if (!(itemStack.getItem() instanceof LeftClickableTool)) continue;
                EventKeyInput.activateAbilities(itemStack, event.getKey(), toggleableTool, (Player)player, i, false);
            }
        }
    }

    @SubscribeEvent
    public static void onMouseInput(InputEvent.MouseButton.Post event) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null || mc.player == null || mc.screen != null || event.getButton() == 0 || event.getButton() == 1 || event.getAction() != 1) {
            return;
        }
        LocalPlayer player = mc.player;
        for (int i = 0; i < mc.player.getInventory().items.size(); ++i) {
            ItemStack itemStack = mc.player.getInventory().getItem(i);
            Item item = itemStack.getItem();
            if (!(item instanceof ToggleableTool)) continue;
            ToggleableTool toggleableTool = (ToggleableTool)item;
            if (!(itemStack.getItem() instanceof LeftClickableTool)) continue;
            EventKeyInput.activateAbilities(itemStack, event.getButton(), toggleableTool, (Player)player, i, true);
        }
    }

    private static void activateAbilities(ItemStack itemStack, int key, ToggleableTool toggleableTool, Player player, int invSlot, boolean isMouse) {
        List<Ability> abilities = LeftClickableTool.getCustomBindingListFor(itemStack, key, isMouse);
        if (!abilities.isEmpty()) {
            toggleableTool.useAbility(player.level(), player, itemStack, key, isMouse);
            BlockHitResult blockHitResult = MiscTools.getHitResult(player);
            if (blockHitResult.getType() == HitResult.Type.BLOCK) {
                UseOnContext useoncontext = new UseOnContext(player.level(), player, InteractionHand.MAIN_HAND, itemStack, blockHitResult);
                toggleableTool.useOnAbility(useoncontext, itemStack, key, isMouse);
            }
            PacketDistributor.sendToServer((CustomPacketPayload)new LeftClickPayload(0, false, BlockPos.ZERO, -1, invSlot, key, isMouse), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }
}

