/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.client.blockentityrenders.baseber;

import com.direwolf20.justdirethings.client.renderers.DireModelBlockRenderer;
import com.direwolf20.justdirethings.client.renderers.DireVertexConsumer;
import com.direwolf20.justdirethings.client.renderers.OurRenderTypes;
import com.direwolf20.justdirethings.common.blockentities.basebe.GooBlockBE_Base;
import com.direwolf20.justdirethings.common.blocks.gooblocks.GooPatternBlock;
import com.direwolf20.justdirethings.setup.Registration;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.BitSet;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.data.ModelData;

public class GooBlockRender_Base<T extends GooBlockBE_Base>
implements BlockEntityRenderer<T> {
    private static final float percentageDivisor = 100.0f / (float)GooPatternBlock.GOOSTAGE.getPossibleValues().size();

    public GooBlockRender_Base(BlockEntityRendererProvider.Context p_173636_) {
    }

    public void render(T blockentity, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightsIn, int combinedOverlayIn) {
        for (Direction direction : Direction.values()) {
            int remainingTicks = ((GooBlockBE_Base)((Object)blockentity)).getRemainingTimeFor(direction);
            if (remainingTicks <= 0) continue;
            int maxTicks = ((GooBlockBE_Base)((Object)blockentity)).getCraftingDuration(direction);
            this.renderTextures(direction, blockentity.getLevel(), blockentity.getBlockPos(), matrixStackIn, bufferIn, combinedOverlayIn, remainingTicks, maxTicks, blockentity.getBlockState(), (GooBlockBE_Base)((Object)blockentity));
        }
    }

    public void renderTextures(Direction direction, Level level, BlockPos pos, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedOverlayIn, int remainingTicks, int maxTicks, BlockState renderState, GooBlockBE_Base gooBlockBE_base) {
        BlockState patternState;
        float percentComplete = (1.0f - (float)remainingTicks / (float)maxTicks) * 100.0f;
        int tensDigit = (int)(percentComplete / percentageDivisor);
        if (tensDigit > 0) {
            patternState = (BlockState)((GooPatternBlock)((Object)Registration.GooPatternBlock.get())).defaultBlockState().setValue((Property)GooPatternBlock.GOOSTAGE, (Comparable)Integer.valueOf(tensDigit - 1));
            this.renderTexturePattern(direction, level, pos, matrixStackIn, bufferIn, combinedOverlayIn, 1.0f, patternState, renderState, gooBlockBE_base);
        }
        patternState = (BlockState)((GooPatternBlock)((Object)Registration.GooPatternBlock.get())).defaultBlockState().setValue((Property)GooPatternBlock.GOOSTAGE, (Comparable)Integer.valueOf(tensDigit));
        float startOfCurrentStage = (float)tensDigit * percentageDivisor;
        float percentagePart = percentComplete - startOfCurrentStage;
        float alpha = percentagePart / percentageDivisor;
        this.renderTexturePattern(direction, level, pos, matrixStackIn, bufferIn, combinedOverlayIn, alpha, patternState, renderState, gooBlockBE_base);
    }

    public void renderTexturePattern(Direction direction, Level level, BlockPos pos, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedOverlayIn, float transparency, BlockState pattern, BlockState renderState, GooBlockBE_Base gooBlockBE_base) {
        BlockRenderDispatcher blockrendererdispatcher = Minecraft.getInstance().getBlockRenderer();
        BlockColors blockColors = Minecraft.getInstance().getBlockColors();
        DireModelBlockRenderer modelBlockRenderer = new DireModelBlockRenderer(blockColors, direction);
        BlockPos renderAtPos = pos.relative(direction);
        float[] afloat = new float[Direction.values().length * 2];
        BitSet bitset = new BitSet(3);
        RandomSource randomSource = RandomSource.create();
        BlockPos.MutableBlockPos blockpos$mutableblockpos = renderAtPos.mutable();
        ModelBlockRenderer.AmbientOcclusionFace modelblockrenderer$ambientocclusionface = new ModelBlockRenderer.AmbientOcclusionFace();
        matrixStackIn.pushPose();
        matrixStackIn.translate((float)direction.getNormal().getX(), (float)direction.getNormal().getY(), (float)direction.getNormal().getZ());
        float translateF = (float)gooBlockBE_base.getTier() / 2000.0f;
        matrixStackIn.translate(-translateF, -translateF, -translateF);
        float scaleF = (float)gooBlockBE_base.getTier() / 1000.0f;
        matrixStackIn.scale(1.0f + scaleF, 1.0f + scaleF, 1.0f + scaleF);
        matrixStackIn.translate(0.5, 0.5, 0.5);
        matrixStackIn.mulPose(direction.getRotation());
        matrixStackIn.translate(-0.5, -0.5, -0.5);
        VertexConsumer builder = bufferIn.getBuffer(OurRenderTypes.GooPattern);
        DireVertexConsumer chunksConsumer = new DireVertexConsumer(builder, 1.0f);
        BakedModel ibakedmodel = blockrendererdispatcher.getBlockModel(pattern);
        randomSource.setSeed(pattern.getSeed(renderAtPos));
        for (Direction renderSide : Direction.values()) {
            List list = ibakedmodel.getQuads(pattern, renderSide, randomSource, ModelData.EMPTY, null);
            if (list.isEmpty()) continue;
            blockpos$mutableblockpos.setWithOffset((Vec3i)renderAtPos, renderSide);
            modelBlockRenderer.renderModelFaceAO((BlockAndTintGetter)level, pattern, renderAtPos, matrixStackIn, (VertexConsumer)chunksConsumer, list, afloat, bitset, modelblockrenderer$ambientocclusionface, combinedOverlayIn);
        }
        VertexConsumer builder2 = bufferIn.getBuffer(OurRenderTypes.RenderBlockBackface);
        DireVertexConsumer chunksConsumer2 = new DireVertexConsumer(builder2, transparency);
        BakedModel ibakedmodel2 = blockrendererdispatcher.getBlockModel(renderState);
        for (Direction renderSide : Direction.values()) {
            Direction newDirection = this.getDirection(direction, renderSide);
            modelBlockRenderer.setDirection(newDirection);
            List list2 = ibakedmodel2.getQuads(renderState, renderSide, randomSource, ModelData.EMPTY, null);
            if (list2.isEmpty()) continue;
            blockpos$mutableblockpos.setWithOffset((Vec3i)renderAtPos, renderSide);
            modelBlockRenderer.renderModelFaceAO((BlockAndTintGetter)level, renderState, renderAtPos, matrixStackIn, (VertexConsumer)chunksConsumer2, list2, afloat, bitset, modelblockrenderer$ambientocclusionface, combinedOverlayIn);
        }
        matrixStackIn.popPose();
    }

    public Direction getDirection(Direction facing, Direction renderSide) {
        return switch (renderSide) {
            default -> throw new MatchException(null, null);
            case Direction.UP -> facing;
            case Direction.DOWN -> facing.getOpposite();
            case Direction.WEST -> {
                if (facing == Direction.DOWN || facing == Direction.UP) {
                    yield Direction.WEST;
                }
                yield facing.getClockWise();
            }
            case Direction.EAST -> {
                if (facing == Direction.DOWN || facing == Direction.UP) {
                    yield Direction.EAST;
                }
                yield facing.getCounterClockWise();
            }
            case Direction.NORTH -> {
                switch (facing) {
                    case DOWN: {
                        yield Direction.SOUTH;
                    }
                    case UP: {
                        yield Direction.NORTH;
                    }
                }
                yield Direction.UP;
            }
            case Direction.SOUTH -> {
                switch (facing) {
                    case DOWN: {
                        yield Direction.NORTH;
                    }
                    case UP: {
                        yield Direction.SOUTH;
                    }
                }
                yield Direction.DOWN;
            }
        };
    }
}

