/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.client;

import com.direwolf20.justdirethings.common.items.PortalGunV2;
import com.direwolf20.justdirethings.common.items.interfaces.ToggleableItem;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.settings.IKeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyConflictContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventBusSubscriber(value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD)
public class KeyBindings {
    private static final Logger LOGGER = LoggerFactory.getLogger(KeyBindings.class);
    private static final KeyConflictContextGadget CONFLICT_CONTEXT_GADGET = new KeyConflictContextGadget();
    private static final List<KeyMapping> keyMappings = new ArrayList<KeyMapping>();
    public static KeyMapping toggleTool = KeyBindings.createBinding("toggle_tool", 86);

    private static KeyMapping createBinding(String name, int key) {
        KeyMapping keyBinding = new KeyMapping(KeyBindings.getKey(name), (IKeyConflictContext)CONFLICT_CONTEXT_GADGET, InputConstants.Type.KEYSYM.getOrCreate(key), KeyBindings.getKey("category"));
        keyMappings.add(keyBinding);
        return keyBinding;
    }

    @SubscribeEvent
    public static void registerKeyMappings(RegisterKeyMappingsEvent event) {
        LOGGER.debug("Registering {} keybinding for {}", (Object)keyMappings.size(), (Object)"justdirethings");
        keyMappings.forEach(arg_0 -> ((RegisterKeyMappingsEvent)event).register(arg_0));
    }

    private static String getKey(String name) {
        return String.join((CharSequence)".", "justdirethings", "key", name);
    }

    public static void onClientInput(InputEvent.Key event) {
    }

    public static class KeyConflictContextGadget
    implements IKeyConflictContext {
        public boolean isActive() {
            LocalPlayer player = Minecraft.getInstance().player;
            return !KeyConflictContext.GUI.isActive() && player != null && (!ToggleableItem.getToggleableItem((Player)player).isEmpty() || !PortalGunV2.getPortalGunv2((Player)player).isEmpty());
        }

        public boolean conflicts(IKeyConflictContext other) {
            return other == this || other == KeyConflictContext.IN_GAME;
        }
    }
}

