/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings;

import com.direwolf20.justdirethings.common.blockentities.EnergyTransmitterBE;
import com.direwolf20.justdirethings.common.blockentities.PlayerAccessorBE;
import com.direwolf20.justdirethings.common.blockentities.basebe.BaseMachineBE;
import com.direwolf20.justdirethings.common.blockentities.basebe.FluidMachineBE;
import com.direwolf20.justdirethings.common.blockentities.basebe.PoweredMachineBE;
import com.direwolf20.justdirethings.common.capabilities.EnergyStorageItemStackNoReceive;
import com.direwolf20.justdirethings.common.capabilities.EnergyStorageItemstack;
import com.direwolf20.justdirethings.common.containers.handlers.DataComponentHandler;
import com.direwolf20.justdirethings.common.items.FluidCanister;
import com.direwolf20.justdirethings.common.items.PortalGunV2;
import com.direwolf20.justdirethings.common.items.datacomponents.JustDireDataComponents;
import com.direwolf20.justdirethings.common.items.interfaces.PoweredItem;
import com.direwolf20.justdirethings.common.network.PacketHandler;
import com.direwolf20.justdirethings.setup.ClientSetup;
import com.direwolf20.justdirethings.setup.Config;
import com.direwolf20.justdirethings.setup.ModSetup;
import com.direwolf20.justdirethings.setup.Registration;
import com.mojang.logging.LogUtils;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.world.chunk.RegisterTicketControllersEvent;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidHandlerItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.slf4j.Logger;

@Mod(value="justdirethings")
public class JustDireThings {
    public static final String MODID = "justdirethings";
    private static final Logger LOGGER = LogUtils.getLogger();

    public JustDireThings(IEventBus modEventBus, ModContainer container) {
        Registration.init(modEventBus);
        Config.register(container);
        modEventBus.addListener(ModSetup::init);
        ModSetup.CREATIVE_MODE_TABS.register(modEventBus);
        modEventBus.addListener(this::registerCapabilities);
        modEventBus.addListener(PacketHandler::registerNetworking);
        modEventBus.addListener(this::registerChunkLoaders);
        if (FMLLoader.getDist().isClient()) {
            modEventBus.addListener(ClientSetup::init);
        }
    }

    private void registerChunkLoaders(RegisterTicketControllersEvent event) {
        event.register(Registration.TICKET_CONTROLLER);
    }

    private void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerItem(Capabilities.ItemHandler.ITEM, (itemStack, context) -> new DataComponentHandler((ItemStack)itemStack, 1), new ItemLike[]{(ItemLike)Registration.Pocket_Generator.get()});
        event.registerItem(Capabilities.EnergyStorage.ITEM, (itemStack, context) -> {
            int capacity = 1000000;
            Item patt0$temp = itemStack.getItem();
            if (patt0$temp instanceof PoweredItem) {
                PoweredItem poweredItem = (PoweredItem)patt0$temp;
                capacity = poweredItem.getMaxEnergy();
            }
            return new EnergyStorageItemStackNoReceive(capacity, (ItemStack)itemStack);
        }, new ItemLike[]{(ItemLike)Registration.Pocket_Generator.get()});
        event.registerItem(Capabilities.EnergyStorage.ITEM, (itemStack, context) -> {
            int capacity = 1000000;
            Item patt0$temp = itemStack.getItem();
            if (patt0$temp instanceof PoweredItem) {
                PoweredItem poweredItem = (PoweredItem)patt0$temp;
                capacity = poweredItem.getMaxEnergy();
            }
            return new EnergyStorageItemstack(capacity, (ItemStack)itemStack);
        }, new ItemLike[]{(ItemLike)Registration.CelestigemSword.get(), (ItemLike)Registration.CelestigemPickaxe.get(), (ItemLike)Registration.CelestigemAxe.get(), (ItemLike)Registration.CelestigemShovel.get(), (ItemLike)Registration.CelestigemHoe.get(), (ItemLike)Registration.EclipseAlloySword.get(), (ItemLike)Registration.EclipseAlloyPickaxe.get(), (ItemLike)Registration.EclipseAlloyAxe.get(), (ItemLike)Registration.EclipseAlloyShovel.get(), (ItemLike)Registration.EclipseAlloyHoe.get(), (ItemLike)Registration.CelestigemPaxel.get(), (ItemLike)Registration.EclipseAlloyPaxel.get(), (ItemLike)Registration.VoidshiftWand.get(), (ItemLike)Registration.EclipsegateWand.get(), (ItemLike)Registration.PortalGun.get(), (ItemLike)Registration.PortalGunV2.get()});
        event.registerItem(Capabilities.FluidHandler.ITEM, (itemStack, context) -> {
            if (itemStack.getItem() instanceof PortalGunV2) {
                return new FluidHandlerItemStack(this, (Supplier)JustDireDataComponents.FLUID_CONTAINER, (ItemStack)itemStack, 8000){

                    public boolean isFluidValid(int tank, FluidStack stack) {
                        return stack.is((FluidType)Registration.PORTAL_FLUID_TYPE.get());
                    }

                    public boolean canFillFluidType(FluidStack fluid) {
                        return fluid.is((FluidType)Registration.PORTAL_FLUID_TYPE.get());
                    }
                };
            }
            Item patt0$temp = itemStack.getItem();
            if (patt0$temp instanceof FluidCanister) {
                FluidCanister fluidCanister = (FluidCanister)patt0$temp;
                return new FluidHandlerItemStack(JustDireDataComponents.FLUID_CONTAINER, itemStack, fluidCanister.getMaxMB());
            }
            return null;
        }, new ItemLike[]{(ItemLike)Registration.PortalGunV2.get(), (ItemLike)Registration.FluidCanister.get()});
        event.registerBlock(Capabilities.ItemHandler.BLOCK, (level, pos, state, be, side) -> {
            if (be instanceof BaseMachineBE) {
                return (IItemHandler)be.getData(Registration.MACHINE_HANDLER);
            }
            return null;
        }, new Block[]{(Block)Registration.BlockBreakerT1.get(), (Block)Registration.BlockBreakerT2.get(), (Block)Registration.BlockPlacerT1.get(), (Block)Registration.BlockPlacerT2.get(), (Block)Registration.ClickerT1.get(), (Block)Registration.ClickerT2.get(), (Block)Registration.DropperT1.get(), (Block)Registration.DropperT2.get(), (Block)Registration.EnergyTransmitter.get(), (Block)Registration.FluidPlacerT1.get(), (Block)Registration.FluidPlacerT2.get(), (Block)Registration.FluidCollectorT1.get(), (Block)Registration.FluidCollectorT2.get()});
        event.registerBlock(Capabilities.ItemHandler.BLOCK, (level, pos, state, be, side) -> {
            if (be instanceof BaseMachineBE) {
                return (IItemHandler)be.getData(Registration.GENERATOR_ITEM_HANDLER);
            }
            return null;
        }, new Block[]{(Block)Registration.GeneratorT1.get()});
        event.registerBlock(Capabilities.ItemHandler.BLOCK, (level, pos, state, be, side) -> {
            if (be instanceof BaseMachineBE) {
                return (IItemHandler)be.getData(Registration.GENERATOR_FLUID_ITEM_HANDLER);
            }
            return null;
        }, new Block[]{(Block)Registration.GeneratorFluidT1.get()});
        event.registerBlock(Capabilities.ItemHandler.BLOCK, (level, pos, state, be, side) -> {
            if (be instanceof PlayerAccessorBE) {
                PlayerAccessorBE playerAccessorBE = (PlayerAccessorBE)be;
                if (be.getLevel().isClientSide) {
                    return new ItemStackHandler(1);
                }
                return playerAccessorBE.getPlayerHandler((Direction)side);
            }
            return null;
        }, new Block[]{(Block)Registration.PlayerAccessor.get()});
        event.registerBlock(Capabilities.EnergyStorage.BLOCK, (level, pos, state, be, side) -> {
            if (be instanceof PoweredMachineBE) {
                return (IEnergyStorage)be.getData(Registration.ENERGYSTORAGE_MACHINES);
            }
            return null;
        }, new Block[]{(Block)Registration.BlockBreakerT2.get(), (Block)Registration.BlockPlacerT2.get(), (Block)Registration.ClickerT2.get(), (Block)Registration.SensorT2.get(), (Block)Registration.DropperT2.get(), (Block)Registration.BlockSwapperT2.get(), (Block)Registration.FluidPlacerT2.get(), (Block)Registration.FluidCollectorT2.get()});
        event.registerBlock(Capabilities.EnergyStorage.BLOCK, (level, pos, state, be, side) -> {
            if (be instanceof PoweredMachineBE) {
                return (IEnergyStorage)be.getData(Registration.ENERGYSTORAGE_GENERATORS);
            }
            return null;
        }, new Block[]{(Block)Registration.GeneratorT1.get(), (Block)Registration.GeneratorFluidT1.get()});
        event.registerBlock(Capabilities.EnergyStorage.BLOCK, (level, pos, state, be, side) -> {
            if (be instanceof EnergyTransmitterBE && side != null && side.equals((Object)state.getValue((Property)BlockStateProperties.FACING))) {
                return (IEnergyStorage)be.getData(Registration.ENERGYSTORAGE_TRANSMITTERS);
            }
            return null;
        }, new Block[]{(Block)Registration.EnergyTransmitter.get()});
        event.registerBlock(Capabilities.FluidHandler.BLOCK, (level, pos, state, be, side) -> {
            if (be instanceof FluidMachineBE) {
                return (IFluidHandler)be.getData(Registration.MACHINE_FLUID_HANDLER);
            }
            return null;
        }, new Block[]{(Block)Registration.FluidPlacerT1.get(), (Block)Registration.FluidPlacerT2.get(), (Block)Registration.FluidCollectorT1.get(), (Block)Registration.FluidCollectorT2.get()});
        event.registerBlock(Capabilities.FluidHandler.BLOCK, (level, pos, state, be, side) -> {
            if (be instanceof FluidMachineBE) {
                return (IFluidHandler)be.getData(Registration.GENERATOR_FLUID_HANDLER);
            }
            return null;
        }, new Block[]{(Block)Registration.GeneratorFluidT1.get()});
    }
}

