/*
 * Decompiled with CFR 0.152.
 */
package dzwdz.chat_heads;

import com.mojang.blaze3d.platform.NativeImage;
import dzwdz.chat_heads.config.ChatHeadsConfig;
import dzwdz.chat_heads.config.ChatHeadsConfigDefaults;
import dzwdz.chat_heads.config.SenderDetection;
import dzwdz.chat_heads.mixinterface.GuiMessageOwnerAccessor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.client.GuiMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.ChatTypeDecoration;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChatHeads {
    public static final String MOD_ID = "chat_heads";
    public static final String FORMAT_REGEX = "\u00a7.";
    public static final Logger LOGGER = LogManager.getLogger((String)"chat_heads");
    public static final ResourceLocation DISABLE_RESOURCE = ResourceLocation.fromNamespaceAndPath((String)"chat_heads", (String)"disable");
    public static ChatHeadsConfig CONFIG = new ChatHeadsConfigDefaults();
    @Nullable
    public static PlayerInfo lastSender;
    public static boolean refreshing;
    @Nullable
    public static PlayerInfo lineOwner;
    @Nullable
    public static PlayerInfo refreshingLineOwner;
    public static volatile boolean serverSentUuid;
    public static volatile boolean serverDisabledChatHeads;
    public static final Set<ResourceLocation> blendedHeadTextures;

    public static PlayerInfo getLineOwner() {
        return refreshing ? refreshingLineOwner : lineOwner;
    }

    public static void resetLineOwner() {
        if (refreshing) {
            refreshingLineOwner = null;
        } else {
            lineOwner = null;
        }
    }

    public static void handleAddedMessage(Component message, @Nullable ChatType.Bound bound, @Nullable PlayerInfo playerInfo) {
        if (serverDisabledChatHeads) {
            lastSender = null;
            return;
        }
        if (CONFIG.senderDetection() != SenderDetection.HEURISTIC_ONLY) {
            if (playerInfo != null) {
                lastSender = playerInfo;
                serverSentUuid = true;
                return;
            }
            if (CONFIG.senderDetection() == SenderDetection.UUID_ONLY || serverSentUuid && CONFIG.smartHeuristics()) {
                lastSender = null;
                return;
            }
        }
        lastSender = ChatHeads.detectPlayer(message, bound);
    }

    @Nullable
    public static PlayerInfo getOwner(@NotNull GuiMessage.Line guiMessage) {
        return ((GuiMessageOwnerAccessor)guiMessage).chatheads$getOwner();
    }

    @Nullable
    public static PlayerInfo getOwner(@NotNull GuiMessage guiMessage) {
        return ((GuiMessageOwnerAccessor)guiMessage).chatheads$getOwner();
    }

    public static int getChatOffset(@NotNull GuiMessage.Line guiMessage) {
        return ChatHeads.getChatOffset(ChatHeads.getOwner(guiMessage));
    }

    public static int getChatOffset(@Nullable PlayerInfo owner) {
        if (owner != null || CONFIG.offsetNonPlayerText() && !serverDisabledChatHeads) {
            return 10;
        }
        return 0;
    }

    @Nullable
    public static PlayerInfo detectPlayer(Component message, @Nullable ChatType.Bound bound) {
        ClientPacketListener connection = Minecraft.getInstance().getConnection();
        if (connection == null) {
            return null;
        }
        Component sender = ChatHeads.getSenderDecoration(bound);
        PlayerInfoCache playerInfoCache = new PlayerInfoCache(connection);
        playerInfoCache.collectProfileNames();
        PlayerInfo player = ChatHeads.getTellReceiver(sender != null ? sender : message).map(playerInfoCache::get).orElse(null);
        if (player != null) {
            return player;
        }
        playerInfoCache.collectAllNames();
        if (sender != null) {
            return playerInfoCache.get(sender.getString());
        }
        return ChatHeads.scanForPlayerName(message.getString(), playerInfoCache);
    }

    private static Optional<String> getTellReceiver(Component component) {
        return component.visit((style, string) -> {
            String cmd;
            ClickEvent clickEvent = style.getClickEvent();
            if (clickEvent != null && (cmd = clickEvent.getValue()).startsWith("/tell ")) {
                String name = cmd.substring("/tell ".length()).trim();
                return Optional.of(name);
            }
            return Optional.empty();
        }, Style.EMPTY);
    }

    @Nullable
    private static Component getSenderDecoration(@Nullable ChatType.Bound bound) {
        if (bound == null) {
            return null;
        }
        for (ChatTypeDecoration.Parameter param : ((ChatType)bound.chatType().value()).chat().parameters()) {
            if (param != ChatTypeDecoration.Parameter.SENDER) continue;
            return bound.name();
        }
        return null;
    }

    @Nullable
    private static PlayerInfo scanForPlayerName(@NotNull String message, PlayerInfoCache playerInfoCache) {
        message = message.replaceAll(FORMAT_REGEX, "");
        Map<Integer, List<String>> namesByFirstCharacter = playerInfoCache.createNamesByFirstCharacterMap();
        boolean insideWord = false;
        int[] messageSeq = message.codePoints().toArray();
        for (int i = 0; i < messageSeq.length; ++i) {
            int c = messageSeq[i];
            if (insideWord && ChatHeads.isWordCharacter(c)) continue;
            for (String name : namesByFirstCharacter.getOrDefault(c, List.of())) {
                boolean nameIsFollowedByWord;
                int[] nameSeq = name.codePoints().toArray();
                if (i + nameSeq.length - 1 >= messageSeq.length) continue;
                boolean nameEndsAsWord = ChatHeads.isWordCharacter(nameSeq[nameSeq.length - 1]);
                boolean bl = nameIsFollowedByWord = i + nameSeq.length < messageSeq.length && ChatHeads.isWordCharacter(messageSeq[i + nameSeq.length]);
                if (nameEndsAsWord && nameIsFollowedByWord || !ChatHeads.containsSubsequenceAt(messageSeq, i, nameSeq)) continue;
                return playerInfoCache.get(name);
            }
            insideWord = ChatHeads.isWordCharacter(c);
        }
        return null;
    }

    private static boolean isWordCharacter(int codePoint) {
        return Character.isLetterOrDigit(codePoint) || codePoint == 95 || Character.getNumericValue(codePoint) != -1;
    }

    private static boolean containsSubsequenceAt(int[] sequence, int startIndex, int[] subsequence) {
        for (int j = 0; j < subsequence.length; ++j) {
            if (sequence[startIndex + j] == subsequence[j]) continue;
            return false;
        }
        return true;
    }

    public static NativeImage extractBlendedHead(NativeImage skin) {
        int xScale = skin.getWidth() / 64;
        int yScale = skin.getHeight() / 64;
        NativeImage head = new NativeImage(8 * xScale, 8 * yScale, false);
        for (int y = 0; y < head.getHeight(); ++y) {
            for (int x = 0; x < head.getWidth(); ++x) {
                int headColor = skin.getPixelRGBA(8 * xScale + x, 8 * yScale + y);
                int hatColor = skin.getPixelRGBA(40 * xScale + x, 8 * yScale + y);
                head.setPixelRGBA(x, y, headColor);
                head.blendPixel(x, y, hatColor);
            }
        }
        return head;
    }

    public static ResourceLocation getBlendedHeadLocation(ResourceLocation skinLocation) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)skinLocation.getPath());
    }

    public static void renderChatHead(GuiGraphics guiGraphics, int x, int y, PlayerInfo owner) {
        ResourceLocation skinLocation = owner.getSkin().texture();
        if (blendedHeadTextures.contains(skinLocation)) {
            guiGraphics.blit(ChatHeads.getBlendedHeadLocation(skinLocation), x, y, 8, 8, 0.0f, 0.0f, 8, 8, 8, 8);
        } else {
            guiGraphics.blit(skinLocation, x, y, 8, 8, 8.0f, 8.0f, 8, 8, 64, 64);
            guiGraphics.blit(skinLocation, x, y, 8, 8, 40.0f, 8.0f, 8, 8, 64, 64);
        }
    }

    static {
        serverSentUuid = false;
        serverDisabledChatHeads = false;
        blendedHeadTextures = new HashSet<ResourceLocation>();
    }

    static class PlayerInfoCache {
        private final ClientPacketListener connection;
        private final Map<String, PlayerInfo> playerInfos = new HashMap<String, PlayerInfo>();
        private boolean collectedProfileNames = false;
        private boolean collectedEverything = false;

        public PlayerInfoCache(ClientPacketListener connection) {
            this.connection = connection;
        }

        public void collectProfileNames() {
            if (this.collectedProfileNames) {
                return;
            }
            this.collectedProfileNames = true;
            for (PlayerInfo playerInfo : this.connection.getOnlinePlayers()) {
                String profileName = playerInfo.getProfile().getName().replaceAll(ChatHeads.FORMAT_REGEX, "");
                if (profileName.isEmpty()) continue;
                this.playerInfos.put(profileName, playerInfo);
            }
        }

        public void collectAllNames() {
            if (this.collectedEverything) {
                return;
            }
            this.collectedEverything = true;
            this.collectProfileNames();
            for (PlayerInfo playerInfo : this.connection.getOnlinePlayers()) {
                String displayName;
                if (playerInfo.getTabListDisplayName() == null || (displayName = playerInfo.getTabListDisplayName().getString().replaceAll(ChatHeads.FORMAT_REGEX, "")).isEmpty()) continue;
                this.playerInfos.putIfAbsent(displayName, playerInfo);
            }
            for (Map.Entry entry : CONFIG.getNameAliases().entrySet()) {
                PlayerInfo playerInfo = this.playerInfos.get(entry.getValue());
                if (playerInfo == null) continue;
                this.playerInfos.putIfAbsent((String)entry.getKey(), playerInfo);
            }
        }

        public Map<Integer, List<String>> createNamesByFirstCharacterMap() {
            HashMap<Integer, List<String>> namesByFirstCharacter = new HashMap<Integer, List<String>>();
            for (String name : this.playerInfos.keySet()) {
                namesByFirstCharacter.compute(name.codePointAt(0), (key, value) -> {
                    if (value == null) {
                        value = new ArrayList<String>();
                    }
                    value.add(name);
                    return value;
                });
            }
            return namesByFirstCharacter;
        }

        @Nullable
        public PlayerInfo get(@NotNull String name) {
            return this.playerInfos.get(name);
        }

        public Set<String> getNames() {
            return this.playerInfos.keySet();
        }
    }
}

