/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.common.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.io.File;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.common.client.IconExport;
import net.blay09.mods.balm.common.config.ConfigJsonExport;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;

public class BalmCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"balm").then(((LiteralArgumentBuilder)Commands.literal((String)"export").then(Commands.literal((String)"config").then(Commands.argument((String)"class", (ArgumentType)StringArgumentType.greedyString()).executes(context -> {
            String className = (String)context.getArgument("class", String.class);
            try {
                Class<?> configDataClass = Class.forName(className);
                ConfigJsonExport.exportToFile(configDataClass, new File("exports/config/" + configDataClass.getSimpleName() + ".json"));
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                throw new RuntimeException("Invalid config data class: " + className, e);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("Error exporting config data class: " + className, e);
            }
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Exported config for " + className)), false);
            return 0;
        })))).then(Commands.literal((String)"icons").then(Commands.argument((String)"filter", (ArgumentType)StringArgumentType.greedyString()).executes(context -> {
            String filter = (String)context.getArgument("filter", String.class);
            if (Balm.getProxy().isClient()) {
                try {
                    IconExport.export(filter);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new RuntimeException("Error exporting icons for " + filter, e);
                }
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Exported icons for " + filter)), false);
                return 1;
            }
            return 0;
        })))));
    }
}

