/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.util;

import com.google.common.graph.EndpointPair;
import com.google.common.graph.MutableGraph;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.Tiers;
import net.neoforged.neoforge.fluids.FluidStack;

public class TheurgyExtraCodecs {
    private static final Map<String, Tiers> TIERS = Map.of("wood", Tiers.WOOD, "stone", Tiers.STONE, "iron", Tiers.IRON, "diamond", Tiers.DIAMOND, "gold", Tiers.GOLD, "netherite", Tiers.NETHERITE);
    public static final Codec<Tiers> TIERS_CODEC = Codec.stringResolver(Enum::name, TIERS::get);
    public static final Codec<FluidStack> SINGLE_FLUID_CODEC = BuiltInRegistries.FLUID.byNameCodec().xmap(fluid -> new FluidStack(fluid, 1), FluidStack::getFluid);

    public static <V> Codec<MutableGraph<V>> graph(Codec<V> elementCodec, Supplier<MutableGraph<V>> graphSupplier) {
        return TheurgyExtraCodecs.internalGraph(elementCodec).xmap(internalGraph -> {
            MutableGraph g = (MutableGraph)graphSupplier.get();
            internalGraph.nodes().forEach(arg_0 -> ((MutableGraph)g).addNode(arg_0));
            internalGraph.edges().forEach(arg_0 -> ((MutableGraph)g).putEdge(arg_0));
            return g;
        }, graph -> {
            ArrayList nodes = new ArrayList(graph.nodes());
            ArrayList edges = new ArrayList(graph.edges());
            return new InternalGraph(nodes, edges);
        });
    }

    private static <V> Codec<EndpointPair<V>> unorderedEndpointPair(Codec<V> elementCodec) {
        return RecordCodecBuilder.create(instance -> instance.group((App)elementCodec.fieldOf("nodeU").forGetter(EndpointPair::nodeU), (App)elementCodec.fieldOf("nodeV").forGetter(EndpointPair::nodeV)).apply((Applicative)instance, EndpointPair::unordered));
    }

    private static <V> Codec<InternalGraph<V>> internalGraph(Codec<V> elementCodec) {
        return RecordCodecBuilder.create(instance -> instance.group((App)Codec.list((Codec)elementCodec).fieldOf("nodes").forGetter(InternalGraph::nodes), (App)Codec.list(TheurgyExtraCodecs.unorderedEndpointPair(elementCodec)).fieldOf("edges").forGetter(InternalGraph::edges)).apply((Applicative)instance, InternalGraph::new));
    }

    private record InternalGraph<V>(List<V> nodes, List<EndpointPair<V>> edges) {
    }
}

