/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.tooltips;

import com.google.common.collect.ImmutableList;
import com.klikli_dev.theurgy.tooltips.TooltipDataProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;

public class TooltipHandler {
    private static final Map<Item, TooltipDataProvider> tooltipDataProviders = new HashMap<Item, TooltipDataProvider>();
    private static final List<String> namespacesToListenFor = new ArrayList<String>();

    public static void onItemTooltipEvent(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
        if (namespacesToListenFor.contains(itemId.getNamespace())) {
            String tooltipKey = stack.getDescriptionId() + ".tooltip";
            String extendedTooltipKey = stack.getDescriptionId() + ".tooltip.extended";
            String usageTooltipKey = stack.getDescriptionId() + ".tooltip.usage";
            boolean tooltipExists = I18n.exists((String)tooltipKey);
            boolean extendedTooltipExists = I18n.exists((String)extendedTooltipKey);
            boolean usageTooltipExists = I18n.exists((String)usageTooltipKey);
            List<MutableComponent> additionalTooltipData = TooltipHandler.getAdditionalTooltipData(stack);
            if (tooltipExists) {
                event.getToolTip().add(Component.translatable((String)tooltipKey, (Object[])additionalTooltipData.toArray()).withStyle(Style.EMPTY.withColor(ChatFormatting.GRAY)));
            }
            if (extendedTooltipExists) {
                if (Screen.hasShiftDown()) {
                    event.getToolTip().add(Component.literal((String)" "));
                    event.getToolTip().add(Component.translatable((String)"tooltip.theurgy.extended_heading", (Object[])additionalTooltipData.toArray()));
                    event.getToolTip().add(Component.translatable((String)extendedTooltipKey, (Object[])additionalTooltipData.toArray()).withStyle(Style.EMPTY.withColor(ChatFormatting.GRAY)));
                } else {
                    event.getToolTip().add(Component.literal((String)" "));
                    event.getToolTip().add(Component.translatable((String)"tooltip.theurgy.show_extended", (Object[])additionalTooltipData.toArray()));
                }
            }
            if (usageTooltipExists) {
                if (Screen.hasControlDown()) {
                    if (!extendedTooltipExists || Screen.hasShiftDown()) {
                        event.getToolTip().add(Component.literal((String)" "));
                    }
                    event.getToolTip().add(Component.translatable((String)"tooltip.theurgy.usage_heading", (Object[])additionalTooltipData.toArray()));
                    event.getToolTip().add(Component.translatable((String)usageTooltipKey, (Object[])additionalTooltipData.toArray()).withStyle(Style.EMPTY.withColor(ChatFormatting.GRAY)));
                } else {
                    if (!extendedTooltipExists || Screen.hasShiftDown()) {
                        event.getToolTip().add(Component.literal((String)" "));
                    }
                    event.getToolTip().add(Component.translatable((String)"tooltip.theurgy.show_usage", (Object[])additionalTooltipData.toArray()));
                }
            }
        }
    }

    public static void registerTooltipDataProvider(Item item, TooltipDataProvider provider) {
        tooltipDataProviders.put(item, provider);
    }

    public static void registerNamespaceToListenTo(String namespace) {
        namespacesToListenFor.add(namespace);
    }

    public static List<MutableComponent> getAdditionalTooltipData(ItemStack stack) {
        TooltipDataProvider provider = tooltipDataProviders.get(stack.getItem());
        if (provider != null) {
            return provider.getTooltipData(stack);
        }
        return ImmutableList.of();
    }

    public static MutableComponent holdShift() {
        return Component.translatable((String)"tooltip.theurgy.show_extended");
    }
}

