/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.registry;

import com.google.common.base.Suppliers;
import com.klikli_dev.theurgy.content.item.sulfur.AlchemicalSulfurItem;
import com.klikli_dev.theurgy.content.item.sulfur.AlchemicalSulfurTier;
import com.klikli_dev.theurgy.content.item.sulfur.AlchemicalSulfurType;
import com.klikli_dev.theurgy.content.recipe.LiquefactionRecipe;
import com.klikli_dev.theurgy.registry.CreativeModeTabRegistry;
import com.klikli_dev.theurgy.registry.DataComponentRegistry;
import com.klikli_dev.theurgy.registry.ItemRegistry;
import com.klikli_dev.theurgy.registry.ItemTagRegistry;
import com.klikli_dev.theurgy.registry.RecipeTypeRegistry;
import com.klikli_dev.theurgy.util.LevelUtil;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenCustomHashSet;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemStackLinkedSet;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;

public class SulfurRegistry {
    public static final DeferredRegister.Items SULFURS = DeferredRegister.createItems((String)"theurgy");
    public static final DeferredItem<AlchemicalSulfurItem> GEMS_ABUNDANT = SulfurRegistry.registerNiter("gems_abundant", ItemRegistry.GEMS_ABUNDANT_ICON, AlchemicalSulfurTier.ABUNDANT);
    public static final DeferredItem<AlchemicalSulfurItem> GEMS_COMMON = SulfurRegistry.registerNiter("gems_common", ItemRegistry.GEMS_COMMON_ICON, AlchemicalSulfurTier.COMMON);
    public static final DeferredItem<AlchemicalSulfurItem> GEMS_RARE = SulfurRegistry.registerNiter("gems_rare", ItemRegistry.GEMS_RARE_ICON, AlchemicalSulfurTier.RARE);
    public static final DeferredItem<AlchemicalSulfurItem> GEMS_PRECIOUS = SulfurRegistry.registerNiter("gems_precious", ItemRegistry.GEMS_PRECIOUS_ICON, AlchemicalSulfurTier.PRECIOUS);
    public static final DeferredItem<AlchemicalSulfurItem> METALS_ABUNDANT = SulfurRegistry.registerNiter("metals_abundant", ItemRegistry.METALS_ABUNDANT_ICON, AlchemicalSulfurTier.ABUNDANT);
    public static final DeferredItem<AlchemicalSulfurItem> METALS_COMMON = SulfurRegistry.registerNiter("metals_common", ItemRegistry.METALS_COMMON_ICON, AlchemicalSulfurTier.COMMON);
    public static final DeferredItem<AlchemicalSulfurItem> METALS_RARE = SulfurRegistry.registerNiter("metals_rare", ItemRegistry.METALS_RARE_ICON, AlchemicalSulfurTier.RARE);
    public static final DeferredItem<AlchemicalSulfurItem> METALS_PRECIOUS = SulfurRegistry.registerNiter("metals_precious", ItemRegistry.METALS_PRECIOUS_ICON, AlchemicalSulfurTier.PRECIOUS);
    public static final DeferredItem<AlchemicalSulfurItem> OTHER_MINERALS_ABUNDANT = SulfurRegistry.registerNiter("other_minerals_abundant", ItemRegistry.OTHER_MINERALS_ABUNDANT_ICON, AlchemicalSulfurTier.ABUNDANT);
    public static final DeferredItem<AlchemicalSulfurItem> OTHER_MINERALS_COMMON = SulfurRegistry.registerNiter("other_minerals_common", ItemRegistry.OTHER_MINERALS_COMMON_ICON, AlchemicalSulfurTier.COMMON);
    public static final DeferredItem<AlchemicalSulfurItem> OTHER_MINERALS_RARE = SulfurRegistry.registerNiter("other_minerals_rare", ItemRegistry.OTHER_MINERALS_RARE_ICON, AlchemicalSulfurTier.RARE);
    public static final DeferredItem<AlchemicalSulfurItem> OTHER_MINERALS_PRECIOUS = SulfurRegistry.registerNiter("other_minerals_precious", ItemRegistry.OTHER_MINERALS_PRECIOUS_ICON, AlchemicalSulfurTier.PRECIOUS);
    public static final DeferredItem<AlchemicalSulfurItem> LOGS = SulfurRegistry.registerWithTagSourceNameOverride((TagKey<Item>)ItemTags.LOGS, AlchemicalSulfurTier.ABUNDANT, AlchemicalSulfurType.MISC);
    public static final DeferredItem<AlchemicalSulfurItem> WHEAT = SulfurRegistry.registerDefault("wheat", Items.WHEAT, AlchemicalSulfurTier.ABUNDANT, AlchemicalSulfurType.MISC);
    public static final DeferredItem<AlchemicalSulfurItem> IRON = SulfurRegistry.registerWithSourceNameOverride((TagKey<Item>)Tags.Items.INGOTS_IRON, AlchemicalSulfurTier.COMMON, AlchemicalSulfurType.METALS);
    public static final DeferredItem<AlchemicalSulfurItem> COPPER = SulfurRegistry.registerWithSourceNameOverride((TagKey<Item>)Tags.Items.INGOTS_COPPER, AlchemicalSulfurTier.ABUNDANT, AlchemicalSulfurType.METALS);
    public static final DeferredItem<AlchemicalSulfurItem> SILVER = SulfurRegistry.registerWithSourceNameOverride(ItemTagRegistry.INGOTS_SILVER, AlchemicalSulfurTier.RARE, AlchemicalSulfurType.METALS);
    public static final DeferredItem<AlchemicalSulfurItem> GOLD = SulfurRegistry.registerWithSourceNameOverride((TagKey<Item>)Tags.Items.INGOTS_GOLD, AlchemicalSulfurTier.RARE, AlchemicalSulfurType.METALS);
    public static final DeferredItem<AlchemicalSulfurItem> NETHERITE = SulfurRegistry.registerWithSourceNameOverride((TagKey<Item>)Tags.Items.INGOTS_NETHERITE, AlchemicalSulfurTier.PRECIOUS, AlchemicalSulfurType.METALS);
    public static final DeferredItem<AlchemicalSulfurItem> URANIUM = SulfurRegistry.registerWithSourceNameOverride(ItemTagRegistry.INGOTS_URANIUM, AlchemicalSulfurTier.RARE, AlchemicalSulfurType.METALS);
    public static final DeferredItem<AlchemicalSulfurItem> AZURE_SILVER = SulfurRegistry.registerWithSourceNameOverride(ItemTagRegistry.INGOTS_AZURE_SILVER, AlchemicalSulfurTier.RARE, AlchemicalSulfurType.METALS);
    public static final DeferredItem<AlchemicalSulfurItem> ZINC = SulfurRegistry.registerWithSourceNameOverride(ItemTagRegistry.INGOTS_ZINC, AlchemicalSulfurTier.COMMON, AlchemicalSulfurType.METALS);
    public static final DeferredItem<AlchemicalSulfurItem> OSMIUM = SulfurRegistry.registerWithSourceNameOverride(ItemTagRegistry.INGOTS_OSMIUM, AlchemicalSulfurTier.COMMON, AlchemicalSulfurType.METALS);
    public static final DeferredItem<AlchemicalSulfurItem> NICKEL = SulfurRegistry.registerWithSourceNameOverride(ItemTagRegistry.INGOTS_NICKEL, AlchemicalSulfurTier.COMMON, AlchemicalSulfurType.METALS);
    public static final DeferredItem<AlchemicalSulfurItem> LEAD = SulfurRegistry.registerWithSourceNameOverride(ItemTagRegistry.INGOTS_LEAD, AlchemicalSulfurTier.COMMON, AlchemicalSulfurType.METALS);
    public static final DeferredItem<AlchemicalSulfurItem> ALLTHEMODIUM = SulfurRegistry.registerWithSourceNameOverride(ItemTagRegistry.INGOTS_ALLTHEMODIUM, AlchemicalSulfurTier.PRECIOUS, AlchemicalSulfurType.METALS);
    public static final DeferredItem<AlchemicalSulfurItem> UNOBTAINIUM = SulfurRegistry.registerWithSourceNameOverride(ItemTagRegistry.INGOTS_UNOBTAINIUM, AlchemicalSulfurTier.PRECIOUS, AlchemicalSulfurType.METALS);
    public static final DeferredItem<AlchemicalSulfurItem> IRIDIUM = SulfurRegistry.registerWithSourceNameOverride(ItemTagRegistry.INGOTS_IRIDIUM, AlchemicalSulfurTier.RARE, AlchemicalSulfurType.METALS);
    public static final DeferredItem<AlchemicalSulfurItem> TIN = SulfurRegistry.registerWithSourceNameOverride(ItemTagRegistry.INGOTS_TIN, AlchemicalSulfurTier.COMMON, AlchemicalSulfurType.METALS);
    public static final DeferredItem<AlchemicalSulfurItem> CINNABAR = SulfurRegistry.registerWithSourceNameOverride(ItemTagRegistry.INGOTS_CINNABAR, AlchemicalSulfurTier.COMMON, AlchemicalSulfurType.METALS);
    public static final DeferredItem<AlchemicalSulfurItem> CRIMSON_IRON = SulfurRegistry.registerWithSourceNameOverride(ItemTagRegistry.INGOTS_CRIMSON_IRON, AlchemicalSulfurTier.RARE, AlchemicalSulfurType.METALS);
    public static final DeferredItem<AlchemicalSulfurItem> PLATINUM = SulfurRegistry.registerWithSourceNameOverride(ItemTagRegistry.INGOTS_PLATINUM, AlchemicalSulfurTier.RARE, AlchemicalSulfurType.METALS);
    public static final DeferredItem<AlchemicalSulfurItem> VIBRANIUM = SulfurRegistry.registerWithSourceNameOverride(ItemTagRegistry.INGOTS_VIBRANIUM, AlchemicalSulfurTier.PRECIOUS, AlchemicalSulfurType.METALS);
    public static final DeferredItem<AlchemicalSulfurItem> DESH = SulfurRegistry.registerWithSourceNameOverride(ItemTagRegistry.INGOTS_DESH, AlchemicalSulfurTier.COMMON, AlchemicalSulfurType.METALS);
    public static final DeferredItem<AlchemicalSulfurItem> OSTRUM = SulfurRegistry.registerWithSourceNameOverride(ItemTagRegistry.INGOTS_OSTRUM, AlchemicalSulfurTier.RARE, AlchemicalSulfurType.METALS);
    public static final DeferredItem<AlchemicalSulfurItem> CALORITE = SulfurRegistry.registerWithSourceNameOverride(ItemTagRegistry.INGOTS_CALORITE, AlchemicalSulfurTier.PRECIOUS, AlchemicalSulfurType.METALS);
    public static final DeferredItem<AlchemicalSulfurItem> IESNIUM = SulfurRegistry.registerWithSourceNameOverride(ItemTagRegistry.INGOTS_IESNIUM, AlchemicalSulfurTier.PRECIOUS, AlchemicalSulfurType.METALS);
    public static final DeferredItem<AlchemicalSulfurItem> DIAMOND = SulfurRegistry.registerWithSourceNameOverride((TagKey<Item>)Tags.Items.GEMS_DIAMOND, AlchemicalSulfurTier.PRECIOUS, AlchemicalSulfurType.GEMS);
    public static final DeferredItem<AlchemicalSulfurItem> EMERALD = SulfurRegistry.registerWithSourceNameOverride((TagKey<Item>)Tags.Items.GEMS_EMERALD, AlchemicalSulfurTier.PRECIOUS, AlchemicalSulfurType.GEMS);
    public static final DeferredItem<AlchemicalSulfurItem> LAPIS = SulfurRegistry.registerWithSourceNameOverride((TagKey<Item>)Tags.Items.GEMS_LAPIS, AlchemicalSulfurTier.COMMON, AlchemicalSulfurType.GEMS);
    public static final DeferredItem<AlchemicalSulfurItem> QUARTZ = SulfurRegistry.registerWithSourceNameOverride((TagKey<Item>)Tags.Items.GEMS_QUARTZ, AlchemicalSulfurTier.COMMON, AlchemicalSulfurType.GEMS);
    public static final DeferredItem<AlchemicalSulfurItem> AMETHYST = SulfurRegistry.registerWithSourceNameOverride((TagKey<Item>)Tags.Items.GEMS_AMETHYST, AlchemicalSulfurTier.RARE, AlchemicalSulfurType.GEMS);
    public static final DeferredItem<AlchemicalSulfurItem> PRISMARINE = SulfurRegistry.registerWithSourceNameOverride((TagKey<Item>)Tags.Items.GEMS_PRISMARINE, AlchemicalSulfurTier.RARE, AlchemicalSulfurType.GEMS);
    public static final DeferredItem<AlchemicalSulfurItem> RUBY = SulfurRegistry.registerWithSourceNameOverride(ItemTagRegistry.GEMS_RUBY, AlchemicalSulfurTier.RARE, AlchemicalSulfurType.GEMS);
    public static final DeferredItem<AlchemicalSulfurItem> APATITE = SulfurRegistry.registerWithSourceNameOverride(ItemTagRegistry.GEMS_APATITE, AlchemicalSulfurTier.ABUNDANT, AlchemicalSulfurType.GEMS);
    public static final DeferredItem<AlchemicalSulfurItem> PERIDOT = SulfurRegistry.registerWithSourceNameOverride(ItemTagRegistry.GEMS_PERIDOT, AlchemicalSulfurTier.RARE, AlchemicalSulfurType.GEMS);
    public static final DeferredItem<AlchemicalSulfurItem> FLUORITE = SulfurRegistry.registerWithSourceNameOverride(ItemTagRegistry.GEMS_FLUORITE, AlchemicalSulfurTier.ABUNDANT, AlchemicalSulfurType.GEMS);
    public static final DeferredItem<AlchemicalSulfurItem> SAPPHIRE = SulfurRegistry.registerWithSourceNameOverride(ItemTagRegistry.GEMS_SAPPHIRE, AlchemicalSulfurTier.RARE, AlchemicalSulfurType.GEMS);
    public static final DeferredItem<AlchemicalSulfurItem> SAL_AMMONIAC = SulfurRegistry.registerWithSourceNameOverride(ItemTagRegistry.GEMS_SAL_AMMONIAC, AlchemicalSulfurTier.ABUNDANT, AlchemicalSulfurType.GEMS);
    public static final DeferredItem<AlchemicalSulfurItem> CERTUS_QUARTZ = SulfurRegistry.registerWithSourceNameOverride(ItemTagRegistry.GEMS_CERTUS_QUARTZ, AlchemicalSulfurTier.COMMON, AlchemicalSulfurType.GEMS);
    public static final DeferredItem<AlchemicalSulfurItem> FLUIX = SulfurRegistry.registerWithSourceNameOverride(ItemTagRegistry.GEMS_FLUIX, AlchemicalSulfurTier.RARE, AlchemicalSulfurType.GEMS);
    public static final DeferredItem<AlchemicalSulfurItem> NITER = SulfurRegistry.registerWithSourceNameOverride(ItemTagRegistry.GEMS_NITER, AlchemicalSulfurTier.COMMON, AlchemicalSulfurType.GEMS);
    public static final DeferredItem<AlchemicalSulfurItem> REDSTONE = SulfurRegistry.registerWithSourceNameOverride((TagKey<Item>)Tags.Items.DUSTS_REDSTONE, AlchemicalSulfurTier.COMMON, AlchemicalSulfurType.OTHER_MINERALS);
    public static final DeferredItem<AlchemicalSulfurItem> COAL = SulfurRegistry.registerDefault("coal", (TagKey<Item>)ItemTags.COALS, AlchemicalSulfurTier.ABUNDANT, AlchemicalSulfurType.OTHER_MINERALS);
    public static final DeferredItem<AlchemicalSulfurItem> SULFUR = SulfurRegistry.registerWithSourceNameOverride(ItemTagRegistry.GEMS_SULFUR, AlchemicalSulfurTier.COMMON, AlchemicalSulfurType.OTHER_MINERALS);

    public static boolean keepInItemLists(AlchemicalSulfurItem sulfur) {
        return sulfur.type() == AlchemicalSulfurType.NITER;
    }

    public static DeferredItem<AlchemicalSulfurItem> registerWithTagSourceNameOverride(String name, AlchemicalSulfurTier tier, AlchemicalSulfurType type) {
        return SulfurRegistry.register(name, () -> new AlchemicalSulfurItem(new Item.Properties()).overrideTagSourceName(true).tier(tier).type(type));
    }

    public static DeferredItem<AlchemicalSulfurItem> registerWithTagSourceNameOverride(TagKey<Item> source, AlchemicalSulfurTier tier, AlchemicalSulfurType type) {
        return SulfurRegistry.register(SulfurRegistry.name(source), () -> new AlchemicalSulfurItem(new Item.Properties().component(DataComponentRegistry.SULFUR_SOURCE_TAG, (Object)source)).overrideTagSourceName(true).tier(tier).type(type));
    }

    public static DeferredItem<AlchemicalSulfurItem> registerWithSourceNameOverride(String name, AlchemicalSulfurTier tier, AlchemicalSulfurType type) {
        return SulfurRegistry.register(name, () -> new AlchemicalSulfurItem(new Item.Properties()).overrideSourceName(true).tier(tier).type(type));
    }

    public static DeferredItem<AlchemicalSulfurItem> registerWithSourceNameOverride(TagKey<Item> source, AlchemicalSulfurTier tier, AlchemicalSulfurType type) {
        return SulfurRegistry.register(SulfurRegistry.name(source), () -> new AlchemicalSulfurItem(new Item.Properties().component(DataComponentRegistry.SULFUR_SOURCE_TAG, (Object)source)).overrideSourceName(true).tier(tier).type(type));
    }

    public static DeferredItem<AlchemicalSulfurItem> registerNiter(String name, DeferredItem<?> sourceStack, AlchemicalSulfurTier tier) {
        return SulfurRegistry.register(name, () -> new AlchemicalSulfurItem(new Item.Properties().component(DataComponentRegistry.SULFUR_SOURCE_ITEM, (Object)DeferredHolder.create((ResourceKey)Registries.ITEM, (ResourceLocation)sourceStack.getId()))).overrideSourceName(true).autoTooltip(true, false).autoName(true, false).withJarIcon((Supplier<ItemStack>)Suppliers.memoize(() -> new ItemStack((ItemLike)ItemRegistry.EMPTY_CERAMIC_JAR_ICON.get()))).tier(tier).type(AlchemicalSulfurType.NITER));
    }

    public static DeferredItem<AlchemicalSulfurItem> registerDefault(String name, AlchemicalSulfurTier tier, AlchemicalSulfurType type) {
        return SulfurRegistry.register(name, () -> new AlchemicalSulfurItem(new Item.Properties()).tier(tier).type(type));
    }

    public static DeferredItem<AlchemicalSulfurItem> registerDefault(String name, TagKey<Item> source, AlchemicalSulfurTier tier, AlchemicalSulfurType type) {
        return SulfurRegistry.register(name, () -> new AlchemicalSulfurItem(new Item.Properties().component(DataComponentRegistry.SULFUR_SOURCE_TAG, (Object)source)).tier(tier).type(type));
    }

    public static DeferredItem<AlchemicalSulfurItem> registerDefault(String name, DeferredItem<?> sourceStack, AlchemicalSulfurTier tier, AlchemicalSulfurType type) {
        return SulfurRegistry.register(name, () -> new AlchemicalSulfurItem(new Item.Properties().component(DataComponentRegistry.SULFUR_SOURCE_ITEM, (Object)DeferredHolder.create((ResourceKey)Registries.ITEM, (ResourceLocation)sourceStack.getId()))).tier(tier).type(type));
    }

    public static DeferredItem<AlchemicalSulfurItem> registerDefault(String name, Item sourceStack, AlchemicalSulfurTier tier, AlchemicalSulfurType type) {
        return SulfurRegistry.register(name, () -> new AlchemicalSulfurItem(new Item.Properties().component(DataComponentRegistry.SULFUR_SOURCE_ITEM, (Object)sourceStack.builtInRegistryHolder())).tier(tier).type(type));
    }

    public static <T extends Item> DeferredItem<T> register(String name, Supplier<T> sup) {
        return SULFURS.register("alchemical_sulfur_" + name, sup);
    }

    private static String name(TagKey<Item> source) {
        int slashIndex = source.location().getPath().lastIndexOf("/");
        return source.location().getPath().substring(slashIndex + 1);
    }

    public static void onBuildCreativeModTabs(BuildCreativeModeTabContentsEvent event) {
        if (event.getTab() == CreativeModeTabRegistry.THEURGY.get()) {
            Level level = LevelUtil.getLevelWithoutContext();
            if (level == null) {
                return;
            }
            RecipeManager recipeManager = level.getRecipeManager();
            List liquefactionRecipes = recipeManager.getAllRecipesFor((RecipeType)RecipeTypeRegistry.LIQUEFACTION.get());
            ObjectLinkedOpenCustomHashSet searchDupes = new ObjectLinkedOpenCustomHashSet(ItemStackLinkedSet.TYPE_AND_TAG);
            liquefactionRecipes.forEach(r -> {
                ItemStack stack;
                ItemStack result = ((LiquefactionRecipe)r.value()).getResultItem((HolderLookup.Provider)level.registryAccess());
                if (result != null && !result.isEmpty() && result.getItem() instanceof AlchemicalSulfurItem && !event.getEntries().contains((Object)result) && searchDupes.add((Object)(stack = result.copyWithCount(1)))) {
                    event.accept(stack, event.getTabKey() == CreativeModeTabs.SEARCH ? CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY : CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
                }
            });
            event.accept((ItemLike)GEMS_ABUNDANT.get());
            event.accept((ItemLike)GEMS_COMMON.get());
            event.accept((ItemLike)GEMS_RARE.get());
            event.accept((ItemLike)GEMS_PRECIOUS.get());
            event.accept((ItemLike)METALS_ABUNDANT.get());
            event.accept((ItemLike)METALS_COMMON.get());
            event.accept((ItemLike)METALS_RARE.get());
            event.accept((ItemLike)METALS_PRECIOUS.get());
            event.accept((ItemLike)OTHER_MINERALS_ABUNDANT.get());
            event.accept((ItemLike)OTHER_MINERALS_COMMON.get());
            event.accept((ItemLike)OTHER_MINERALS_RARE.get());
            event.accept((ItemLike)OTHER_MINERALS_PRECIOUS.get());
        }
    }
}

