/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.registry;

import com.klikli_dev.theurgy.content.item.salt.AlchemicalSaltItem;
import com.klikli_dev.theurgy.content.recipe.CalcinationRecipe;
import com.klikli_dev.theurgy.registry.CreativeModeTabRegistry;
import com.klikli_dev.theurgy.registry.RecipeTypeRegistry;
import com.klikli_dev.theurgy.util.LevelUtil;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenCustomHashSet;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemStackLinkedSet;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;

public class SaltRegistry {
    public static final DeferredRegister.Items SALTS = DeferredRegister.createItems((String)"theurgy");
    public static final DeferredItem<AlchemicalSaltItem> STRATA = SaltRegistry.register("strata");
    public static final DeferredItem<AlchemicalSaltItem> MINERAL = SaltRegistry.register("mineral");
    public static final DeferredItem<AlchemicalSaltItem> CROPS = SaltRegistry.register("crops");

    public static <T extends Item> DeferredItem<AlchemicalSaltItem> register(String name) {
        return SaltRegistry.register(name, () -> new AlchemicalSaltItem(new Item.Properties()));
    }

    public static <T extends Item> DeferredItem<T> register(String name, Supplier<T> sup) {
        return SALTS.register("alchemical_salt_" + name, sup);
    }

    public static void onBuildCreativeModTabs(BuildCreativeModeTabContentsEvent event) {
        if (event.getTab() == CreativeModeTabRegistry.THEURGY.get()) {
            Level level = LevelUtil.getLevelWithoutContext();
            if (level == null) {
                return;
            }
            RecipeManager recipeManager = level.getRecipeManager();
            List calcinationRecipes = recipeManager.getAllRecipesFor((RecipeType)RecipeTypeRegistry.CALCINATION.get());
            ObjectLinkedOpenCustomHashSet searchDupes = new ObjectLinkedOpenCustomHashSet(ItemStackLinkedSet.TYPE_AND_TAG);
            SALTS.getEntries().stream().map(DeferredHolder::get).forEach(sulfur -> calcinationRecipes.stream().filter(recipe -> ((CalcinationRecipe)recipe.value()).getResultItem((HolderLookup.Provider)level.registryAccess()) != null && ((CalcinationRecipe)recipe.value()).getResultItem((HolderLookup.Provider)level.registryAccess()).getItem() == sulfur).forEach(recipe -> {
                ItemStack stack = ((CalcinationRecipe)recipe.value()).getResultItem((HolderLookup.Provider)level.registryAccess()).copyWithCount(1);
                if (searchDupes.add((Object)stack)) {
                    event.accept(stack, event.getTabKey() == CreativeModeTabs.SEARCH ? CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY : CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
                }
            }));
        }
    }
}

